/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Iterator;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.HostEntryComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFile {
    private static final Logger _log = LoggerFactory.getLogger(ExportFile.class);
    private volatile Multimap<Integer, FsExport> _exports;
    private final URL _exportFile;

    public ExportFile(File file) throws IOException {
        this(file.toURI().toURL());
    }

    public ExportFile(URL url) throws IOException {
        this._exportFile = url;
        this._exports = ExportFile.parse(this._exportFile);
    }

    public Iterable<FsExport> getExports() {
        return this._exports.values();
    }

    private static Multimap<Integer, FsExport> parse(URL exportFile) throws IOException {
        ImmutableListMultimap.Builder exportsBuilder = ImmutableListMultimap.builder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(exportFile.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) != '/') {
                    _log.warn("Ignoring entry with non absolute export path: " + line);
                    continue;
                }
                int pathEnd = line.indexOf(32);
                if (pathEnd < 0) {
                    FsExport export = new FsExport.FsExportBuilder().build(line);
                    exportsBuilder.put((Object)export.getIndex(), export);
                    continue;
                }
                String path = line.substring(0, pathEnd);
                Splitter splitter = Splitter.on(' ').omitEmptyStrings().trimResults();
                for (String hostAndOptions : splitter.split(line.substring(pathEnd + 1))) {
                    try {
                        FsExport.FsExportBuilder exportBuilder = new FsExport.FsExportBuilder();
                        Iterator<String> s = Splitter.on(CharMatcher.anyOf("(,)")).omitEmptyStrings().trimResults().split(hostAndOptions).iterator();
                        String host = s.next();
                        exportBuilder.forClient(host);
                        while (s.hasNext()) {
                            String option = s.next();
                            if (option.equals("rw")) {
                                exportBuilder.rw();
                                continue;
                            }
                            if (option.equals("ro")) {
                                exportBuilder.ro();
                                continue;
                            }
                            if (option.equals("root_squash")) {
                                exportBuilder.notTrusted();
                                continue;
                            }
                            if (option.equals("no_root_squash")) {
                                exportBuilder.trusted();
                                continue;
                            }
                            if (option.equals("acl")) {
                                exportBuilder.withAcl();
                                continue;
                            }
                            if (option.equals("noacl")) {
                                exportBuilder.withoutAcl();
                                continue;
                            }
                            if (option.equals("all_squash")) {
                                exportBuilder.allSquash();
                                continue;
                            }
                            if (option.startsWith("sec=")) {
                                String secFlavor = option.substring(4);
                                exportBuilder.withSec(FsExport.Sec.valueOf(secFlavor.toUpperCase()));
                                continue;
                            }
                            if (option.startsWith("anonuid=")) {
                                int anonuid = Integer.parseInt(option.substring(8));
                                exportBuilder.withAnonUid(anonuid);
                                continue;
                            }
                            if (option.startsWith("anongid=")) {
                                int anongid = Integer.parseInt(option.substring(8));
                                exportBuilder.withAnonGid(anongid);
                                continue;
                            }
                            if (option.equals("dcap")) {
                                exportBuilder.withDcap();
                                continue;
                            }
                            if (option.equals("no_dcap")) {
                                exportBuilder.withoutDcap();
                                continue;
                            }
                            if (option.equals("all_root")) {
                                exportBuilder.withAllRoot();
                                continue;
                            }
                            if (option.equals("pnfs")) {
                                exportBuilder.withPnfs();
                                continue;
                            }
                            if (option.equals("nopnfs")) {
                                exportBuilder.withoutPnfs();
                                continue;
                            }
                            throw new IllegalArgumentException("Unsupported option: " + option);
                        }
                        FsExport export = exportBuilder.build(path);
                        exportsBuilder.put((Object)export.getIndex(), export);
                    }
                    catch (IllegalArgumentException e) {
                        _log.error("Invalid export entry [" + hostAndOptions + "] : " + e.getMessage());
                    }
                }
            }
        }
        return ((ImmutableListMultimap.Builder)exportsBuilder.orderValuesBy((Comparator)Ordering.from(HostEntryComparator::compare).onResultOf(FsExport::client).reverse())).build();
    }

    public FsExport getExport(String path, InetAddress client) {
        String normalizedPath = FsExport.normalize(path);
        return this.getExport(FsExport.getExportIndex(normalizedPath), client);
    }

    public FsExport getExport(int index, InetAddress client) {
        for (FsExport export : this._exports.get(index)) {
            if (!export.isAllowed(client)) continue;
            return export;
        }
        return null;
    }

    public Iterable<FsExport> exportsFor(InetAddress client) {
        return Iterables.filter(this._exports.values(), new AllowedExports(client));
    }

    public void rescan() throws IOException {
        this._exports = ExportFile.parse(this._exportFile);
    }

    private static class AllowedExports
    implements Predicate<FsExport> {
        private final InetAddress _client;

        public AllowedExports(InetAddress client) {
            this._client = client;
        }

        @Override
        public boolean apply(FsExport export) {
            return export.isAllowed(this._client);
        }
    }
}

