/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public abstract class InetAddressMatcher
implements Predicate<InetAddress> {
    private final String pattern;

    protected InetAddressMatcher(String pattern) {
        this.pattern = pattern;
    }

    public boolean match(InetAddress addr) {
        return this.apply(addr);
    }

    public String getPattern() {
        return this.pattern;
    }

    public static InetAddressMatcher forPattern(String s) throws UnknownHostException {
        String[] hostAndMask = s.split("/");
        Preconditions.checkArgument(hostAndMask.length < 3, "Invalid host specification: " + s);
        if (!InetAddresses.isInetAddress(hostAndMask[0])) {
            Preconditions.checkArgument(hostAndMask.length == 1, "Invalid host specification (hostname with mask): " + s);
            if (s.indexOf(42) != -1 || s.indexOf(63) != -1) {
                return new RegexpNameMatcher(InetAddressMatcher.toRegExp(s));
            }
            return new HostNameMatcher(s);
        }
        InetAddress net = InetAddresses.forString(hostAndMask[0]);
        if (hostAndMask.length == 2) {
            return new IpAddressMatcher(s, net, Integer.parseInt(hostAndMask[1]));
        }
        return new IpAddressMatcher(s, net);
    }

    private static String toRegExp(String s) {
        return s.replace(".", "\\.").replace("?", ".").replace("*", ".*");
    }

    public static class HostNameMatcher
    extends InetAddressMatcher {
        HostNameMatcher(String hostname) throws UnknownHostException {
            super(hostname);
        }

        @Override
        public boolean apply(InetAddress ip) {
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(this.getPattern())) {
                    if (!addr.equals(ip)) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                return false;
            }
            return false;
        }
    }

    public static class RegexpNameMatcher
    extends InetAddressMatcher {
        private final Pattern regexpPattern;

        public RegexpNameMatcher(String pattern) {
            super(pattern);
            this.regexpPattern = Pattern.compile(pattern);
        }

        @Override
        public boolean apply(InetAddress ip) {
            return this.regexpPattern.matcher(ip.getHostName()).matches();
        }
    }

    public static class IpAddressMatcher
    extends InetAddressMatcher {
        private static final int IPv4_FULL_MASK = 32;
        private static final int IPv6_FULL_MASK = 128;
        private static final int IPv6_HALF_MASK = 64;
        private final byte[] netBytes;
        private final int mask;

        private static int fullMaskOf(InetAddress address) {
            if (address instanceof Inet4Address) {
                return 32;
            }
            if (address instanceof Inet6Address) {
                return 128;
            }
            throw new IllegalArgumentException("Unsupported Inet type: " + address.getClass().getName());
        }

        public IpAddressMatcher(String pattern, InetAddress subnet) {
            this(pattern, subnet, IpAddressMatcher.fullMaskOf(subnet));
        }

        public IpAddressMatcher(String pattern, InetAddress subnet, int mask) {
            super(pattern);
            this.netBytes = subnet.getAddress();
            this.mask = mask;
            Preconditions.checkArgument(mask >= 0, "Netmask should be positive");
            if (this.netBytes.length == 4) {
                Preconditions.checkArgument(mask <= 32, "Netmask for ipv4 can't be bigger than32");
            } else {
                Preconditions.checkArgument(mask <= 128, "Netmask for ipv6 can't be bigger than128");
            }
        }

        @Override
        public boolean apply(InetAddress ip) {
            byte[] ipBytes = ip.getAddress();
            if (ipBytes.length != this.netBytes.length) {
                return false;
            }
            if (ipBytes.length == 4) {
                int netAsBytes;
                int ipAsInt = Ints.fromByteArray(ipBytes);
                return (ipAsInt ^ (netAsBytes = Ints.fromByteArray(this.netBytes))) >> 32 - this.mask == 0;
            }
            long ipAsLong0 = Longs.fromBytes(ipBytes[0], ipBytes[1], ipBytes[2], ipBytes[3], ipBytes[4], ipBytes[5], ipBytes[6], ipBytes[7]);
            long netAsLong0 = Longs.fromBytes(this.netBytes[0], this.netBytes[1], this.netBytes[2], this.netBytes[3], this.netBytes[4], this.netBytes[5], this.netBytes[6], this.netBytes[7]);
            if (this.mask > 64) {
                long ipAsLong1 = Longs.fromBytes(ipBytes[8], ipBytes[9], ipBytes[10], ipBytes[11], ipBytes[12], ipBytes[13], ipBytes[14], ipBytes[15]);
                long netAsLong1 = Longs.fromBytes(this.netBytes[8], this.netBytes[9], this.netBytes[10], this.netBytes[11], this.netBytes[12], this.netBytes[13], this.netBytes[14], this.netBytes[15]);
                return ipAsLong0 == netAsLong0 & (ipAsLong1 ^ netAsLong1) >> 128 - this.mask == 0L;
            }
            return (ipAsLong0 ^ netAsLong0) >> 64 - this.mask == 0L;
        }
    }
}

