/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v3;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.FsExport;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.PermException;
import org.dcache.nfs.v3.xdr.dirpath;
import org.dcache.nfs.v3.xdr.exportnode;
import org.dcache.nfs.v3.xdr.exports;
import org.dcache.nfs.v3.xdr.fhandle3;
import org.dcache.nfs.v3.xdr.fhstatus;
import org.dcache.nfs.v3.xdr.groupnode;
import org.dcache.nfs.v3.xdr.groups;
import org.dcache.nfs.v3.xdr.mount_protServerStub;
import org.dcache.nfs.v3.xdr.mountbody;
import org.dcache.nfs.v3.xdr.mountlist;
import org.dcache.nfs.v3.xdr.mountres3;
import org.dcache.nfs.v3.xdr.mountres3_ok;
import org.dcache.nfs.v3.xdr.name;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.PseudoFs;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountServer
extends mount_protServerStub {
    private static final Logger _log = LoggerFactory.getLogger(MountServer.class);
    private final ExportFile _exportFile;
    private final Map<String, Set<String>> _mounts = new HashMap<String, Set<String>>();
    private final VirtualFileSystem _vfs;
    public static final int RPC_AUTH_GSS_KRB5 = 390003;
    public static final int RPC_AUTH_GSS_KRB5I = 390004;
    public static final int RPC_AUTH_GSS_KRB5P = 390005;

    public MountServer(ExportFile exportFile, VirtualFileSystem fs) {
        this._exportFile = exportFile;
        this._vfs = fs;
    }

    @Override
    public void MOUNTPROC3_NULL_3(RpcCall call$) {
    }

    @Override
    public mountres3 MOUNTPROC3_MNT_3(RpcCall call$, dirpath arg1) {
        mountres3 m = new mountres3();
        File f = new File(arg1.value);
        String mountPoint = f.getAbsolutePath();
        _log.debug("Mount request for: {}", (Object)mountPoint);
        FsExport export = this._exportFile.getExport(mountPoint, call$.getTransport().getRemoteSocketAddress().getAddress());
        if (export == null) {
            m.fhs_status = 13;
            _log.info("Mount deny for: {}:{}", (Object)call$.getTransport().getRemoteSocketAddress().getHostName(), (Object)mountPoint);
            return m;
        }
        m.mountinfo = new mountres3_ok();
        try {
            Inode rootInode = MountServer.path2Inode(this._vfs, mountPoint);
            Stat stat = this._vfs.getattr(rootInode);
            if (stat.type() == Stat.Type.SYMLINK) {
                String path = this._vfs.readlink(rootInode);
                rootInode = MountServer.path2Inode(this._vfs, path);
                stat = this._vfs.getattr(rootInode);
            }
            if (stat.type() != Stat.Type.DIRECTORY) {
                throw new NotDirException("Path is not a directory");
            }
            byte[] b = PseudoFs.pseudoIdToReal(rootInode, export.getIndex()).toNfsHandle();
            m.fhs_status = 0;
            m.mountinfo.fhandle = new fhandle3(b);
            m.mountinfo.auth_flavors = this.exportSecFlavors(export);
            if (this._mounts.containsKey(mountPoint)) {
                Set<String> s = this._mounts.get(mountPoint);
                s.add(call$.getTransport().getRemoteSocketAddress().getHostName());
            } else {
                HashSet<String> s = new HashSet<String>();
                s.add(call$.getTransport().getRemoteSocketAddress().getHostName());
                this._mounts.put(mountPoint, s);
            }
        }
        catch (ChimeraNFSException e) {
            _log.warn("mount request failed: ", (Object)e.getMessage());
            m.fhs_status = e.getStatus();
        }
        catch (IOException e) {
            m.fhs_status = 10006;
        }
        return m;
    }

    @Override
    public mountlist MOUNTPROC3_DUMP_3(RpcCall call$) {
        mountlist mFullList;
        mountlist mList = mFullList = new mountlist();
        mList.value = null;
        for (Map.Entry<String, Set<String>> mountEntry : this._mounts.entrySet()) {
            String path = mountEntry.getKey();
            Set<String> s = mountEntry.getValue();
            for (String host : s) {
                mList.value = new mountbody();
                mList.value.ml_directory = new dirpath(path);
                try {
                    mList.value.ml_hostname = new name(InetAddress.getByName(host).getHostName());
                }
                catch (UnknownHostException e) {
                    mList.value.ml_hostname = new name(host);
                }
                mList.value.ml_next = new mountlist();
                mList.value.ml_next.value = null;
                mList = mList.value.ml_next;
            }
        }
        return mFullList;
    }

    @Override
    public void MOUNTPROC3_UMNT_3(RpcCall call$, dirpath arg1) {
        Set<String> s = this._mounts.get(arg1.value);
        if (s != null) {
            s.remove(call$.getTransport().getRemoteSocketAddress().getHostName());
        }
    }

    @Override
    public void MOUNTPROC3_UMNTALL_3(RpcCall call$) {
    }

    @Override
    public exports MOUNTPROC3_EXPORT_3(RpcCall call$) {
        exports eFullList;
        exports eList = eFullList = new exports();
        eList.value = null;
        Multimap<String, String> exports2 = this.groupBy(this._exportFile.getExports());
        for (String path : exports2.keySet()) {
            eList.value = new exportnode();
            eList.value.ex_dir = new dirpath(path);
            eList.value.ex_groups = new groups();
            eList.value.ex_groups.value = null;
            groups g = eList.value.ex_groups;
            for (String client : exports2.get(path)) {
                g.value = new groupnode();
                g.value.gr_name = new name(client);
                g.value.gr_next = new groups();
                g.value.gr_next.value = null;
                g = g.value.gr_next;
            }
            eList.value.ex_next = new exports();
            eList.value.ex_next.value = null;
            eList = eList.value.ex_next;
        }
        return eFullList;
    }

    @Override
    public void MOUNTPROC_NULL_1(RpcCall call$) {
    }

    @Override
    public fhstatus MOUNTPROC_MNT_1(RpcCall call$, dirpath arg1) {
        return null;
    }

    @Override
    public mountlist MOUNTPROC_DUMP_1(RpcCall call$) {
        return this.MOUNTPROC3_DUMP_3(call$);
    }

    @Override
    public void MOUNTPROC_UMNT_1(RpcCall call$, dirpath arg1) {
        this.MOUNTPROC3_UMNT_3(call$, arg1);
    }

    @Override
    public void MOUNTPROC_UMNTALL_1(RpcCall call$) {
    }

    @Override
    public exports MOUNTPROC_EXPORT_1(RpcCall call$) {
        return this.MOUNTPROC3_EXPORT_3(call$);
    }

    @Override
    public exports MOUNTPROC_EXPORTALL_1(RpcCall call$) {
        return null;
    }

    private static Inode path2Inode(VirtualFileSystem fs, String path) throws ChimeraNFSException, IOException {
        Splitter splitter = Splitter.on('/').omitEmptyStrings();
        Inode inode = fs.getRootInode();
        for (String pathElement : splitter.split(path)) {
            inode = fs.lookup(inode, pathElement);
        }
        return inode;
    }

    private Multimap<String, String> groupBy(Iterable<FsExport> exports2) {
        HashMultimap<String, String> asMultiMap = HashMultimap.create();
        for (FsExport export : exports2) {
            asMultiMap.put(export.getPath(), export.client());
        }
        return asMultiMap;
    }

    private int[] exportSecFlavors(FsExport export) throws ChimeraNFSException {
        int[] supportedFlavors;
        FsExport.Sec sec = export.getSec();
        switch (sec) {
            case KRB5: {
                supportedFlavors = new int[]{390003, 390004, 390005};
                break;
            }
            case KRB5I: {
                supportedFlavors = new int[]{390004, 390005};
                break;
            }
            case KRB5P: {
                supportedFlavors = new int[]{390005};
                break;
            }
            case SYS: {
                supportedFlavors = new int[]{390003, 390004, 390005, 1};
                break;
            }
            case NONE: {
                supportedFlavors = new int[]{390003, 390004, 390005, 1, 0};
                break;
            }
            default: {
                throw new PermException("Unsupported secutiry flavor");
            }
        }
        return supportedFlavors;
    }
}

