/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v3;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.InodeCacheEntry;
import org.dcache.nfs.status.BadCookieException;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.status.TooSmallException;
import org.dcache.nfs.v3.HimeraNfsUtils;
import org.dcache.nfs.v3.NameUtils;
import org.dcache.nfs.v3.xdr.ACCESS3args;
import org.dcache.nfs.v3.xdr.ACCESS3res;
import org.dcache.nfs.v3.xdr.ACCESS3resfail;
import org.dcache.nfs.v3.xdr.ACCESS3resok;
import org.dcache.nfs.v3.xdr.COMMIT3args;
import org.dcache.nfs.v3.xdr.COMMIT3res;
import org.dcache.nfs.v3.xdr.COMMIT3resfail;
import org.dcache.nfs.v3.xdr.COMMIT3resok;
import org.dcache.nfs.v3.xdr.CREATE3args;
import org.dcache.nfs.v3.xdr.CREATE3res;
import org.dcache.nfs.v3.xdr.CREATE3resfail;
import org.dcache.nfs.v3.xdr.CREATE3resok;
import org.dcache.nfs.v3.xdr.FSINFO3args;
import org.dcache.nfs.v3.xdr.FSINFO3res;
import org.dcache.nfs.v3.xdr.FSINFO3resfail;
import org.dcache.nfs.v3.xdr.FSINFO3resok;
import org.dcache.nfs.v3.xdr.FSSTAT3args;
import org.dcache.nfs.v3.xdr.FSSTAT3res;
import org.dcache.nfs.v3.xdr.FSSTAT3resfail;
import org.dcache.nfs.v3.xdr.FSSTAT3resok;
import org.dcache.nfs.v3.xdr.GETATTR3args;
import org.dcache.nfs.v3.xdr.GETATTR3res;
import org.dcache.nfs.v3.xdr.GETATTR3resok;
import org.dcache.nfs.v3.xdr.LINK3args;
import org.dcache.nfs.v3.xdr.LINK3res;
import org.dcache.nfs.v3.xdr.LINK3resfail;
import org.dcache.nfs.v3.xdr.LINK3resok;
import org.dcache.nfs.v3.xdr.LOOKUP3args;
import org.dcache.nfs.v3.xdr.LOOKUP3res;
import org.dcache.nfs.v3.xdr.LOOKUP3resfail;
import org.dcache.nfs.v3.xdr.LOOKUP3resok;
import org.dcache.nfs.v3.xdr.MKDIR3args;
import org.dcache.nfs.v3.xdr.MKDIR3res;
import org.dcache.nfs.v3.xdr.MKDIR3resfail;
import org.dcache.nfs.v3.xdr.MKDIR3resok;
import org.dcache.nfs.v3.xdr.MKNOD3args;
import org.dcache.nfs.v3.xdr.MKNOD3res;
import org.dcache.nfs.v3.xdr.MKNOD3resfail;
import org.dcache.nfs.v3.xdr.PATHCONF3args;
import org.dcache.nfs.v3.xdr.PATHCONF3res;
import org.dcache.nfs.v3.xdr.PATHCONF3resok;
import org.dcache.nfs.v3.xdr.READ3args;
import org.dcache.nfs.v3.xdr.READ3res;
import org.dcache.nfs.v3.xdr.READ3resfail;
import org.dcache.nfs.v3.xdr.READ3resok;
import org.dcache.nfs.v3.xdr.READDIR3args;
import org.dcache.nfs.v3.xdr.READDIR3res;
import org.dcache.nfs.v3.xdr.READDIR3resfail;
import org.dcache.nfs.v3.xdr.READDIR3resok;
import org.dcache.nfs.v3.xdr.READDIRPLUS3args;
import org.dcache.nfs.v3.xdr.READDIRPLUS3res;
import org.dcache.nfs.v3.xdr.READDIRPLUS3resfail;
import org.dcache.nfs.v3.xdr.READDIRPLUS3resok;
import org.dcache.nfs.v3.xdr.READLINK3args;
import org.dcache.nfs.v3.xdr.READLINK3res;
import org.dcache.nfs.v3.xdr.READLINK3resfail;
import org.dcache.nfs.v3.xdr.READLINK3resok;
import org.dcache.nfs.v3.xdr.REMOVE3args;
import org.dcache.nfs.v3.xdr.REMOVE3res;
import org.dcache.nfs.v3.xdr.REMOVE3resfail;
import org.dcache.nfs.v3.xdr.REMOVE3resok;
import org.dcache.nfs.v3.xdr.RENAME3args;
import org.dcache.nfs.v3.xdr.RENAME3res;
import org.dcache.nfs.v3.xdr.RENAME3resfail;
import org.dcache.nfs.v3.xdr.RENAME3resok;
import org.dcache.nfs.v3.xdr.RMDIR3args;
import org.dcache.nfs.v3.xdr.RMDIR3res;
import org.dcache.nfs.v3.xdr.RMDIR3resfail;
import org.dcache.nfs.v3.xdr.RMDIR3resok;
import org.dcache.nfs.v3.xdr.SETATTR3args;
import org.dcache.nfs.v3.xdr.SETATTR3res;
import org.dcache.nfs.v3.xdr.SETATTR3resfail;
import org.dcache.nfs.v3.xdr.SETATTR3resok;
import org.dcache.nfs.v3.xdr.SYMLINK3args;
import org.dcache.nfs.v3.xdr.SYMLINK3res;
import org.dcache.nfs.v3.xdr.SYMLINK3resfail;
import org.dcache.nfs.v3.xdr.SYMLINK3resok;
import org.dcache.nfs.v3.xdr.WRITE3args;
import org.dcache.nfs.v3.xdr.WRITE3res;
import org.dcache.nfs.v3.xdr.WRITE3resfail;
import org.dcache.nfs.v3.xdr.WRITE3resok;
import org.dcache.nfs.v3.xdr.cookie3;
import org.dcache.nfs.v3.xdr.cookieverf3;
import org.dcache.nfs.v3.xdr.count3;
import org.dcache.nfs.v3.xdr.dirlist3;
import org.dcache.nfs.v3.xdr.dirlistplus3;
import org.dcache.nfs.v3.xdr.entry3;
import org.dcache.nfs.v3.xdr.entryplus3;
import org.dcache.nfs.v3.xdr.fattr3;
import org.dcache.nfs.v3.xdr.fileid3;
import org.dcache.nfs.v3.xdr.filename3;
import org.dcache.nfs.v3.xdr.nfs3_protServerStub;
import org.dcache.nfs.v3.xdr.nfs_fh3;
import org.dcache.nfs.v3.xdr.nfspath3;
import org.dcache.nfs.v3.xdr.nfstime3;
import org.dcache.nfs.v3.xdr.post_op_attr;
import org.dcache.nfs.v3.xdr.post_op_fh3;
import org.dcache.nfs.v3.xdr.pre_op_attr;
import org.dcache.nfs.v3.xdr.sattr3;
import org.dcache.nfs.v3.xdr.size3;
import org.dcache.nfs.v3.xdr.uint32;
import org.dcache.nfs.v3.xdr.uint64;
import org.dcache.nfs.v3.xdr.wcc_attr;
import org.dcache.nfs.v3.xdr.wcc_data;
import org.dcache.nfs.v3.xdr.writeverf3;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.PseudoFs;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.utils.Bytes;
import org.dcache.utils.GuavaCacheMXBean;
import org.dcache.utils.GuavaCacheMXBeanImpl;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfsServerV3
extends nfs3_protServerStub {
    private static final int ENTRY3_SIZE = 24;
    private static final int ENTRYPLUS3_SIZE = 124;
    private static final int READDIR3RESOK_SIZE = 104;
    private static final int READDIRPLUS3RESOK_SIZE = 104;
    private static final Logger _log = LoggerFactory.getLogger(NfsServerV3.class);
    private final VirtualFileSystem _vfs;
    private final ExportFile _exports;
    private final Cache<InodeCacheEntry<cookieverf3>, List<DirectoryEntry>> _dlCacheFull = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).softValues().maximumSize(512L).recordStats().build();
    private final GuavaCacheMXBean CACHE_MXBEAN = new GuavaCacheMXBeanImpl("READDIR3", this._dlCacheFull);
    private final writeverf3 writeVerifier = NfsServerV3.generateInstanceWriteVerifier();

    public NfsServerV3(ExportFile exports2, VirtualFileSystem fs) throws OncRpcException, IOException {
        this._vfs = fs;
        this._exports = exports2;
    }

    private static writeverf3 generateInstanceWriteVerifier() {
        writeverf3 verf = new writeverf3();
        verf.value = new byte[8];
        Bytes.putLong(verf.value, 0, System.currentTimeMillis());
        return verf;
    }

    @Override
    public ACCESS3res NFSPROC3_ACCESS_3(RpcCall call$, ACCESS3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        ACCESS3res res = new ACCESS3res();
        _log.debug("NFS Request ACCESS uid: {}", (Object)call$.getCredential());
        try {
            res.status = 0;
            res.resok = new ACCESS3resok();
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            Inode inode = new Inode(arg1.object.data);
            Stat objStat = fs.getattr(inode);
            HimeraNfsUtils.fill_attributes(objStat, res.resok.obj_attributes.attributes);
            int realAccess = fs.access(inode, arg1.access.value);
            res.resok.access = new uint32(realAccess);
        }
        catch (ChimeraNFSException hne) {
            _log.error("ACCESS: {}", hne);
            res.status = hne.getStatus();
            res.resfail = new ACCESS3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("ACCESS", e);
            res.status = 10006;
            res.resfail = new ACCESS3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public COMMIT3res NFSPROC3_COMMIT_3(RpcCall call$, COMMIT3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        COMMIT3res res = new COMMIT3res();
        try {
            Inode inode = new Inode(arg1.file.data);
            long offset = arg1.offset.value.value;
            int count = arg1.count.value.value;
            fs.commit(inode, offset, count);
            res.resok = new COMMIT3resok();
            res.resok.file_wcc = new wcc_data();
            res.resok.file_wcc.after = new post_op_attr();
            res.resok.file_wcc.after.attributes_follow = true;
            res.resok.file_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.file_wcc.after.attributes);
            res.resok.file_wcc.before = new pre_op_attr();
            res.resok.file_wcc.before.attributes_follow = false;
            res.resok.verf = this.writeVerifier;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new COMMIT3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("COMMIT", e);
            res.status = 10006;
            res.resfail = new COMMIT3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public CREATE3res NFSPROC3_CREATE_3(RpcCall call$, CREATE3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request CREATE3 uid: {}", (Object)call$.getCredential());
        CREATE3res res = new CREATE3res();
        String path = arg1.where.name.value;
        try {
            NameUtils.checkFilename(path);
            Inode parent = new Inode(arg1.where.dir.data);
            sattr3 newAttr = null;
            int mode = arg1.how.mode;
            if (mode == 0 || mode == 1) {
                newAttr = arg1.how.obj_attributes;
            }
            Inode inode = null;
            Stat parentStat = null;
            boolean exists = true;
            long now = System.currentTimeMillis();
            try {
                inode = fs.lookup(parent, path);
            }
            catch (NoEntException e) {
                exists = false;
            }
            if (exists && mode != 0) {
                throw new ExistException("File alredy exist.");
            }
            parentStat = fs.getattr(parent);
            int fmode = 33188;
            if (newAttr != null) {
                fmode = newAttr.mode.mode.value.value | 0x8000;
            }
            inode = fs.create(parent, Stat.Type.REGULAR, path, call$.getCredential().getSubject(), fmode);
            Stat inodeStat = fs.getattr(inode);
            res.status = 0;
            res.resok = new CREATE3resok();
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inodeStat, res.resok.obj_attributes.attributes);
            res.resok.obj = new post_op_fh3();
            res.resok.obj.handle_follows = true;
            res.resok.obj.handle = new nfs_fh3();
            res.resok.obj.handle.data = inode.toNfsHandle();
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(now);
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = false;
        }
        catch (ChimeraNFSException hne) {
            _log.debug(hne.getMessage());
            res.resfail = new CREATE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("create", e);
            res.status = 10006;
            res.resfail = new CREATE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public FSINFO3res NFSPROC3_FSINFO_3(RpcCall call$, FSINFO3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request FSINFO from: {}", (Object)call$.getCredential());
        FSINFO3res res = new FSINFO3res();
        try {
            Inode inode = new Inode(arg1.fsroot.data);
            res.status = 0;
            res.resok = new FSINFO3resok();
            res.resok.rtmax = new uint32(32768);
            res.resok.rtpref = new uint32(32768);
            res.resok.rtmult = new uint32(8);
            res.resok.wtmax = new uint32(32768);
            res.resok.wtpref = new uint32(32768);
            res.resok.wtmult = new uint32(8);
            res.resok.dtpref = new uint32(8192);
            res.resok.maxfilesize = new size3(new uint64(0x100000000L));
            nfstime3 time = new nfstime3();
            time.seconds = new uint32(1);
            time.nseconds = new uint32(0);
            res.resok.time_delta = time;
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_attributes.attributes);
            res.resok.properties = new uint32(27);
        }
        catch (Exception e) {
            _log.error("FSINFO", e);
            res.status = 10006;
            res.resfail = new FSINFO3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public FSSTAT3res NFSPROC3_FSSTAT_3(RpcCall call$, FSSTAT3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        FSSTAT3res res = new FSSTAT3res();
        try {
            res.status = 0;
            res.resok = new FSSTAT3resok();
            FsStat fsStat = fs.getFsStat();
            res.resok.tbytes = new size3(new uint64(fsStat.getTotalSpace()));
            res.resok.fbytes = new size3(new uint64(fsStat.getTotalSpace() - fsStat.getUsedSpace()));
            res.resok.abytes = new size3(new uint64(fsStat.getTotalSpace() - fsStat.getUsedSpace()));
            res.resok.tfiles = new size3(new uint64(fsStat.getTotalFiles()));
            res.resok.ffiles = new size3(new uint64(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
            res.resok.afiles = new size3(new uint64(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
            res.resok.invarsec = new uint32(0);
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            Inode inode = new Inode(arg1.fsroot.data);
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_attributes.attributes);
        }
        catch (Exception e) {
            _log.error("FSSTAT", e);
            res.status = 10006;
            res.resfail = new FSSTAT3resfail();
            res.resfail.obj_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public GETATTR3res NFSPROC3_GETATTR_3(RpcCall call$, GETATTR3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request GETTATTR3 uid: {}", (Object)call$.getCredential());
        GETATTR3res res = new GETATTR3res();
        try {
            Inode inode = new Inode(arg1.object.data);
            _log.debug("NFS Request GETATTR for inode: {}", (Object)inode.toString());
            res.status = 0;
            res.resok = new GETATTR3resok();
            res.resok.obj_attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_attributes);
        }
        catch (ChimeraNFSException e) {
            res.status = e.getStatus();
        }
        catch (Exception e) {
            _log.error("GETATTR", e);
            res.status = 10006;
        }
        return res;
    }

    @Override
    public LINK3res NFSPROC3_LINK_3(RpcCall call$, LINK3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request LINK3 uid: {}", (Object)call$.getCredential());
        LINK3res res = new LINK3res();
        try {
            Inode parent = new Inode(arg1.link.dir.data);
            String name2 = arg1.link.name.value;
            NameUtils.checkFilename(name2);
            Inode hlink = new Inode(arg1.file.data);
            Stat parentStat = fs.getattr(parent);
            fs.link(parent, hlink, name2, call$.getCredential().getSubject());
            res.resok = new LINK3resok();
            res.resok.file_attributes = new post_op_attr();
            res.resok.file_attributes.attributes_follow = true;
            res.resok.file_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(hlink), res.resok.file_attributes.attributes);
            res.resok.linkdir_wcc = new wcc_data();
            res.resok.linkdir_wcc.after = new post_op_attr();
            res.resok.linkdir_wcc.after.attributes_follow = true;
            res.resok.linkdir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(System.currentTimeMillis());
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.linkdir_wcc.after.attributes);
            res.resok.linkdir_wcc.before = new pre_op_attr();
            res.resok.linkdir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new LINK3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.resfail.linkdir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("LINK", e);
            res.status = 10006;
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.resfail.linkdir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public LOOKUP3res NFSPROC3_LOOKUP_3(RpcCall call$, LOOKUP3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        LOOKUP3res res = new LOOKUP3res();
        try {
            Inode parent = new Inode(arg1.what.dir.data);
            String name2 = arg1.what.name.value;
            NameUtils.checkFilename(name2);
            Inode inode = fs.lookup(parent, name2);
            res.status = 0;
            res.resok = new LOOKUP3resok();
            nfs_fh3 fh3 = new nfs_fh3();
            fh3.data = inode.toNfsHandle();
            res.resok.object = fh3;
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_attributes.attributes);
            res.resok.dir_attributes = new post_op_attr();
            res.resok.dir_attributes.attributes_follow = true;
            res.resok.dir_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(parent), res.resok.dir_attributes.attributes);
        }
        catch (ChimeraNFSException hne) {
            _log.debug("lookup {}", (Object)hne.toString());
            res.status = hne.getStatus();
            res.resfail = new LOOKUP3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("LOOKUP", e);
            res.status = 10006;
            res.resfail = new LOOKUP3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public MKDIR3res NFSPROC3_MKDIR_3(RpcCall call$, MKDIR3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request MKDIR3 uid: {}", (Object)call$.getCredential());
        MKDIR3res res = new MKDIR3res();
        try {
            Inode parent = new Inode(arg1.where.dir.data);
            String name2 = arg1.where.name.value;
            NameUtils.checkFilename(name2);
            sattr3 attr = arg1.attributes;
            Stat parentStat = fs.getattr(parent);
            int mode = 511;
            if (attr != null) {
                mode = attr.mode.mode.value.value | 0x4000;
            }
            Inode inode = fs.mkdir(parent, name2, call$.getCredential().getSubject(), mode);
            res.resok = new MKDIR3resok();
            res.resok.obj = new post_op_fh3();
            res.resok.obj.handle_follows = true;
            res.resok.obj.handle = new nfs_fh3();
            res.resok.obj.handle.data = inode.toNfsHandle();
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_attributes.attributes);
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(System.currentTimeMillis());
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.resfail = new MKDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("MKDIR", e);
            res.status = 10006;
            res.resfail = new MKDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public MKNOD3res NFSPROC3_MKNOD_3(RpcCall call$, MKNOD3args arg1) {
        MKNOD3res res = new MKNOD3res();
        res.status = 10004;
        res.resfail = new MKNOD3resfail();
        res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        return res;
    }

    @Override
    public void NFSPROC3_NULL_3(RpcCall call$) {
    }

    @Override
    public PATHCONF3res NFSPROC3_PATHCONF_3(RpcCall call$, PATHCONF3args arg1) {
        PATHCONF3res res = new PATHCONF3res();
        res.resok = new PATHCONF3resok();
        res.resok.case_insensitive = false;
        res.resok.case_preserving = true;
        res.resok.chown_restricted = false;
        res.resok.no_trunc = true;
        res.resok.linkmax = new uint32(512);
        res.resok.name_max = new uint32(256);
        res.resok.obj_attributes = new post_op_attr();
        res.resok.obj_attributes.attributes_follow = false;
        res.status = 0;
        return res;
    }

    private cookieverf3 generateDirectoryVerifier(Stat dirStat) throws IllegalArgumentException {
        byte[] verifier = new byte[8];
        Bytes.putLong(verifier, 0, dirStat.getGeneration());
        return new cookieverf3(verifier);
    }

    @Override
    public READDIRPLUS3res NFSPROC3_READDIRPLUS_3(RpcCall call$, READDIRPLUS3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request READDIRPLUS3 uid: {}", (Object)call$.getCredential());
        READDIRPLUS3res res = new READDIRPLUS3res();
        try {
            InodeCacheEntry<cookieverf3> cacheKey;
            Inode dir = new Inode(arg1.dir.data);
            Stat dirStat = fs.getattr(dir);
            if (dirStat.type() != Stat.Type.DIRECTORY) {
                throw new NotDirException("Path is not a directory.");
            }
            long startValue = arg1.cookie.value.value;
            List<DirectoryEntry> dirList = null;
            boolean validateVerifier = false;
            cookieverf3 cookieverf = arg1.cookieverf;
            if (startValue != 0L) {
                ++startValue;
                cacheKey = new InodeCacheEntry<cookieverf3>(dir, cookieverf);
                dirList = this._dlCacheFull.getIfPresent(cacheKey);
                if (dirList == null) {
                    validateVerifier = true;
                    _log.debug("Directory listing for expired cookie verifier");
                }
            }
            if (dirList == null) {
                cookieverf = this.generateDirectoryVerifier(dirStat);
                if (validateVerifier && !cookieverf.equals(arg1.cookieverf)) {
                    throw new BadCookieException("readdir verifier expired");
                }
                cacheKey = new InodeCacheEntry<cookieverf3>(dir, cookieverf);
                dirList = this.fetchDirectoryListing(cacheKey, fs, dir);
            }
            if (startValue != 0L && startValue >= (long)dirList.size()) {
                throw new BadCookieException("invalid start value");
            }
            res.status = 0;
            res.resok = new READDIRPLUS3resok();
            res.resok.reply = new dirlistplus3();
            res.resok.dir_attributes = new post_op_attr();
            res.resok.dir_attributes.attributes_follow = true;
            res.resok.dir_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(dirStat, res.resok.dir_attributes.attributes);
            res.resok.cookieverf = cookieverf;
            if (dirList.isEmpty()) {
                res.resok.reply.eof = true;
                return res;
            }
            int currcount = 104;
            int dircount = 0;
            entryplus3 currentEntry = res.resok.reply.entries = new entryplus3();
            entryplus3 lastEntry = null;
            for (long i = startValue; i < (long)dirList.size(); ++i) {
                DirectoryEntry le = dirList.get((int)i);
                String name2 = le.getName();
                Inode ef = le.getInode();
                currentEntry.fileid = new fileid3(new uint64(le.getStat().getFileId()));
                currentEntry.name = new filename3(name2);
                currentEntry.cookie = new cookie3(new uint64(i));
                currentEntry.name_handle = new post_op_fh3();
                currentEntry.name_handle.handle_follows = true;
                currentEntry.name_handle.handle = new nfs_fh3();
                currentEntry.name_handle.handle.data = ef.toNfsHandle();
                currentEntry.name_attributes = new post_op_attr();
                currentEntry.name_attributes.attributes_follow = true;
                currentEntry.name_attributes.attributes = new fattr3();
                HimeraNfsUtils.fill_attributes(le.getStat(), currentEntry.name_attributes.attributes);
                currentEntry.nextentry = null;
                int newSize = 124 + name2.length() + currentEntry.name_handle.handle.data.length;
                int newDirSize = name2.length();
                if (currcount + newSize > arg1.maxcount.value.value || dircount + newDirSize > arg1.dircount.value.value) {
                    if (lastEntry == null) {
                        throw new TooSmallException("can't send even a single entry");
                    }
                    lastEntry.nextentry = null;
                    res.resok.reply.eof = false;
                    _log.debug("Sending {} entries ( {} bytes from {}, dircount = {} from {} ) cookie = {} total {}", i - startValue, currcount, arg1.maxcount.value.value, dircount, arg1.dircount.value.value, startValue, dirList.size());
                    return res;
                }
                dircount += newDirSize;
                currcount += newSize;
                if (i + 1L >= (long)dirList.size()) continue;
                lastEntry = currentEntry;
                currentEntry = currentEntry.nextentry = new entryplus3();
            }
            res.resok.reply.eof = true;
        }
        catch (ChimeraNFSException hne) {
            _log.debug("READDIRPLUS3 status: {}", (Object)hne.toString());
            res.resfail = new READDIRPLUS3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("READDIRPLUS3", e);
            res.status = 10006;
            res.resfail = new READDIRPLUS3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public READDIR3res NFSPROC3_READDIR_3(RpcCall call$, READDIR3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request READDIR3 uid: {}", (Object)call$.getCredential());
        READDIR3res res = new READDIR3res();
        try {
            InodeCacheEntry<cookieverf3> cacheKey;
            Inode dir = new Inode(arg1.dir.data);
            Stat dirStat = fs.getattr(dir);
            if (dirStat.type() != Stat.Type.DIRECTORY) {
                throw new NotDirException("Path is not a directory.");
            }
            long startValue = arg1.cookie.value.value;
            List<DirectoryEntry> dirList = null;
            boolean validateVerifier = false;
            cookieverf3 cookieverf = arg1.cookieverf;
            if (startValue != 0L) {
                ++startValue;
                cacheKey = new InodeCacheEntry<cookieverf3>(dir, cookieverf);
                dirList = this._dlCacheFull.getIfPresent(cacheKey);
                if (dirList == null) {
                    validateVerifier = true;
                    _log.debug("Directory listing for expired cookie verifier");
                }
            }
            if (dirList == null) {
                cookieverf = this.generateDirectoryVerifier(dirStat);
                if (validateVerifier && !cookieverf.equals(arg1.cookieverf)) {
                    throw new BadCookieException("readdir verifier expired");
                }
                cacheKey = new InodeCacheEntry<cookieverf3>(dir, cookieverf);
                dirList = this.fetchDirectoryListing(cacheKey, fs, dir);
            }
            if (startValue != 0L && startValue >= (long)dirList.size()) {
                throw new BadCookieException("invalid start value");
            }
            res.status = 0;
            res.resok = new READDIR3resok();
            res.resok.reply = new dirlist3();
            res.resok.dir_attributes = new post_op_attr();
            res.resok.dir_attributes.attributes_follow = true;
            res.resok.dir_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(dirStat, res.resok.dir_attributes.attributes);
            res.resok.cookieverf = cookieverf;
            if (dirList.isEmpty()) {
                res.resok.reply.eof = true;
                return res;
            }
            int currcount = 104;
            entry3 currentEntry = res.resok.reply.entries = new entry3();
            entry3 lastEntry = null;
            for (long i = startValue; i < (long)dirList.size(); ++i) {
                DirectoryEntry le = dirList.get((int)i);
                String name2 = le.getName();
                currentEntry.fileid = new fileid3(new uint64(le.getStat().getFileId()));
                currentEntry.name = new filename3(name2);
                currentEntry.cookie = new cookie3(new uint64(i));
                currentEntry.nextentry = null;
                int newSize = 24 + name2.length();
                if (currcount + newSize > arg1.count.value.value) {
                    if (lastEntry == null) {
                        throw new TooSmallException("can't send even a single entry");
                    }
                    lastEntry.nextentry = null;
                    res.resok.reply.eof = false;
                    _log.debug("Sending {} entries ( {} bytes from {}) cookie = {} total {}", i - startValue, currcount, arg1.count.value.value, startValue, dirList.size());
                    return res;
                }
                currcount += newSize;
                if (i + 1L >= (long)dirList.size()) continue;
                lastEntry = currentEntry;
                currentEntry = currentEntry.nextentry = new entry3();
            }
            res.resok.reply.eof = true;
        }
        catch (ChimeraNFSException hne) {
            _log.error("READDIR: {}", (Object)hne.toString());
            res.resfail = new READDIR3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
            res.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("READDIR", e);
            res.status = 10006;
            res.resfail = new READDIR3resfail();
            res.resfail.dir_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    private List<DirectoryEntry> fetchDirectoryListing(InodeCacheEntry<cookieverf3> cacheKey, VirtualFileSystem fs, Inode dir) throws ChimeraNFSException {
        try {
            return this._dlCacheFull.get(cacheKey, () -> fs.list(dir));
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible(e.getCause(), ChimeraNFSException.class);
            throw new NfsIoException(e.getMessage());
        }
    }

    @Override
    public READLINK3res NFSPROC3_READLINK_3(RpcCall call$, READLINK3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        READLINK3res res = new READLINK3res();
        try {
            Inode inode = new Inode(arg1.symlink.data);
            res.resok = new READLINK3resok();
            res.resok.data = new nfspath3(fs.readlink(inode));
            res.resok.symlink_attributes = new post_op_attr();
            res.resok.symlink_attributes.attributes_follow = true;
            res.resok.symlink_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.symlink_attributes.attributes);
            res.status = 0;
        }
        catch (ChimeraNFSException e) {
            _log.error("READLINK", e);
            res.status = e.getStatus();
            res.resfail = new READLINK3resfail();
            res.resfail.symlink_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("READLINK", e);
            res.status = 10006;
            res.resfail = new READLINK3resfail();
            res.resfail.symlink_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public READ3res NFSPROC3_READ_3(RpcCall call$, READ3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        READ3res res = new READ3res();
        try {
            Inode inode = new Inode(arg1.file.data);
            long offset = arg1.offset.value.value;
            int count = arg1.count.value.value;
            Stat inodeStat = fs.getattr(inode);
            res.resok = new READ3resok();
            res.resok.data = new byte[count];
            res.resok.count = new count3();
            res.resok.count.value = new uint32();
            byte[] b = new byte[count];
            res.resok.count.value.value = fs.read(inode, b, offset, count);
            if (res.resok.count.value.value < 0) {
                throw new NfsIoException("IO not allowed");
            }
            if (res.resok.count.value.value == count) {
                res.resok.data = b;
            } else {
                res.resok.data = new byte[res.resok.count.value.value];
                System.arraycopy(b, 0, res.resok.data, 0, res.resok.count.value.value);
            }
            if ((long)res.resok.count.value.value + offset == inodeStat.getSize()) {
                res.resok.eof = true;
            }
            res.resok.file_attributes = new post_op_attr();
            res.resok.file_attributes.attributes_follow = true;
            res.resok.file_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(inodeStat, res.resok.file_attributes.attributes);
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new READ3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        catch (Exception e) {
            _log.error("READ", e);
            res.status = 10006;
            res.resfail = new READ3resfail();
            res.resfail.file_attributes = HimeraNfsUtils.defaultPostOpAttr();
        }
        return res;
    }

    @Override
    public REMOVE3res NFSPROC3_REMOVE_3(RpcCall call$, REMOVE3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request REMOVE3 uid: {}", (Object)call$.getCredential());
        REMOVE3res res = new REMOVE3res();
        try {
            Inode parent = new Inode(arg1.object.dir.data);
            String name2 = arg1.object.name.value;
            NameUtils.checkFilename(name2);
            Stat parentStat = fs.getattr(parent);
            fs.remove(parent, name2);
            res.resok = new REMOVE3resok();
            res.status = 0;
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = true;
            res.resok.dir_wcc.before.attributes = new wcc_attr();
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.before.attributes);
            parentStat.setMTime(System.currentTimeMillis());
            parentStat.setNlink(parentStat.getNlink() - 1);
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
        }
        catch (ChimeraNFSException hne) {
            res.resfail = new REMOVE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("REMOVE", e);
            res.status = 10006;
            res.resfail = new REMOVE3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public RENAME3res NFSPROC3_RENAME_3(RpcCall call$, RENAME3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request RENAME3 uid: {}", (Object)call$.getCredential());
        RENAME3res res = new RENAME3res();
        try {
            Inode from = new Inode(arg1.from.dir.data);
            String file1 = arg1.from.name.value;
            NameUtils.checkFilename(file1);
            Inode to = new Inode(arg1.to.dir.data);
            String file2 = arg1.to.name.value;
            NameUtils.checkFilename(file2);
            fs.move(from, file1, to, file2);
            res.resok = new RENAME3resok();
            res.resok.fromdir_wcc = new wcc_data();
            res.resok.fromdir_wcc.after = new post_op_attr();
            res.resok.fromdir_wcc.after.attributes_follow = true;
            res.resok.fromdir_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(from), res.resok.fromdir_wcc.after.attributes);
            res.resok.fromdir_wcc.before = new pre_op_attr();
            res.resok.fromdir_wcc.before.attributes_follow = false;
            res.resok.todir_wcc = new wcc_data();
            res.resok.todir_wcc.after = new post_op_attr();
            res.resok.todir_wcc.after.attributes_follow = true;
            res.resok.todir_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(to), res.resok.todir_wcc.after.attributes);
            res.resok.todir_wcc.before = new pre_op_attr();
            res.resok.todir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new RENAME3resfail();
            res.resfail.fromdir_wcc = HimeraNfsUtils.defaultWccData();
            res.resfail.todir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("RENAME", e);
            res.status = 10006;
            res.resfail = new RENAME3resfail();
            res.resfail.fromdir_wcc = HimeraNfsUtils.defaultWccData();
            res.resfail.todir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public RMDIR3res NFSPROC3_RMDIR_3(RpcCall call$, RMDIR3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request RMDIR3 uid: {}", (Object)call$.getCredential());
        RMDIR3res res = new RMDIR3res();
        try {
            Inode parent = new Inode(arg1.object.dir.data);
            String file = arg1.object.name.value;
            NameUtils.checkFilename(file);
            Inode inode = fs.lookup(parent, file);
            Stat parentStat = fs.getattr(parent);
            fs.remove(parent, file);
            res.resok = new RMDIR3resok();
            res.status = 0;
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = true;
            res.resok.dir_wcc.before.attributes = new wcc_attr();
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.before.attributes);
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setMTime(System.currentTimeMillis());
            parentStat.setNlink(parentStat.getNlink() - 1);
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
        }
        catch (ChimeraNFSException hne) {
            res.resfail = new RMDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
            res.status = hne.getStatus();
        }
        catch (Exception e) {
            _log.error("RMDIR", e);
            res.status = 10006;
            res.resfail = new RMDIR3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public SETATTR3res NFSPROC3_SETATTR_3(RpcCall call$, SETATTR3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request SETATTR3 uid: {}", (Object)call$.getCredential());
        SETATTR3res res = new SETATTR3res();
        try {
            Inode inode = new Inode(arg1.object.data);
            sattr3 newAttr = arg1.new_attributes;
            HimeraNfsUtils.set_sattr(inode, fs, newAttr);
            res.resok = new SETATTR3resok();
            res.resok.obj_wcc = new wcc_data();
            res.resok.obj_wcc.after = new post_op_attr();
            res.resok.obj_wcc.after.attributes_follow = true;
            res.resok.obj_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_wcc.after.attributes);
            res.resok.obj_wcc.before = new pre_op_attr();
            res.resok.obj_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new SETATTR3resfail();
            res.resfail.obj_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("SETATTR", e);
            res.status = 10006;
            res.resfail = new SETATTR3resfail();
            res.resfail.obj_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public SYMLINK3res NFSPROC3_SYMLINK_3(RpcCall call$, SYMLINK3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        _log.debug("NFS Request SYMLINK3 uid: {}", (Object)call$.getCredential());
        SYMLINK3res res = new SYMLINK3res();
        try {
            Inode parent = new Inode(arg1.where.dir.data);
            String file = arg1.where.name.value;
            NameUtils.checkFilename(file);
            String link = arg1.symlink.symlink_data.value;
            sattr3 linkAttr = arg1.symlink.symlink_attributes;
            Stat parentStat = fs.getattr(parent);
            Inode inode = fs.symlink(parent, file, link, call$.getCredential().getSubject(), 777);
            HimeraNfsUtils.set_sattr(inode, fs, linkAttr);
            res.resok = new SYMLINK3resok();
            res.resok.obj_attributes = new post_op_attr();
            res.resok.obj_attributes.attributes_follow = true;
            res.resok.obj_attributes.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.obj_attributes.attributes);
            res.resok.obj = new post_op_fh3();
            res.resok.obj.handle_follows = true;
            res.resok.obj.handle = new nfs_fh3();
            res.resok.obj.handle.data = inode.toNfsHandle();
            res.resok.dir_wcc = new wcc_data();
            res.resok.dir_wcc.after = new post_op_attr();
            res.resok.dir_wcc.after.attributes_follow = true;
            res.resok.dir_wcc.after.attributes = new fattr3();
            parentStat.setNlink(parentStat.getNlink() + 1);
            parentStat.setMTime(System.currentTimeMillis());
            HimeraNfsUtils.fill_attributes(parentStat, res.resok.dir_wcc.after.attributes);
            res.resok.dir_wcc.before = new pre_op_attr();
            res.resok.dir_wcc.before.attributes_follow = false;
            res.status = 0;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new SYMLINK3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("SYMLINK", e);
            res.status = 10006;
            res.resfail = new SYMLINK3resfail();
            res.resfail.dir_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }

    @Override
    public WRITE3res NFSPROC3_WRITE_3(RpcCall call$, WRITE3args arg1) {
        PseudoFs fs = new PseudoFs(this._vfs, call$, this._exports);
        WRITE3res res = new WRITE3res();
        try {
            Inode inode = new Inode(arg1.file.data);
            long offset = arg1.offset.value.value;
            int count = arg1.count.value.value;
            res.resok = new WRITE3resok();
            res.status = 0;
            VirtualFileSystem.StabilityLevel requiredStabilityLevel = VirtualFileSystem.StabilityLevel.fromStableHow(arg1.stable);
            VirtualFileSystem.WriteResult ret = fs.write(inode, arg1.data, offset, count, requiredStabilityLevel);
            if (ret.getBytesWritten() < 0) {
                throw new NfsIoException("IO not allowed");
            }
            res.resok.count = new count3(new uint32(ret.getBytesWritten()));
            res.resok.file_wcc = new wcc_data();
            res.resok.file_wcc.after = new post_op_attr();
            res.resok.file_wcc.after.attributes_follow = true;
            res.resok.file_wcc.after.attributes = new fattr3();
            HimeraNfsUtils.fill_attributes(fs.getattr(inode), res.resok.file_wcc.after.attributes);
            res.resok.file_wcc.before = new pre_op_attr();
            res.resok.file_wcc.before.attributes_follow = false;
            res.resok.committed = ret.getStabilityLevel().toStableHow();
            res.resok.verf = this.writeVerifier;
        }
        catch (ChimeraNFSException hne) {
            res.status = hne.getStatus();
            res.resfail = new WRITE3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        catch (Exception e) {
            _log.error("WRITE", e);
            res.status = 10006;
            res.resfail = new WRITE3resfail();
            res.resfail.file_wcc = HimeraNfsUtils.defaultWccData();
        }
        return res;
    }
}

