/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v3;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.dcache.nfs.v3.xdr.mountbody;
import org.dcache.nfs.v3.xdr.mountlist;
import org.dcache.utils.net.InetSocketAddresses;
import org.dcache.xdr.OncRpcClient;
import org.dcache.xdr.RpcAuthTypeNone;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.XdrTransport;
import org.dcache.xdr.XdrVoid;
import org.dcache.xdr.portmap.GenericPortmapClient;

public class ShowMount {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("usage: ShowMount host");
        }
        String host = "localhost";
        OncRpcClient rpcClient = new OncRpcClient(InetAddress.getByName(host), 6, 111);
        XdrTransport transport = rpcClient.connect();
        GenericPortmapClient portmapClient = new GenericPortmapClient(transport);
        String mouontdAddress = portmapClient.getPort(100005, 3, "tcp");
        rpcClient.close();
        InetSocketAddress address = InetSocketAddresses.forUaddrString(mouontdAddress);
        address = new InetSocketAddress(host, address.getPort());
        rpcClient = new OncRpcClient(address, 6);
        transport = rpcClient.connect();
        RpcAuthTypeNone auth = new RpcAuthTypeNone();
        RpcCall call = new RpcCall(100005, 3, auth, transport);
        mountlist exports2 = new mountlist();
        call.call(2, XdrVoid.XDR_VOID, exports2);
        mountbody exportEntry = exports2.value;
        while (exportEntry != null) {
            System.out.println(exportEntry.ml_hostname.value + " : " + exportEntry.ml_directory.value);
            exportEntry = exportEntry.ml_next.value;
        }
        rpcClient.close();
    }
}

