/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.ConnNotBoundToSessionException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.SessionConnection;
import org.dcache.nfs.v4.xdr.DESTROY_SESSION4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationDESTROY_SESSION
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationDESTROY_SESSION.class);

    public OperationDESTROY_SESSION(nfs_argop4 args) {
        super(args, 44);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        SessionConnection sessionConnection;
        DESTROY_SESSION4res res = result.opdestroy_session;
        NFSv41Session session = context.getStateHandler().getSession(this._args.opdestroy_session.dsa_sessionid);
        if (!session.isReleasableBy(sessionConnection = new SessionConnection(context.getLocalSocketAddress(), context.getRemoteSocketAddress()))) {
            throw new ConnNotBoundToSessionException("Session not " + session + " not bound to" + sessionConnection.getRemoteConnection());
        }
        context.getStateHandler().removeSession(this._args.opdestroy_session.dsa_sessionid);
        res.dsr_status = 0;
    }
}

