/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.IsDirException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.xdr.LINK4resok;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLINK
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLINK.class);

    public OperationLINK(nfs_argop4 args) {
        super(args, 11);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        String newName = NameFilter.convertName(this._args.oplink.newname.value);
        Stat parentDirStat = context.getFs().getattr(context.currentInode());
        Stat inodeStat = context.getFs().getattr(context.savedInode());
        if (parentDirStat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException("Can't create a hard-link in non directory object");
        }
        if (inodeStat.type() == Stat.Type.DIRECTORY) {
            throw new IsDirException("Can't hard-link a directory");
        }
        context.getFs().link(context.currentInode(), context.savedInode(), newName, context.getSubject());
        result.oplink.resok4 = new LINK4resok();
        result.oplink.resok4.cinfo = new change_info4();
        result.oplink.resok4.cinfo.atomic = true;
        result.oplink.resok4.cinfo.before = new changeid4(parentDirStat.getCTime());
        result.oplink.resok4.cinfo.after = new changeid4(System.currentTimeMillis());
        result.oplink.status = 0;
    }
}

