/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.StaleClientidException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.xdr.RENEW4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationRENEW
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationRENEW.class);

    public OperationRENEW(nfs_argop4 args) {
        super(args, 30);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        RENEW4res res = result.oprenew;
        Long clientid = this._args.oprenew.clientid.value;
        NFS4Client client = context.getStateHandler().getClientByID(clientid);
        if (client == null) {
            throw new StaleClientidException();
        }
        client.updateLeaseTime();
        res.status = 0;
    }
}

