/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NotDirException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.OperationSECINFO_NO_NAME;
import org.dcache.nfs.v4.xdr.SECINFO4res;
import org.dcache.nfs.v4.xdr.SECINFO4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSECINFO
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSECINFO.class);

    public OperationSECINFO(nfs_argop4 args) {
        super(args, 33);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException {
        SECINFO4res res = result.opsecinfo;
        Inode dir = context.currentInode();
        Stat stat = context.getFs().getattr(dir);
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new NotDirException();
        }
        context.clearCurrentInode();
        String name2 = NameFilter.convertName(this._args.opsecinfo.name.value);
        Inode inode = context.getFs().lookup(dir, name2);
        try {
            res.resok4 = new SECINFO4resok();
            res.resok4.value = OperationSECINFO_NO_NAME.secinfosOf(inode, context);
            res.status = 0;
        }
        catch (GSSException e) {
            throw new NfsIoException(e.getMessage());
        }
    }
}

