/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadSessionException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.SessionConnection;
import org.dcache.nfs.v4.xdr.SEQUENCE4res;
import org.dcache.nfs.v4.xdr.SEQUENCE4resok;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.sessionid4;
import org.dcache.nfs.v4.xdr.slotid4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSEQUENCE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationSEQUENCE.class);

    public OperationSEQUENCE(nfs_argop4 args) {
        super(args, 53);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException {
        SEQUENCE4res res = result.opsequence;
        NFSv41Session session = context.getStateHandler().getSession(this._args.opsequence.sa_sessionid);
        NFS4Client client = session.getClient();
        if (!client.hasSessions()) {
            _log.debug("no client for session for id [{}]", (Object)this._args.opsequence.sa_sessionid);
            throw new BadSessionException("client not found");
        }
        int opCount = context.getTotalOperationCount();
        context.setCache(session.checkCacheSlot(this._args.opsequence.sa_slotid.value, this._args.opsequence.sa_sequenceid.value, opCount > 1));
        session.bindIfNeeded(new SessionConnection(context.getLocalSocketAddress(), context.getRemoteSocketAddress()));
        client.updateLeaseTime();
        context.setSession(session);
        context.setCacheThis(this._args.opsequence.sa_cachethis);
        context.setSlotId(this._args.opsequence.sa_slotid.value);
        res.sr_resok4 = new SEQUENCE4resok();
        res.sr_resok4.sr_highest_slotid = new slotid4(session.getHighestSlot());
        res.sr_resok4.sr_slotid = new slotid4(this._args.opsequence.sa_slotid.value);
        res.sr_resok4.sr_target_highest_slotid = new slotid4(session.getHighestSlot());
        res.sr_resok4.sr_sessionid = new sessionid4(this._args.opsequence.sa_sessionid.value);
        res.sr_resok4.sr_sequenceid = this._args.opsequence.sa_sequenceid;
        res.sr_resok4.sr_status_flags = new uint32_t(0);
        res.sr_status = 0;
    }
}

