/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.status.BadStateidException;
import org.dcache.nfs.status.OldStateidException;
import org.dcache.nfs.v4.xdr.stateid4;

public class Stateids {
    private static final stateid4 CURRENT_STATEID = new stateid4(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1);
    private static final stateid4 INVAL_STATEID = new stateid4(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, -1);
    private static final stateid4 ZERO_STATEID = new stateid4(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 0);
    private static final stateid4 ONE_STATEID = new stateid4(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, -1);

    private Stateids() {
    }

    public static stateid4 uptodateOf(stateid4 stateid) {
        return new stateid4(stateid.other, 0);
    }

    public static stateid4 currentStateId() {
        return CURRENT_STATEID;
    }

    public static stateid4 invalidStateId() {
        return INVAL_STATEID;
    }

    public static stateid4 ZeroStateId() {
        return ZERO_STATEID;
    }

    public static stateid4 OneStateId() {
        return ONE_STATEID;
    }

    public static boolean isStateLess(stateid4 stateid) {
        return stateid.equalsWithSeq(ZERO_STATEID) || stateid.equalsWithSeq(ONE_STATEID);
    }

    public static void checkStateId(stateid4 expected, stateid4 stateid) throws ChimeraNFSException {
        if (expected.seqid.value > stateid.seqid.value) {
            throw new OldStateidException();
        }
        if (expected.seqid.value < stateid.seqid.value) {
            throw new BadStateidException();
        }
    }
}

