/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.acl;

import java.util.Arrays;
import org.dcache.nfs.v4.xdr.aceflag4;
import org.dcache.nfs.v4.xdr.acemask4;
import org.dcache.nfs.v4.xdr.acetype4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.utf8str_mixed;

public class Acls {
    private static final int BIT_MASK_OWNER_OFFSET = 6;
    private static final int BIT_MASK_GROUP_OFFSET = 3;
    private static final int BIT_MASK_OTHER_OFFSET = 0;
    public static final int RBIT = 4;
    public static final int WBIT = 2;
    public static final int XBIT = 1;
    public static final utf8str_mixed OWNER = new utf8str_mixed("OWNER@");
    public static final utf8str_mixed GROUP = new utf8str_mixed("GROUP@");
    public static final utf8str_mixed EVERYONE = new utf8str_mixed("EVERYONE@");
    private static final aceflag4 NO_FLAGS = new aceflag4(new uint32_t(0));
    private static final acetype4 ALLOW = new acetype4(new uint32_t(0));
    private static final acetype4 DENY = new acetype4(new uint32_t(1));
    private static final int WANT_MODITY = 328006;

    private Acls() {
    }

    public static nfsace4[] addACE(nfsace4 ace, nfsace4[] acl) {
        nfsace4[] newAcl = new nfsace4[acl.length + 1];
        newAcl[0] = ace;
        System.arraycopy(acl, 0, newAcl, 1, acl.length);
        return newAcl;
    }

    public static nfsace4[] addACE(nfsace4[] acl, nfsace4 ace) {
        nfsace4[] newAcl = new nfsace4[acl.length + 1];
        System.arraycopy(acl, 0, newAcl, 0, acl.length);
        newAcl[acl.length] = ace;
        return newAcl;
    }

    public static nfsace4[] of(int mode, boolean isDir) {
        acemask4 ownerMask = Acls.toAceMask(mode >> 6, isDir, true);
        acemask4 groupMask = Acls.toAceMask(mode >> 3, isDir, false);
        acemask4 everyoneMask = Acls.toAceMask(mode, isDir, false);
        nfsace4 ownerAceAllow = new nfsace4();
        ownerAceAllow.access_mask = ownerMask;
        ownerAceAllow.who = OWNER;
        ownerAceAllow.type = ALLOW;
        ownerAceAllow.flag = NO_FLAGS;
        nfsace4 ownerAceDeny = new nfsace4();
        ownerAceDeny.access_mask = acemask4.clear(ownerMask, acemask4.allOf(groupMask, everyoneMask));
        ownerAceDeny.who = OWNER;
        ownerAceDeny.type = DENY;
        ownerAceDeny.flag = NO_FLAGS;
        nfsace4 groupAceAllow = new nfsace4();
        groupAceAllow.access_mask = groupMask;
        groupAceAllow.who = GROUP;
        groupAceAllow.type = ALLOW;
        groupAceAllow.flag = NO_FLAGS;
        nfsace4 groupAceDeny = new nfsace4();
        groupAceDeny.access_mask = acemask4.clear(groupMask, everyoneMask);
        groupAceDeny.who = GROUP;
        groupAceDeny.type = DENY;
        groupAceDeny.flag = NO_FLAGS;
        nfsace4 otherAceAllow = new nfsace4();
        otherAceAllow.access_mask = everyoneMask;
        otherAceAllow.who = EVERYONE;
        otherAceAllow.type = ALLOW;
        otherAceAllow.flag = NO_FLAGS;
        return Acls.compact(new nfsace4[]{ownerAceAllow, ownerAceDeny, groupAceAllow, groupAceDeny, otherAceAllow});
    }

    public static int toAccessMask(int mode, boolean isDir, boolean isOwner) {
        int mask = 128;
        if (isOwner) {
            mask |= 0x60180;
        }
        if ((mode & 4) != 0) {
            mask |= 0x20081;
        }
        if ((mode & 2) != 0) {
            mask |= 6;
            if (isDir) {
                mask |= 0x40;
            }
        }
        if ((mode & 1) != 0) {
            mask |= 0x20;
        }
        return mask;
    }

    private static acemask4 toAceMask(int mode, boolean isDir, boolean isOwner) {
        acemask4 acemask = new acemask4();
        acemask.value = new uint32_t(Acls.toAccessMask(mode, isDir, isOwner));
        return acemask;
    }

    public static int toMode(nfsace4[] acl) {
        return Acls.calculateBits(OWNER, acl) << 6 | Acls.calculateBits(GROUP, acl) << 3 | Acls.calculateBits(EVERYONE, acl) << 0;
    }

    public static nfsace4[] adjust(nfsace4[] acl, int mode) {
        nfsace4[] newAcl = new nfsace4[acl.length];
        int i = 0;
        for (nfsace4 ace : acl) {
            if (Acls.isSpecialPrincipal(ace.who)) continue;
            newAcl[i] = ace;
            ++i;
        }
        return Arrays.copyOf(newAcl, i);
    }

    private static int getBitR(int acemask) {
        if ((acemask & 1) != 0) {
            return 4;
        }
        return 0;
    }

    private static int getBitW(int acemask) {
        if ((acemask & 6) != 0) {
            return 2;
        }
        return 0;
    }

    private static int getBitX(int acemask) {
        if ((acemask & 0x20) != 0) {
            return 1;
        }
        return 0;
    }

    private static int calculateBits(utf8str_mixed principal, nfsace4[] acl) {
        int mode = 0;
        for (int i = acl.length - 1; i >= 0; --i) {
            nfsace4 ace = acl[i];
            if (ace.type.value.value != 1 && ace.type.value.value != 0 || !ace.who.equals(EVERYONE) && !ace.who.equals(principal)) continue;
            int acemask = ace.access_mask.value.value;
            int rwx = Acls.getBitR(acemask) | Acls.getBitW(acemask) | Acls.getBitX(acemask);
            if (ace.type.value.value == 0) {
                mode |= rwx;
                continue;
            }
            mode ^= rwx;
        }
        return mode;
    }

    public static nfsace4[] compact(nfsace4[] acl) {
        int size = acl.length;
        if (size == 0) {
            return acl;
        }
        for (int i = 0; i < size; ++i) {
            nfsace4 a = acl[i];
            utf8str_mixed pricipal = a.who;
            int processedMask = a.access_mask.value.value;
            for (int j = i + 1; j < size; ++j) {
                nfsace4 b = acl[j];
                if (a.flag.value.value != b.flag.value.value || !pricipal.equals(b.who)) continue;
                b.access_mask.value.value &= ~processedMask;
                int maskToProcess = b.access_mask.value.value;
                if (maskToProcess != 0 && a.type.value.value == b.type.value.value) {
                    a.access_mask.value.value |= maskToProcess;
                    b.access_mask.value.value &= ~maskToProcess;
                }
                processedMask |= maskToProcess;
            }
        }
        for (nfsace4 ace : acl) {
            if (ace.access_mask.value.value != 0) continue;
            --size;
        }
        nfsace4[] compact = new nfsace4[size];
        int i = 0;
        for (nfsace4 ace : acl) {
            if (ace.access_mask.value.value == 0) continue;
            compact[i] = ace;
            ++i;
        }
        return compact;
    }

    private static boolean isSpecialPrincipal(utf8str_mixed who) {
        String w = who.toString();
        return w.charAt(w.length() - 1) == '@';
    }

    public static boolean wantModify(int accessMask) {
        return (accessMask & 0x50146) != 0;
    }
}

