/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils;

public final class Bytes {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Bytes() {
    }

    public static void putLong(byte[] bytes, int offset, long value) throws IllegalArgumentException {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("not enough space to store long");
        }
        bytes[offset] = (byte)(value >> 56);
        bytes[offset + 1] = (byte)(value >> 48);
        bytes[offset + 2] = (byte)(value >> 40);
        bytes[offset + 3] = (byte)(value >> 32);
        bytes[offset + 4] = (byte)(value >> 24);
        bytes[offset + 5] = (byte)(value >> 16);
        bytes[offset + 6] = (byte)(value >> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static void putInt(byte[] bytes, int offset, int value) throws IllegalArgumentException {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("not enough space to store int");
        }
        bytes[offset] = (byte)(value >> 24);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static long getLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static int getInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int p = 0;
        for (byte b : bytes) {
            int i = b & 0xFF;
            chars[p++] = HEX[i / 16];
            chars[p++] = HEX[i % 16];
        }
        return new String(chars);
    }

    public static byte[] fromHexString(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("The string needs to be even-length: " + s);
        }
        int len = s.length() / 2;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int charIndex = i * 2;
            int d0 = Bytes.toDigit(s.charAt(charIndex));
            int d1 = Bytes.toDigit(s.charAt(charIndex + 1));
            bytes[i] = (byte)((d0 << 4) + d1);
        }
        return bytes;
    }

    private static int toDigit(char ch) throws NumberFormatException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new NumberFormatException("illegal character '" + ch + "'");
    }
}

