/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils;

import java.lang.reflect.Method;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.UidPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixUtils {
    private static final Logger _log = LoggerFactory.getLogger(UnixUtils.class);

    public static Subject getCurrentUser() {
        try {
            long[] groups2;
            Class<?> unixSystemClass = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object unixSystemInstance = unixSystemClass.newInstance();
            Method getUidMethod = unixSystemClass.getDeclaredMethod("getUid", new Class[0]);
            Method getGidMethod = unixSystemClass.getDeclaredMethod("getGid", new Class[0]);
            Method getGroupsMethod = unixSystemClass.getDeclaredMethod("getGroups", new Class[0]);
            Subject subject = new Subject();
            subject.getPrincipals().add(new UidPrincipal((Long)getUidMethod.invoke(unixSystemInstance, new Object[0])));
            subject.getPrincipals().add(new GidPrincipal((Long)getGidMethod.invoke(unixSystemInstance, new Object[0]), true));
            for (long gid : groups2 = (long[])getGroupsMethod.invoke(unixSystemInstance, new Object[0])) {
                subject.getPrincipals().add(new GidPrincipal(gid, false));
            }
            return subject;
        }
        catch (Exception e) {
            _log.debug("couldn't get current unix user", e);
            return null;
        }
    }

    public static int[] toIntArray(long[] longArray) {
        int[] intArray = new int[longArray.length];
        for (int i = 0; i < longArray.length; ++i) {
            intArray[i] = (int)longArray[i];
        }
        return intArray;
    }
}

