/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcAuthError;
import org.dcache.xdr.RpcAuthException;
import org.dcache.xdr.RpcAuthTypeNone;
import org.dcache.xdr.RpcAuthTypeUnix;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.gss.RpcAuthGss;

public class RpcCredential {
    private RpcCredential() {
    }

    public static RpcAuth decode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        RpcAuth credential;
        int authType = xdr.xdrDecodeInt();
        switch (authType) {
            case 1: {
                credential = new RpcAuthTypeUnix();
                break;
            }
            case 0: {
                credential = new RpcAuthTypeNone();
                break;
            }
            case 6: {
                credential = new RpcAuthGss();
                break;
            }
            default: {
                throw new RpcAuthException("Unsuported type: " + authType, new RpcAuthError(7));
            }
        }
        credential.xdrDecode(xdr);
        return credential;
    }
}

