/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;
import org.glassfish.grizzly.utils.NullaryFunction;

public final class Attribute<T> {
    private final AttributeBuilder builder;
    private final String name;
    private final NullaryFunction<T> initializer;
    private final int attributeIndex;

    public String toString() {
        return "Attribute[" + this.name + ':' + this.attributeIndex + ']';
    }

    protected Attribute(AttributeBuilder builder, String name2, int index, final T defaultValue) {
        this(builder, name2, index, new NullaryFunction<T>(){

            @Override
            public T evaluate() {
                return defaultValue;
            }
        });
    }

    protected Attribute(AttributeBuilder builder, String name2, int index, NullaryFunction<T> initializer) {
        this.builder = builder;
        this.name = name2;
        this.attributeIndex = index;
        this.initializer = initializer;
    }

    public T peek(AttributeHolder attributeHolder) {
        return this.get0(attributeHolder, null);
    }

    public T peek(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.peek(holder);
        }
        return null;
    }

    public T get(AttributeHolder attributeHolder) {
        return this.get0(attributeHolder, this.initializer);
    }

    public T get(AttributeStorage storage) {
        return this.get(storage.getAttributes());
    }

    public void set(AttributeHolder attributeHolder, T value) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        if (indexedAccessor != null) {
            indexedAccessor.setAttribute(this.attributeIndex, value);
        } else {
            attributeHolder.setAttribute(this.name, value);
        }
    }

    public void set(AttributeStorage storage, T value) {
        this.set(storage.getAttributes(), value);
    }

    public T remove(AttributeHolder attributeHolder) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        return (T)(indexedAccessor != null ? indexedAccessor.removeAttribute(this.attributeIndex) : attributeHolder.removeAttribute(this.name));
    }

    public T remove(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.remove(holder);
        }
        return null;
    }

    public boolean isSet(AttributeHolder attributeHolder) {
        return this.get0(attributeHolder, null) != null;
    }

    public boolean isSet(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.isSet(holder);
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.attributeIndex;
    }

    private T get0(AttributeHolder attributeHolder, NullaryFunction<T> initializer) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        return (T)(indexedAccessor != null ? indexedAccessor.getAttribute(this.attributeIndex, initializer) : attributeHolder.getAttribute(this.name, initializer));
    }
}

