/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.expression;

import java.util.Map;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class MapAccessor
implements PropertyAccessor {
    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name2) throws AccessException {
        Map map = (Map)target;
        return map.containsKey(name2);
    }

    @Override
    public TypedValue read(EvaluationContext context, Object target, String name2) throws AccessException {
        Map map = (Map)target;
        Object value = map.get(name2);
        if (value == null && !map.containsKey(name2)) {
            throw new MapAccessException(name2);
        }
        return new TypedValue(value);
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name2) throws AccessException {
        return true;
    }

    @Override
    public void write(EvaluationContext context, Object target, String name2, Object newValue) throws AccessException {
        Map map = (Map)target;
        map.put(name2, newValue);
    }

    private static class MapAccessException
    extends AccessException {
        private final String key;

        public MapAccessException(String key) {
            super((String)null);
            this.key = key;
        }

        @Override
        public String getMessage() {
            return "Map does not contain a value for key '" + this.key + "'";
        }
    }
}

