/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>(0);

    @Override
    public void setAttribute(String name2, Object value) {
        Assert.notNull(name2, "Name must not be null");
        if (value != null) {
            this.attributes.put(name2, value);
        } else {
            this.removeAttribute(name2);
        }
    }

    @Override
    public Object getAttribute(String name2) {
        Assert.notNull(name2, "Name must not be null");
        return this.attributes.get(name2);
    }

    @Override
    public Object removeAttribute(String name2) {
        Assert.notNull(name2, "Name must not be null");
        return this.attributes.remove(name2);
    }

    @Override
    public boolean hasAttribute(String name2) {
        Assert.notNull(name2, "Name must not be null");
        return this.attributes.containsKey(name2);
    }

    @Override
    public String[] attributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    protected void copyAttributesFrom(AttributeAccessor source) {
        String[] attributeNames;
        Assert.notNull(source, "Source must not be null");
        for (String attributeName : attributeNames = source.attributeNames()) {
            this.setAttribute(attributeName, source.getAttribute(attributeName));
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeAccessorSupport)) {
            return false;
        }
        AttributeAccessorSupport that = (AttributeAccessorSupport)other;
        return this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }
}

