/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.util.Assert;

public class JOptCommandLinePropertySource
extends CommandLinePropertySource<OptionSet> {
    public JOptCommandLinePropertySource(OptionSet options) {
        super(options);
    }

    public JOptCommandLinePropertySource(String name2, OptionSet options) {
        super(name2, options);
    }

    @Override
    protected boolean containsOption(String name2) {
        return ((OptionSet)this.source).has(name2);
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList names = new ArrayList();
        for (OptionSpec spec : ((OptionSet)this.source).specs()) {
            ArrayList aliases = new ArrayList(spec.options());
            if (aliases.isEmpty()) continue;
            names.add(aliases.get(aliases.size() - 1));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public List<String> getOptionValues(String name2) {
        List argValues = ((OptionSet)this.source).valuesOf(name2);
        ArrayList<String> stringArgValues = new ArrayList<String>();
        for (Object argValue : argValues) {
            Assert.isInstanceOf(String.class, argValue, "Argument values must be of type String");
            stringArgValues.add((String)argValue);
        }
        if (stringArgValues.isEmpty()) {
            return ((OptionSet)this.source).has(name2) ? Collections.emptyList() : null;
        }
        return Collections.unmodifiableList(stringArgValues);
    }

    @Override
    protected List<String> getNonOptionArgs() {
        List argValues = ((OptionSet)this.source).nonOptionArguments();
        ArrayList<String> stringArgValues = new ArrayList<String>();
        for (Object argValue : argValues) {
            Assert.isInstanceOf(String.class, argValue, "Argument values must be of type String");
            stringArgValues.add((String)argValue);
        }
        return stringArgValues.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(stringArgValues);
    }
}

