/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
implements DatabaseObject,
Comparable<Index> {
    public static final String MARK_PRIMARY_KEY = "primaryKey";
    public static final String MARK_FOREIGN_KEY = "foreignKey";
    public static final String MARK_UNIQUE_CONSTRAINT = "uniqueConstraint";
    private String name;
    private Table table;
    private String tablespace;
    private Boolean unique;
    private List<String> columns = new ArrayList<String>();
    private String filterCondition;
    private Set<String> associatedWith = new HashSet<String>();

    @Override
    public DatabaseObject[] getContainingObjects() {
        return new DatabaseObject[]{this.table};
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumnNames() {
        return StringUtils.join(this.columns, ", ");
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public void setUnique(Boolean value) {
        this.unique = value;
    }

    public Boolean isUnique() {
        return this.unique;
    }

    public Set<String> getAssociatedWith() {
        return this.associatedWith;
    }

    public String getAssociatedWithAsString() {
        return StringUtils.join(this.associatedWith, ",");
    }

    public void addAssociatedWith(String item) {
        this.associatedWith.add(item);
    }

    public boolean isAssociatedWith(String keyword) {
        return this.associatedWith.contains(keyword);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        boolean equals = this.getColumnNames().equals(index.getColumnNames());
        if (this.unique != null || index.isUnique() != null) {
            if (this.unique == null && index.isUnique() != null) {
                equals = false;
            } else if (this.unique != null && index.isUnique() == null) {
                equals = false;
            } else if (!this.unique.equals(index.isUnique())) {
                equals = false;
            }
        }
        return equals && this.table.getName().equalsIgnoreCase(index.table.getName()) && this.getName().equals(index.getName());
    }

    public int hashCode() {
        int result = this.table.getName().toUpperCase().hashCode();
        result = 31 * result + ((Object)this.columns).hashCode();
        result = 31 * result + (this.unique == null ? 2 : (this.unique != false ? 1 : 0));
        return result;
    }

    @Override
    public int compareTo(Index o) {
        int returnValue = this.table.getName().compareTo(o.table.getName());
        if (returnValue == 0) {
            String thisName = StringUtils.trimToEmpty(this.getName());
            String oName = StringUtils.trimToEmpty(o.getName());
            returnValue = thisName.compareTo(oName);
        }
        return returnValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName());
        if (this.unique != null && !this.unique.booleanValue()) {
            stringBuffer.append(" unique ");
        }
        if (this.table != null && this.columns != null) {
            stringBuffer.append(" on ").append(this.table.getName());
            if (this.columns != null) {
                stringBuffer.append("(");
                for (String column : this.columns) {
                    stringBuffer.append(column).append(", ");
                }
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }
}

