/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.servlet;

import java.sql.Connection;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.logging.LogFactory;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.NetUtil;
import liquibase.util.StringUtils;

public class LiquibaseServletListener
implements ServletContextListener {
    private String changeLogFile;
    private String dataSource;
    private String contexts;
    private String defaultSchema;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setContexts(String ctxt) {
        this.contexts = ctxt;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        block21: {
            String hostName;
            try {
                hostName = NetUtil.getLocalHost().getHostName();
            }
            catch (Exception e) {
                servletContextEvent.getServletContext().log("Cannot find hostname: " + e.getMessage());
                return;
            }
            String shouldRunProperty = System.getProperty("liquibase.should.run");
            if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
                LogFactory.getLogger().info("Liquibase did not run on " + hostName + " because '" + "liquibase.should.run" + "' system property was set to false");
                return;
            }
            String machineIncludes = servletContextEvent.getServletContext().getInitParameter("liquibase.host.includes");
            String machineExcludes = servletContextEvent.getServletContext().getInitParameter("liquibase.host.excludes");
            String failOnError = servletContextEvent.getServletContext().getInitParameter("liquibase.onerror.fail");
            boolean shouldRun = false;
            if (machineIncludes == null && machineExcludes == null) {
                shouldRun = true;
            } else if (machineIncludes != null) {
                for (String machine : machineIncludes.split(",")) {
                    if (!hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                    shouldRun = true;
                }
            } else if (machineExcludes != null) {
                shouldRun = true;
                for (String machine : machineExcludes.split(",")) {
                    if (!hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                    shouldRun = false;
                }
            }
            if (!shouldRun) {
                servletContextEvent.getServletContext().log("LiquibaseServletListener did not run due to liquibase.host.includes and/or liquibase.host.excludes");
                return;
            }
            this.setDataSource(servletContextEvent.getServletContext().getInitParameter("liquibase.datasource"));
            this.setChangeLogFile(servletContextEvent.getServletContext().getInitParameter("liquibase.changelog"));
            this.setContexts(servletContextEvent.getServletContext().getInitParameter("liquibase.contexts"));
            this.defaultSchema = StringUtils.trimToNull(servletContextEvent.getServletContext().getInitParameter("liquibase.schema.default"));
            if (this.getChangeLogFile() == null) {
                throw new RuntimeException("Cannot run Liquibase, liquibase.changelog is not set");
            }
            if (this.getDataSource() == null) {
                throw new RuntimeException("Cannot run Liquibase, liquibase.datasource is not set");
            }
            try {
                InitialContext ic = null;
                Connection connection = null;
                try {
                    ic = new InitialContext();
                    DataSource dataSource = (DataSource)ic.lookup(this.dataSource);
                    connection = dataSource.getConnection();
                    Thread currentThread = Thread.currentThread();
                    ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                    ClassLoaderResourceAccessor threadClFO = new ClassLoaderResourceAccessor(contextClassLoader);
                    ClassLoaderResourceAccessor clFO = new ClassLoaderResourceAccessor();
                    FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor();
                    Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
                    database.setDefaultSchemaName(this.defaultSchema);
                    Liquibase liquibase = new Liquibase(this.getChangeLogFile(), (ResourceAccessor)new CompositeResourceAccessor(clFO, fsFO, threadClFO), database);
                    Enumeration initParameters = servletContextEvent.getServletContext().getInitParameterNames();
                    while (initParameters.hasMoreElements()) {
                        String name2 = ((String)initParameters.nextElement()).trim();
                        if (!name2.startsWith("liquibase.parameter.")) continue;
                        liquibase.setChangeLogParameter(name2.substring("liquibase.parameter".length()), servletContextEvent.getServletContext().getInitParameter(name2));
                    }
                    liquibase.update(this.getContexts());
                }
                finally {
                    if (ic != null) {
                        ic.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (Exception e) {
                if ("false".equals(failOnError)) break block21;
                throw new RuntimeException(e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

