/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.dcache.acl.ACE;
import org.dcache.chimera.BackEndErrorHimeraFsException;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.FsInode_CONST;
import org.dcache.chimera.FsInode_ID;
import org.dcache.chimera.FsInode_NAMEOF;
import org.dcache.chimera.FsInode_PARENT;
import org.dcache.chimera.FsInode_PATHOF;
import org.dcache.chimera.FsInode_PGET;
import org.dcache.chimera.FsInode_PSET;
import org.dcache.chimera.FsInode_TAG;
import org.dcache.chimera.FsInode_TAGS;
import org.dcache.chimera.FsSqlDriver;
import org.dcache.chimera.FsStat;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.InvalidNameChimeraException;
import org.dcache.chimera.NotDirChimeraException;
import org.dcache.chimera.PnfsCommandProcessor;
import org.dcache.chimera.StorageLocatable;
import org.dcache.chimera.posix.Stat;
import org.dcache.chimera.store.AccessLatency;
import org.dcache.chimera.store.InodeStorageInformation;
import org.dcache.chimera.store.RetentionPolicy;
import org.dcache.chimera.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcFs
implements FileSystemProvider {
    private static final Logger _log = LoggerFactory.getLogger(JdbcFs.class);
    private static final int MAX_NAME_LEN = 255;
    private static final int LEVELS_NUMBER = 7;
    private static final String ROOT_DIR = "/";
    private static final String PATH_SEPARATOR = "/";
    private static final int UID_ROOT = 0;
    private static final int GID_ROOT = 0;
    private static final int DEFAULT_DIR_PERMISSION = 493;
    private final FsInode _rootInode;
    private final String _wormID;
    private final FsSqlDriver _sqlDriver;
    private static final Map<Integer, FileSystemProvider> _allFileSystems = new HashMap<Integer, FileSystemProvider>();
    private final DataSource _dbConnectionsPool;
    private final FsStatCache _fsStatCache;
    private final int _fsId;

    public JdbcFs(DataSource dataSource, String dialect) {
        this(dataSource, dialect, 0);
    }

    public JdbcFs(DataSource dataSource, String dialect, int id) {
        this._dbConnectionsPool = dataSource;
        this._fsId = id;
        this._sqlDriver = FsSqlDriver.getDriverInstance(dialect);
        this._rootInode = new FsInode(this, "000000000000000000000000000000000000");
        String wormID = null;
        try {
            wormID = this.getWormID().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        this._wormID = wormID;
        this._fsStatCache = new FsStatCache(this);
    }

    private FsInode getWormID() throws ChimeraFsException {
        return this.path2inode("/admin/etc/config");
    }

    public long usedSpace() throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        long usedSpace = 0L;
        try {
            dbConnection.setAutoCommit(true);
            usedSpace = this._sqlDriver.usedSpace(dbConnection);
        }
        catch (SQLException se) {
            _log.error("usedSpace: ", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return usedSpace;
    }

    public long usedFiles() throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        long usedFiles = 0L;
        try {
            dbConnection.setAutoCommit(true);
            usedFiles = this._sqlDriver.usedFiles(dbConnection);
        }
        catch (SQLException se) {
            _log.error("usedFiles: ", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return usedFiles;
    }

    @Override
    public FsInode createLink(String src, String dest) throws ChimeraFsException {
        File file = new File(src);
        return this.createLink(this.path2inode(file.getParent()), file.getName(), dest);
    }

    @Override
    public FsInode createLink(FsInode parent, String name2, String dest) throws ChimeraFsException {
        return this.createLink(parent, name2, 0, 0, 420, dest.getBytes());
    }

    @Override
    public FsInode createLink(FsInode parent, String name2, int uid, int gid, int mode, byte[] dest) throws ChimeraFsException {
        FsInode inode;
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            inode = this._sqlDriver.createFile(dbConnection, parent, name2, uid, gid, mode, 40960);
            this._sqlDriver.setInodeIo(dbConnection, inode, true);
            this._sqlDriver.write(dbConnection, inode, 0, 0L, dest, 0, dest.length);
            dbConnection.commit();
        }
        catch (SQLException se) {
            _log.error("createLink ", se);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("createLink rollback ", e);
            }
            throw new IOHimeraFsException(se.getMessage());
        }
        catch (Exception se) {
            _log.error("createLink ", se);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("createLink rollback ", e);
            }
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsInode createHLink(FsInode parent, FsInode inode, String name2) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.createEntryInParent(dbConnection, parent, name2, inode);
            this._sqlDriver.incNlink(dbConnection, inode);
            this._sqlDriver.incNlink(dbConnection, parent);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("create hlink rollback ", e);
            }
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public FsInode createFile(String path) throws ChimeraFsException {
        File file = new File(path);
        return this.createFile(this.path2inode(file.getParent()), file.getName());
    }

    @Override
    public FsInode createFile(FsInode parent, String name2) throws ChimeraFsException {
        return this.createFile(parent, name2, 0, 0, 420);
    }

    @Override
    public FsInode createFileLevel(FsInode inode, int level) throws ChimeraFsException {
        return this.createFileLevel(inode, 0, 0, 420, level);
    }

    @Override
    public FsInode createFile(FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException {
        return this.createFile(parent, name2, owner, group, mode, 32768);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsInode createFile(FsInode parent, String name2, int owner, int group, int mode, int type) throws ChimeraFsException {
        FsInode inode;
        block31: {
            Connection dbConnection = null;
            try {
                dbConnection = this._dbConnectionsPool.getConnection();
            }
            catch (SQLException e) {
                throw new BackEndErrorHimeraFsException(e.getMessage());
            }
            inode = null;
            try {
                if (name2.startsWith(".(")) {
                    FsInode accessInode;
                    String[] cmd = PnfsCommandProcessor.process(name2);
                    if (name2.startsWith(".(tag)(") && cmd.length == 2) {
                        this.createTag(parent, cmd[1], owner, group, 420);
                        FsInode_TAG fsInode_TAG = new FsInode_TAG((FileSystemProvider)this, parent.toString(), cmd[1]);
                        return fsInode_TAG;
                    }
                    if (name2.startsWith(".(pset)(") || name2.startsWith(".(fset)(")) {
                        throw new ChimeraFsException("Not supported");
                    }
                    if (name2.startsWith(".(use)(") && cmd.length == 3) {
                        FsInode useInode = this.inodeOf(parent, cmd[2]);
                        int level = Integer.parseInt(cmd[1]);
                        try {
                            dbConnection.setAutoCommit(false);
                            inode = this._sqlDriver.createLevel(dbConnection, useInode, useInode.stat().getUid(), useInode.stat().getGid(), useInode.stat().getMode(), level);
                            dbConnection.commit();
                        }
                        catch (SQLException se) {
                            if (se.getSQLState().startsWith("23")) {
                                throw new FileExistsChimeraFsException(name2);
                            }
                            _log.error("create File: ", se);
                            try {
                                dbConnection.rollback();
                            }
                            catch (SQLException e) {
                                _log.error("create File rollback ", e);
                            }
                        }
                    }
                    if (name2.startsWith(".(access)(") && cmd.length == 3) {
                        accessInode = new FsInode(this, cmd[1]);
                        int accessLevel = Integer.parseInt(cmd[2]);
                        if (accessLevel == 0) {
                            inode = accessInode;
                        } else {
                            try {
                                dbConnection.setAutoCommit(false);
                                inode = this._sqlDriver.createLevel(dbConnection, accessInode, accessInode.stat().getUid(), accessInode.stat().getGid(), accessInode.stat().getMode(), accessLevel);
                                dbConnection.commit();
                            }
                            catch (SQLException se) {
                                if (se.getSQLState().startsWith("23")) {
                                    throw new FileExistsChimeraFsException(name2);
                                }
                                _log.error("create File: ", se);
                                try {
                                    dbConnection.rollback();
                                }
                                catch (SQLException e) {
                                    _log.error("create File rollback ", e);
                                }
                            }
                        }
                    }
                    accessInode = inode;
                    return accessInode;
                }
                try {
                    if (!parent.exists()) {
                        throw new FileNotFoundHimeraFsException("parent=" + parent.toString());
                    }
                    JdbcFs.checkNameLength(name2);
                    if (parent.isDirectory()) {
                        dbConnection.setAutoCommit(false);
                        inode = this._sqlDriver.createFile(dbConnection, parent, name2, owner, group, mode, type);
                        dbConnection.commit();
                        break block31;
                    }
                    throw new NotDirChimeraException(parent);
                }
                catch (SQLException se) {
                    try {
                        dbConnection.rollback();
                    }
                    catch (SQLException e) {
                        _log.error("create File rollback ", e);
                    }
                    if (se.getSQLState().startsWith("23")) {
                        throw new FileExistsChimeraFsException();
                    }
                    _log.error("create File: ", se);
                    throw new IOHimeraFsException(se.getMessage());
                }
            }
            finally {
                SqlHelper.tryToClose(dbConnection);
            }
        }
        return inode;
    }

    @Override
    public void createFileWithId(FsInode parent, FsInode inode, String name2, int owner, int group, int mode, int type) throws ChimeraFsException {
        block12: {
            Connection dbConnection = null;
            try {
                dbConnection = this._dbConnectionsPool.getConnection();
            }
            catch (SQLException e) {
                throw new BackEndErrorHimeraFsException(e.getMessage());
            }
            try {
                if (!parent.exists()) {
                    throw new FileNotFoundHimeraFsException("parent=" + parent.toString());
                }
                if (parent.isDirectory()) {
                    dbConnection.setAutoCommit(false);
                    inode = this._sqlDriver.createFileWithId(dbConnection, parent, inode, name2, owner, group, mode, type);
                    dbConnection.commit();
                    break block12;
                }
                throw new NotDirChimeraException(parent);
            }
            catch (SQLException se) {
                try {
                    dbConnection.rollback();
                }
                catch (SQLException e) {
                    _log.error("create File rollback ", e);
                }
                if (se.getSQLState().startsWith("23")) {
                    throw new FileExistsChimeraFsException();
                }
                _log.error("create File: ", se);
                throw new IOHimeraFsException(se.getMessage());
            }
            finally {
                SqlHelper.tryToClose(dbConnection);
            }
        }
    }

    FsInode createFileLevel(FsInode inode, int owner, int group, int mode, int level) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode levelInode = null;
        try {
            dbConnection.setAutoCommit(false);
            levelInode = this._sqlDriver.createLevel(dbConnection, inode, owner, group, mode | 0x8000, level);
            dbConnection.commit();
        }
        catch (SQLException se) {
            _log.error("create level: ", se);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("create level rollback ", e);
            }
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return levelInode;
    }

    public String[] listDir(String dir) {
        String[] list = null;
        try {
            list = this.listDir(this.path2inode(dir));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public String[] listDir(FsInode dir) throws IOHimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        String[] list = null;
        try {
            dbConnection.setAutoCommit(true);
            list = this._sqlDriver.listDir(dbConnection, dir);
        }
        catch (SQLException se) {
            _log.error("list: ", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return list;
    }

    @Override
    public DirectoryStreamB<HimeraDirectoryEntry> newDirectoryStream(FsInode dir) throws IOHimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            return this._sqlDriver.newDirectoryStream(dbConnection, dir);
        }
        catch (SQLException se) {
            _log.error("list full: ", se);
            throw new IOHimeraFsException(se.getMessage());
        }
    }

    @Override
    public void remove(String path) throws ChimeraFsException {
        FsInode inode = this.path2inode(path);
        FsInode parent = this.getParentOf(inode);
        if (parent == null) {
            throw new ChimeraFsException("Cannot delete file system root.");
        }
        File filePath = new File(path);
        String name2 = filePath.getName();
        this.remove(parent, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(FsInode parent, String name2) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            FsInode inode = this.inodeOf(parent, name2);
            if (inode.type() != FsInodeType.INODE) {
                throw new FileNotFoundHimeraFsException("Not a file.");
            }
            dbConnection.setAutoCommit(false);
            this._sqlDriver.remove(dbConnection, parent, name2);
            dbConnection.commit();
        }
        catch (ChimeraFsException hfe) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("delete rollback", e);
            }
            throw hfe;
        }
        catch (SQLException e) {
            _log.error("delete", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("delete rollback", e1);
            }
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void remove(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            FsInode parent = this._sqlDriver.getParentOf(dbConnection, inode);
            if (parent == null) {
                throw new FileNotFoundHimeraFsException("No such file.");
            }
            if (inode.type() != FsInodeType.INODE) {
                throw new FileNotFoundHimeraFsException("Not a file.");
            }
            this._sqlDriver.remove(dbConnection, parent, inode);
            dbConnection.commit();
        }
        catch (ChimeraFsException hfe) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("delete rollback", e);
            }
            throw hfe;
        }
        catch (SQLException e) {
            _log.error("delete", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("delete rollback", e1);
            }
            throw new BackEndErrorHimeraFsException(e.getMessage(), e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public Stat stat(String path) throws ChimeraFsException {
        return this.stat(this.path2inode(path));
    }

    @Override
    public Stat stat(FsInode inode) throws ChimeraFsException {
        return this.stat(inode, 0);
    }

    @Override
    public Stat stat(FsInode inode, int level) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        Stat stat = null;
        try {
            dbConnection.setAutoCommit(true);
            stat = this._sqlDriver.stat(dbConnection, inode, level);
        }
        catch (SQLException e) {
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        if (stat == null) {
            throw new FileNotFoundHimeraFsException(inode.toString());
        }
        return stat;
    }

    @Override
    public FsInode mkdir(String path) throws ChimeraFsException {
        int li = path.lastIndexOf(47);
        String file = path.substring(li + 1);
        String dir = null;
        dir = li > 1 ? path.substring(0, li) : "/";
        return this.mkdir(this.path2inode(dir), file);
    }

    @Override
    public FsInode mkdir(FsInode parent, String name2) throws ChimeraFsException {
        return this.mkdir(parent, name2, 0, 0, 493);
    }

    @Override
    public FsInode mkdir(FsInode parent, String name2, int owner, int group, int mode) throws ChimeraFsException {
        JdbcFs.checkNameLength(name2);
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode inode = null;
        try {
            dbConnection.setAutoCommit(false);
            inode = this._sqlDriver.mkdir(dbConnection, parent, name2, owner, group, mode);
            this._sqlDriver.copyTags(dbConnection, parent, inode);
            dbConnection.commit();
        }
        catch (SQLException se) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("mkdir", se);
            }
            if (se.getSQLState().startsWith("23")) {
                throw new FileExistsChimeraFsException(name2);
            }
            _log.error("mkdir", se);
            throw new ChimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public FsInode path2inode(String path) throws ChimeraFsException {
        return this.path2inode(path, this._rootInode);
    }

    @Override
    public FsInode path2inode(String path, FsInode startFrom) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode inode = null;
        try {
            dbConnection.setAutoCommit(true);
            inode = this._sqlDriver.path2inode(dbConnection, startFrom, path);
            if (inode == null) {
                throw new FileNotFoundHimeraFsException(path);
            }
        }
        catch (SQLException e) {
            _log.error("path2inode", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return inode;
    }

    @Override
    public FsInode inodeOf(FsInode parent, String name2) throws ChimeraFsException {
        FsInode inode = null;
        if (name2.startsWith(".(")) {
            FsInode useInode;
            int level;
            String[] cmd;
            if (name2.startsWith(".(id)(")) {
                String[] cmd2 = PnfsCommandProcessor.process(name2);
                if (cmd2.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                inode = this.inodeOf(parent, cmd2[1]);
                return new FsInode_ID(this, inode.toString());
            }
            if (name2.startsWith(".(use)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                try {
                    level = Integer.parseInt(cmd[1]);
                    useInode = this.inodeOf(parent, cmd[2]);
                    if (level <= 7) {
                        this.stat(useInode, level);
                        return new FsInode((FileSystemProvider)this, useInode.toString(), level);
                    }
                }
                catch (NumberFormatException nfe) {
                }
                catch (FileNotFoundHimeraFsException e) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
            }
            if (name2.startsWith(".(access)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 2 || cmd.length > 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                try {
                    level = cmd.length == 2 ? 0 : Integer.parseInt(cmd[2]);
                    useInode = new FsInode(this, cmd[1]);
                    if (level <= 7) {
                        this.stat(useInode, level);
                        return new FsInode((FileSystemProvider)this, useInode.toString(), level);
                    }
                }
                catch (NumberFormatException nfe) {
                }
                catch (FileNotFoundHimeraFsException e) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
            }
            if (name2.startsWith(".(nameof)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_NAMEOF nameofInode = new FsInode_NAMEOF(this, cmd[1]);
                if (!nameofInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return nameofInode;
            }
            if (name2.startsWith(".(const)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_CONST constInode = new FsInode_CONST(this, cmd[1]);
                if (!((FsInode)constInode).exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return constInode;
            }
            if (name2.startsWith(".(parent)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_PARENT parentInode = new FsInode_PARENT(this, cmd[1]);
                if (!parentInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return parentInode;
            }
            if (name2.startsWith(".(pathof)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_PATHOF pathofInode = new FsInode_PATHOF(this, cmd[1]);
                if (!pathofInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return pathofInode;
            }
            if (name2.startsWith(".(tag)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                FsInode_TAG tagInode = new FsInode_TAG((FileSystemProvider)this, parent.toString(), cmd[1]);
                if (!((FsInode)tagInode).exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return tagInode;
            }
            if (name2.equals(".(tags)()")) {
                return new FsInode_TAGS(this, parent.toString());
            }
            if (name2.startsWith(".(pset)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                String[] args = new String[cmd.length - 2];
                System.arraycopy(cmd, 2, args, 0, args.length);
                FsInode_PSET psetInode = new FsInode_PSET((FileSystemProvider)this, cmd[1], args);
                if (!psetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return psetInode;
            }
            if (name2.equals(".(get)(cursor)")) {
                FsInode_PGET pgetInode = new FsInode_PGET((FileSystemProvider)this, parent.toString(), new String[0]);
                if (!pgetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return pgetInode;
            }
            if (name2.startsWith(".(get)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                String[] args = new String[cmd.length - 2];
                System.arraycopy(cmd, 2, args, 0, args.length);
                FsInode_PGET pgetInode = new FsInode_PGET((FileSystemProvider)this, parent.toString(), args);
                if (!pgetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return pgetInode;
            }
            if (name2.equals(".(config)")) {
                return new FsInode(this, this._wormID);
            }
            if (name2.startsWith(".(config)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length != 2) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return this.inodeOf(new FsInode(this, this._wormID), cmd[1]);
            }
            if (name2.startsWith(".(fset)(")) {
                cmd = PnfsCommandProcessor.process(name2);
                if (cmd.length < 3) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                String[] args = new String[cmd.length - 2];
                System.arraycopy(cmd, 2, args, 0, args.length);
                FsInode fsetInode = this.inodeOf(parent, cmd[1]);
                if (!fsetInode.exists()) {
                    throw new FileNotFoundHimeraFsException(name2);
                }
                return new FsInode_PSET((FileSystemProvider)this, fsetInode.toString(), args);
            }
        }
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            inode = this._sqlDriver.inodeOf(dbConnection, parent, name2);
            if (inode == null) {
                throw new FileNotFoundHimeraFsException(name2);
            }
        }
        catch (SQLException e) {
            _log.error("inodeOf", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        inode.setParent(parent);
        return inode;
    }

    @Override
    public String inode2path(FsInode inode) throws ChimeraFsException {
        return this.inode2path(inode, this._rootInode, true);
    }

    @Override
    public String inode2path(FsInode inode, FsInode startFrom, boolean inclusive) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        String path = null;
        try {
            dbConnection.setAutoCommit(true);
            path = this._sqlDriver.inode2path(dbConnection, inode, startFrom, inclusive);
        }
        catch (SQLException e) {
            _log.error("inode2path", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return path;
    }

    @Override
    public boolean removeFileMetadata(String path, int level) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        boolean rc = false;
        try {
            dbConnection.setAutoCommit(false);
            rc = this._sqlDriver.removeInodeLevel(dbConnection, this.path2inode(path), level);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("removeFileMetadata", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("removeFileMetadata rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return rc;
    }

    @Override
    public FsInode getParentOf(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        FsInode parent = null;
        try {
            dbConnection.setAutoCommit(true);
            parent = inode.isDirectory() ? this._sqlDriver.getParentOfDirectory(dbConnection, inode) : this._sqlDriver.getParentOf(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("getPathOf", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return parent;
    }

    @Override
    public void setFileSize(FsInode inode, long newSize) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileSize(dbConnection, inode, newSize);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileSize", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileSize rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileOwner(FsInode inode, int newOwner) throws ChimeraFsException {
        this.setFileOwner(inode, 0, newOwner);
    }

    @Override
    public void setFileOwner(FsInode inode, int level, int newOwner) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileOwner(dbConnection, inode, level, newOwner);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileOwner", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileOwner rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileName(FsInode dir, String oldName, String newName) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileName(dbConnection, dir, oldName, newName);
            dbConnection.commit();
        }
        catch (Exception e) {
            _log.error("setFileName", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileName rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setInodeAttributes(FsInode inode, int level, Stat stat) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            switch (inode.type()) {
                case INODE: {
                    this._sqlDriver.setInodeAttributes(dbConnection, inode, level, stat);
                    break;
                }
                case TAG: {
                    this._sqlDriver.setTagMode(dbConnection, (FsInode_TAG)inode, stat.getMode());
                    this._sqlDriver.setTagOwner(dbConnection, (FsInode_TAG)inode, stat.getUid());
                    this._sqlDriver.setTagOwnerGroup(dbConnection, (FsInode_TAG)inode, stat.getGid());
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setInodeAttributes", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setInodeAttributes rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileATime(FsInode inode, long atime) throws ChimeraFsException {
        this.setFileATime(inode, 0, atime);
    }

    @Override
    public void setFileATime(FsInode inode, int level, long atime) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileATime(dbConnection, inode, level, atime);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileATime", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileATime rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileCTime(FsInode inode, long ctime) throws ChimeraFsException {
        this.setFileCTime(inode, 0, ctime);
    }

    @Override
    public void setFileCTime(FsInode inode, int level, long ctime) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileCTime(dbConnection, inode, level, ctime);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileCTime", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileCTime rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileMTime(FsInode inode, long mtime) throws ChimeraFsException {
        this.setFileMTime(inode, 0, mtime);
    }

    @Override
    public void setFileMTime(FsInode inode, int level, long mtime) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileMTime(dbConnection, inode, level, mtime);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileMTime", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileMTime rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileGroup(FsInode inode, int newGroup) throws ChimeraFsException {
        this.setFileGroup(inode, 0, newGroup);
    }

    @Override
    public void setFileGroup(FsInode inode, int level, int newGroup) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileGroup(dbConnection, inode, level, newGroup);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileGroup", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileGroup rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setFileMode(FsInode inode, int newMode) throws ChimeraFsException {
        this.setFileMode(inode, 0, newMode);
    }

    @Override
    public void setFileMode(FsInode inode, int level, int newMode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setFileMode(dbConnection, inode, level, newMode);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setFileMode", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setFileMode rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public boolean isIoEnabled(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        boolean ioEnabled = false;
        try {
            dbConnection.setAutoCommit(true);
            ioEnabled = this._sqlDriver.isIoEnabled(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("isIoEnabled", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return ioEnabled;
    }

    @Override
    public void setInodeIo(FsInode inode, boolean enable) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setInodeIo(dbConnection, inode, enable);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setInodeIo", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setInodeIo rollback", e1);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    public int write(FsInode inode, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        return this.write(inode, 0, beginIndex, data, offset, len);
    }

    @Override
    public int write(FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        if (level == 0 && !inode.isIoEnabled()) {
            _log.debug(inode + ": IO (write) not allowd");
            return -1;
        }
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.write(dbConnection, inode, level, beginIndex, data, offset, len);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("write rollback", e1);
            }
            if (this._sqlDriver.isForeignKeyError(sqlState)) {
                throw new FileNotFoundHimeraFsException();
            }
            _log.error("write", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        catch (IOException e) {
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("write rollback", e1);
            }
            _log.error("write", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return len;
    }

    public int read(FsInode inode, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        return this.read(inode, 0, beginIndex, data, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(FsInode inode, int level, long beginIndex, byte[] data, int offset, int len) throws ChimeraFsException {
        int count = -1;
        if (level == 0 && !inode.isIoEnabled()) {
            _log.debug(inode + ": IO(read) not allowd");
            return -1;
        }
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            count = this._sqlDriver.read(dbConnection, inode, level, beginIndex, data, offset, len);
        }
        catch (SQLException se) {
            _log.debug("read:", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        catch (IOException e) {
            _log.debug("read IO:", e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return count;
    }

    @Override
    public byte[] readLink(String path) throws ChimeraFsException {
        return this.readLink(this.path2inode(path));
    }

    @Override
    public byte[] readLink(FsInode inode) throws ChimeraFsException {
        byte[] link = null;
        byte[] b = new byte[(int)inode.statCache().getSize()];
        int n = this.read(inode, 0L, b, 0, b.length);
        link = n >= 0 ? b : new byte[]{};
        return link;
    }

    @Override
    public boolean move(String source, String dest) {
        boolean rc = false;
        try {
            File what = new File(source);
            File where = new File(dest);
            rc = this.move(this.path2inode(what.getParent()), what.getName(), this.path2inode(where.getParent()), where.getName());
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    @Override
    public boolean move(FsInode srcDir, String source, FsInode destDir, String dest) throws ChimeraFsException {
        JdbcFs.checkNameLength(dest);
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        boolean rc = false;
        try {
            dbConnection.setAutoCommit(false);
            if (!srcDir.equals(destDir)) {
                this._sqlDriver.move(dbConnection, srcDir, source, destDir, dest);
            } else {
                this._sqlDriver.setFileName(dbConnection, srcDir, source, dest);
            }
            dbConnection.commit();
            rc = true;
        }
        catch (SQLException e) {
            _log.error("move:", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("move rollback:", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return rc;
    }

    @Override
    public List<StorageLocatable> getInodeLocations(FsInode inode, int type) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        List<StorageLocatable> locations = null;
        try {
            dbConnection.setAutoCommit(true);
            locations = this._sqlDriver.getInodeLocations(dbConnection, inode, type);
        }
        catch (SQLException se) {
            _log.error("getInodeLocations", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInodeLocation(FsInode inode, int type, String location) throws ChimeraFsException {
        block11: {
            Connection dbConnection = null;
            try {
                dbConnection = this._dbConnectionsPool.getConnection();
            }
            catch (SQLException e) {
                throw new BackEndErrorHimeraFsException(e.getMessage());
            }
            try {
                dbConnection.setAutoCommit(false);
                this._sqlDriver.addInodeLocation(dbConnection, inode, type, location);
                dbConnection.commit();
            }
            catch (SQLException se) {
                String sqlState = se.getSQLState();
                try {
                    dbConnection.rollback();
                }
                catch (SQLException e) {
                    _log.error("addInodeLocation rollback ", e);
                }
                if (this._sqlDriver.isForeignKeyError(sqlState)) {
                    throw new FileNotFoundHimeraFsException();
                }
                if (this._sqlDriver.isDuplicatedKeyError(sqlState)) {
                    break block11;
                }
                _log.error("addInodeLocation:  [" + sqlState + "]", se);
                throw new IOHimeraFsException(se.getMessage());
            }
            finally {
                SqlHelper.tryToClose(dbConnection);
            }
        }
    }

    @Override
    public void clearInodeLocation(FsInode inode, int type, String location) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.clearInodeLocation(dbConnection, inode, type, location);
            dbConnection.commit();
        }
        catch (SQLException se) {
            _log.error("clearInodeLocation", se);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e) {
                _log.error("clearInodeLocation rollback ", se);
            }
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public String[] tags(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        String[] list = null;
        try {
            dbConnection.setAutoCommit(true);
            list = this._sqlDriver.tags(dbConnection, inode);
        }
        catch (SQLException se) {
            _log.error("tags", se);
            throw new IOHimeraFsException(se.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return list;
    }

    @Override
    public void createTag(FsInode inode, String name2) throws ChimeraFsException {
        this.createTag(inode, name2, 0, 0, 420);
    }

    @Override
    public void createTag(FsInode inode, String name2, int uid, int gid, int mode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.createTag(dbConnection, inode, name2, uid, gid, mode);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("createTag", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("createTag rollback", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setTag(FsInode inode, String tagName, byte[] data, int offset, int len) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTag(dbConnection, inode, tagName, data, offset, len);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTag", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setTag rollback", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        catch (ChimeraFsException e) {
            _log.error("setTag", e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return len;
    }

    @Override
    public void removeTag(FsInode dir, String tagName) throws ChimeraFsException {
        throw new ChimeraFsException("Permission Deny (inherited tag)");
    }

    @Override
    public void removeTag(FsInode dir) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.removeTag(dbConnection, dir);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("removeTag", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("removeTag rollback", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTag(FsInode inode, String tagName, byte[] data, int offset, int len) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        int count = -1;
        try {
            dbConnection.setAutoCommit(true);
            count = this._sqlDriver.getTag(dbConnection, inode, tagName, data, offset, len);
        }
        catch (SQLException e) {
            _log.error("getTag", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        catch (IOException e) {
            _log.error("getTag io", e);
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return count;
    }

    @Override
    public Stat statTag(FsInode dir, String name2) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        Stat ret = null;
        try {
            dbConnection.setAutoCommit(true);
            ret = this._sqlDriver.statTag(dbConnection, dir, name2);
        }
        catch (SQLException e) {
            _log.error("statTag", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return ret;
    }

    @Override
    public void setTagOwner(FsInode_TAG tagInode, String name2, int owner) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTagOwner(dbConnection, tagInode, owner);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTagOwner", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setTagOwner rollback", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setTagOwnerGroup(FsInode_TAG tagInode, String name2, int owner) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTagOwnerGroup(dbConnection, tagInode, owner);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTagOwnerGroup", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setTagOwnerGroup rollback", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setTagMode(FsInode_TAG tagInode, String name2, int mode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setTagMode(dbConnection, tagInode, mode);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("setTagMode", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException e1) {
                _log.error("setTagMode rollback", e);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public int getFsId() {
        return this._fsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStorageInfo(FsInode inode, InodeStorageInformation storageInfo) throws ChimeraFsException {
        block11: {
            Connection dbConnection = null;
            try {
                dbConnection = this._dbConnectionsPool.getConnection();
            }
            catch (SQLException e) {
                throw new BackEndErrorHimeraFsException(e.getMessage());
            }
            try {
                dbConnection.setAutoCommit(false);
                this._sqlDriver.setStorageInfo(dbConnection, inode, storageInfo);
                dbConnection.commit();
            }
            catch (SQLException se) {
                String sqlState = se.getSQLState();
                try {
                    dbConnection.rollback();
                }
                catch (SQLException e) {
                    _log.error("setStorageInfo rollback ", e);
                }
                if (this._sqlDriver.isForeignKeyError(sqlState)) {
                    throw new FileNotFoundHimeraFsException();
                }
                if (this._sqlDriver.isDuplicatedKeyError(sqlState)) {
                    break block11;
                }
                _log.error("setStorageInfo:  [" + sqlState + "]", se);
                throw new IOHimeraFsException(se.getMessage());
            }
            finally {
                SqlHelper.tryToClose(dbConnection);
            }
        }
    }

    @Override
    public void setAccessLatency(FsInode inode, AccessLatency accessLatency) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setAccessLatency(dbConnection, inode, accessLatency);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            try {
                dbConnection.rollback();
            }
            catch (SQLException ee) {
                _log.error("setAccessLatensy rollback ", ee);
            }
            if (this._sqlDriver.isForeignKeyError(sqlState)) {
                throw new FileNotFoundHimeraFsException();
            }
            _log.error("setAccessLatency:  [" + sqlState + "]", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public void setRetentionPolicy(FsInode inode, RetentionPolicy retentionPolicy) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setRetentionPolicy(dbConnection, inode, retentionPolicy);
            dbConnection.commit();
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            try {
                dbConnection.rollback();
            }
            catch (SQLException ee) {
                _log.error("setRetentionPolicy rollback ", ee);
            }
            if (this._sqlDriver.isForeignKeyError(sqlState)) {
                throw new FileNotFoundHimeraFsException();
            }
            _log.error("setRetentionPolicy:  [" + sqlState + "]", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public InodeStorageInformation getStorageInfo(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        InodeStorageInformation storageInfo = null;
        try {
            dbConnection.setAutoCommit(true);
            storageInfo = this._sqlDriver.getSorageInfo(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("setSorageInfo", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return storageInfo;
    }

    @Override
    public AccessLatency getAccessLatency(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        AccessLatency accessLatency = null;
        try {
            dbConnection.setAutoCommit(true);
            accessLatency = this._sqlDriver.getAccessLatency(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("setSorageInfo", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return accessLatency;
    }

    @Override
    public RetentionPolicy getRetentionPolicy(FsInode inode) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        RetentionPolicy retentionPolicy = null;
        try {
            dbConnection.setAutoCommit(true);
            retentionPolicy = this._sqlDriver.getRetentionPolicy(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("setSorageInfo", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return retentionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInodeChecksum(FsInode inode, int type, String checksum) throws ChimeraFsException {
        block11: {
            Connection dbConnection = null;
            try {
                dbConnection = this._dbConnectionsPool.getConnection();
            }
            catch (SQLException e) {
                throw new BackEndErrorHimeraFsException(e.getMessage());
            }
            try {
                dbConnection.setAutoCommit(false);
                this._sqlDriver.setInodeChecksum(dbConnection, inode, type, checksum);
                dbConnection.commit();
            }
            catch (SQLException e) {
                String sqlState = e.getSQLState();
                try {
                    dbConnection.rollback();
                }
                catch (SQLException ee) {
                    _log.error("setInodeChecksum rollback ", ee);
                }
                if (this._sqlDriver.isForeignKeyError(sqlState)) {
                    throw new FileNotFoundHimeraFsException();
                }
                if (this._sqlDriver.isDuplicatedKeyError(sqlState)) {
                    break block11;
                }
                _log.error("setInodeChecksum:  [" + sqlState + "]", e);
                throw new IOHimeraFsException(e.getMessage());
            }
            finally {
                SqlHelper.tryToClose(dbConnection);
            }
        }
    }

    @Override
    public void removeInodeChecksum(FsInode inode, int type) throws ChimeraFsException {
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            this._sqlDriver.removeInodeChecksum(dbConnection, inode, type);
        }
        catch (SQLException e) {
            _log.error("removeInodeChecksum", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    @Override
    public String getInodeChecksum(FsInode inode, int type) throws ChimeraFsException {
        String checkSum = null;
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            checkSum = this._sqlDriver.getInodeChecksum(dbConnection, inode, type);
        }
        catch (SQLException e) {
            _log.error("getInodeChecksum", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return checkSum;
    }

    @Override
    public List<ACE> getACL(FsInode inode) throws ChimeraFsException {
        List<ACE> acl;
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(true);
            acl = this._sqlDriver.getACL(dbConnection, inode);
        }
        catch (SQLException e) {
            _log.error("Failed go getACL:", e);
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        return acl;
    }

    @Override
    public void setACL(FsInode inode, List<ACE> acl) throws ChimeraFsException {
        Connection dbConnection;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
        }
        catch (SQLException e) {
            throw new BackEndErrorHimeraFsException(e.getMessage());
        }
        try {
            dbConnection.setAutoCommit(false);
            this._sqlDriver.setACL(dbConnection, inode, acl);
            dbConnection.commit();
        }
        catch (SQLException e) {
            _log.error("Failed to set ACL: ", e);
            try {
                dbConnection.rollback();
            }
            catch (SQLException ee) {
                _log.error("setACL rollback ", ee);
            }
            throw new IOHimeraFsException(e.getMessage());
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
    }

    private static void checkNameLength(String name2) throws InvalidNameChimeraException {
        if (name2.length() > 255) {
            throw new InvalidNameChimeraException("Name too long");
        }
    }

    @Override
    public FsStat getFsStat() throws ChimeraFsException {
        return this._fsStatCache.getFsStat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo() {
        String databaseProductName = "Unknown";
        String databaseProductVersion = "Unknown";
        Connection dbConnection = null;
        try {
            dbConnection = this._dbConnectionsPool.getConnection();
            if (dbConnection != null) {
                databaseProductName = dbConnection.getMetaData().getDatabaseProductName();
                databaseProductVersion = dbConnection.getMetaData().getDatabaseProductVersion();
            }
        }
        catch (SQLException se) {
        }
        finally {
            SqlHelper.tryToClose(dbConnection);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DB        : ").append(this._dbConnectionsPool.toString()).append("\n");
        sb.append("DB Engine : ").append(databaseProductName).append(" ").append(databaseProductVersion).append("\n");
        sb.append("rootID    : ").append(this._rootInode.toString()).append("\n");
        sb.append("wormID    : ").append(this._wormID).append("\n");
        sb.append("FsId      : ").append(this._fsId).append("\n");
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public FsInode inodeFromBytes(byte[] handle) throws ChimeraFsException {
        FsInode inode = null;
        String strHandle = new String(handle);
        _log.debug("Processing FH: {}", (Object)strHandle);
        StringTokenizer st = new StringTokenizer(strHandle, "[:]");
        if (st.countTokens() < 3) {
            throw new IllegalArgumentException("Invalid HimeraNFS handler.(" + strHandle + ")");
        }
        int fsId = Integer.parseInt(st.nextToken());
        String type = st.nextToken();
        try {
            FsInodeType inodeType = FsInodeType.valueOf(type);
            switch (inodeType) {
                case INODE: {
                    String id = st.nextToken();
                    int level = 0;
                    if (st.countTokens() > 0) {
                        level = Integer.parseInt(st.nextToken());
                    }
                    inode = new FsInode((FileSystemProvider)this, id, level);
                    break;
                }
                case ID: {
                    String id = st.nextToken();
                    inode = new FsInode_ID(this, id);
                    break;
                }
                case TAGS: {
                    String id = st.nextToken();
                    inode = new FsInode_TAGS(this, id);
                    break;
                }
                case TAG: {
                    String id = st.nextToken();
                    String tag = st.nextToken();
                    inode = new FsInode_TAG((FileSystemProvider)this, id, tag);
                    break;
                }
                case NAMEOF: {
                    String id = st.nextToken();
                    inode = new FsInode_NAMEOF(this, id);
                    break;
                }
                case PARENT: {
                    String id = st.nextToken();
                    inode = new FsInode_PARENT(this, id);
                    break;
                }
                case PATHOF: {
                    String id = st.nextToken();
                    inode = new FsInode_PATHOF(this, id);
                    break;
                }
                case CONST: {
                    String cnst = st.nextToken();
                    inode = new FsInode_CONST(this, cnst);
                    break;
                }
                case PSET: {
                    String id = st.nextToken();
                    int argc = st.countTokens();
                    String[] args = new String[argc];
                    for (int i = 0; i < argc; ++i) {
                        args[i] = st.nextToken();
                    }
                    inode = new FsInode_PSET((FileSystemProvider)this, id, args);
                    break;
                }
                case PGET: {
                    String id = st.nextToken();
                    int argc = st.countTokens();
                    String[] args = new String[argc];
                    for (int i = 0; i < argc; ++i) {
                        args[i] = st.nextToken();
                    }
                    inode = new FsInode_PGET((FileSystemProvider)this, id, args);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            _log.info("Failed to generate an inode from file handle : {} : {}", (Object)strHandle, (Object)iae);
            inode = null;
        }
        return inode;
    }

    @Override
    public byte[] inodeToBytes(FsInode inode) throws ChimeraFsException {
        return inode.toFullString().getBytes();
    }

    static class FsStatCache {
        private FsStat _fsStatCached = null;
        private long _fsStatLastUpdate = 0L;
        private long _fsStateLifetime = 3600000L;
        private final JdbcFs _fs;

        FsStatCache(JdbcFs fs) {
            this._fs = fs;
        }

        public synchronized FsStat getFsStat() throws ChimeraFsException {
            if (this._fsStatLastUpdate == 0L || this._fsStatLastUpdate + this._fsStateLifetime < System.currentTimeMillis()) {
                this._fsStatCached = new FsStat(0x28000000000000L, 0x3C00000L, this._fs.usedSpace(), this._fs.usedFiles());
                _log.debug("updateing cached value of FsStat");
                this._fsStatLastUpdate = System.currentTimeMillis();
            } else {
                _log.debug("using cached value of FsStat");
            }
            return this._fsStatCached;
        }
    }
}

