/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.chimera.posix.UnixUser;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.NfsUser;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NFSv41Session;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.ServerIdProvider;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.server_owner4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundContext {
    private static final Logger _log = LoggerFactory.getLogger(CompoundContext.class);
    private static final Principal NO_PRINCIPAL = new Principal(){
        private final String _name = "";

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass().isInstance(this);
        }
    };
    private Inode _rootInode = null;
    private Inode _currentInode = null;
    private Inode _savedInode = null;
    private final int _minorversion;
    private NFSv41Session _session = null;
    private final VirtualFileSystem _fs;
    private final RpcCall _callInfo;
    private final UnixUser _user;
    private final ExportFile _exportFile;
    private final NFSv41DeviceManager _deviceManager;
    private final NFSv4StateHandler _stateHandler;
    private final NfsIdMapping _idMapping;
    private int _slotId;
    private boolean _cacheThis;
    private final int _totalOperationsCount;
    private int _currentOpPosition = -1;
    private stateid4 _currentStateid = null;
    private stateid4 _savedStateid = null;
    private final Principal _principal;
    private List<nfs_resop4> _cache;

    public CompoundContext(int minorversion, VirtualFileSystem fs, NFSv4StateHandler stateHandler, NFSv41DeviceManager deviceManager, RpcCall call, NfsIdMapping idMapping, ExportFile exportFile, int opCount) {
        this._minorversion = minorversion;
        this._fs = fs;
        this._deviceManager = deviceManager;
        this._callInfo = call;
        this._exportFile = exportFile;
        this._user = NfsUser.remoteUser(this._callInfo, this._exportFile);
        this._stateHandler = stateHandler;
        this._idMapping = idMapping;
        this._totalOperationsCount = opCount;
        this._principal = this.principalOf(call);
    }

    public RpcCall getRpcCall() {
        return this._callInfo;
    }

    public UnixUser getUser() {
        return this._user;
    }

    public VirtualFileSystem getFs() {
        return this._fs;
    }

    public NFSv41DeviceManager getDeviceManager() {
        return this._deviceManager;
    }

    public int getMinorversion() {
        return this._minorversion;
    }

    public Inode currentInode() throws ChimeraNFSException {
        if (this._currentInode == null) {
            throw new ChimeraNFSException(10020, "no file handle");
        }
        return this._currentInode;
    }

    public void currentInode(Inode inode) throws ChimeraNFSException {
        this._currentInode = inode;
        _log.debug("current Inode: {}", (Object)this._currentInode);
    }

    public void clearCurrentInode() throws ChimeraNFSException {
        this._currentInode = null;
    }

    public Inode rootInode() {
        return this._rootInode;
    }

    public void rootInode(Inode inode) {
        this._rootInode = inode;
        _log.debug("root Inode: {}", (Object)this._rootInode);
    }

    public void restoreSavedInode() throws ChimeraNFSException {
        if (this._savedInode == null) {
            throw new ChimeraNFSException(10030, "no saved file handle");
        }
        this._currentInode = this._savedInode;
        this._currentStateid = this._savedStateid;
        _log.debug("restored Inode: {}", (Object)this._currentInode);
    }

    public Inode savedInode() throws ChimeraNFSException {
        if (this._savedInode == null) {
            throw new ChimeraNFSException(10020, "no file handle");
        }
        return this._savedInode;
    }

    public void saveCurrentInode() throws ChimeraNFSException {
        if (this._currentInode == null) {
            throw new ChimeraNFSException(10020, "no file handle");
        }
        this._savedInode = this._currentInode;
        this._savedStateid = this._currentStateid;
        _log.debug("saved Inode: {}", (Object)this._savedInode);
    }

    public void setSession(NFSv41Session session) {
        this._session = session;
    }

    public NFSv41Session getSession() {
        return this._session;
    }

    public NFSv4StateHandler getStateHandler() {
        return this._stateHandler;
    }

    public NfsIdMapping getIdMapping() {
        return this._idMapping;
    }

    public int getSlotId() {
        return this._slotId;
    }

    public void setSlotId(int slotId) {
        this._slotId = slotId;
    }

    public boolean cacheThis() {
        return this._cacheThis;
    }

    public void setCacheThis(boolean cacheThis) {
        this._cacheThis = cacheThis;
    }

    public List<nfs_resop4> getCache() {
        return this._cache;
    }

    public void setCache(List<nfs_resop4> cache) {
        this._cache = cache;
    }

    public int getOperationPosition() {
        return this._currentOpPosition;
    }

    public int getTotalOperationCount() {
        return this._totalOperationsCount;
    }

    public void nextOperation() {
        assert (this._currentOpPosition < this._totalOperationsCount);
        ++this._currentOpPosition;
    }

    public stateid4 currentStateid() throws ChimeraNFSException {
        if (this._currentStateid == null) {
            throw new ChimeraNFSException(10025, "no current stateid");
        }
        return this._currentStateid;
    }

    public void currentStateid(stateid4 currentStateid) {
        this._currentStateid = currentStateid;
    }

    public ServerIdProvider getServerIdProvider() {
        return new ServerIdProvider(){

            @Override
            public server_owner4 getOwner() {
                server_owner4 owner = new server_owner4();
                owner.so_minor_id = new uint64_t(0L);
                owner.so_major_id = CompoundContext.this._callInfo.getTransport().getLocalSocketAddress().getAddress().getAddress();
                return owner;
            }

            @Override
            public byte[] getScope() {
                return "".getBytes();
            }
        };
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    private Principal principalOf(RpcCall call) {
        if (call.getCredential().type() != 6) {
            return NO_PRINCIPAL;
        }
        Set<KerberosPrincipal> principals = call.getCredential().getSubject().getPrincipals(KerberosPrincipal.class);
        return principals.isEmpty() ? NO_PRINCIPAL : (Principal)principals.iterator().next();
    }
}

