/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.OperationSETATTR;
import org.dcache.nfs.v4.xdr.CREATE4res;
import org.dcache.nfs.v4.xdr.CREATE4resok;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.xdr.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationCREATE
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationCREATE.class);

    OperationCREATE(nfs_argop4 args) {
        super(args, 6);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        Inode inode;
        CREATE4res res = result.opcreate;
        fattr4 objAttr = this._args.opcreate.createattrs;
        int type = this._args.opcreate.objtype.type;
        Stat stat = context.getFs().getattr(context.currentInode());
        String name2 = NameFilter.convert(this._args.opcreate.objname.value.value.value);
        if (name2.length() == 0) {
            throw new ChimeraNFSException(22, "bad path name");
        }
        if (name2.length() > 255) {
            throw new ChimeraNFSException(63, "name too long");
        }
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new ChimeraNFSException(20, "not a directory");
        }
        if (name2.equals(".") || name2.equals("..")) {
            throw new ChimeraNFSException(10041, "bad name '.' or '..'");
        }
        try {
            switch (type) {
                case 2: {
                    inode = context.getFs().mkdir(context.currentInode(), name2, context.getUser().getUID(), context.getUser().getGID(), 511);
                    break;
                }
                case 5: {
                    String linkDest = new String(this._args.opcreate.objtype.linkdata.value.value.value);
                    inode = context.getFs().symlink(context.currentInode(), name2, linkDest, context.getUser().getUID(), context.getUser().getGID(), 511);
                    break;
                }
                case 3: {
                    inode = context.getFs().create(context.currentInode(), Stat.Type.BLOCK, name2, context.getUser().getUID(), context.getUser().getGID(), 511);
                    break;
                }
                case 4: {
                    inode = context.getFs().create(context.currentInode(), Stat.Type.CHAR, name2, context.getUser().getUID(), context.getUser().getGID(), 511);
                    break;
                }
                case 7: {
                    inode = context.getFs().create(context.currentInode(), Stat.Type.FIFO, name2, context.getUser().getUID(), context.getUser().getGID(), 511);
                    break;
                }
                case 6: {
                    inode = context.getFs().create(context.currentInode(), Stat.Type.SOCK, name2, context.getUser().getUID(), context.getUser().getGID(), 511);
                    break;
                }
                case 8: 
                case 9: {
                    throw new ChimeraNFSException(10004, "create of this type not supported");
                }
                case 1: {
                    throw new ChimeraNFSException(10007, "create of regular files handled by OPEN");
                }
                default: {
                    throw new ChimeraNFSException(10007, "bad file type");
                }
            }
        }
        catch (FileExistsChimeraFsException e) {
            throw new ChimeraNFSException(17, "path already exist");
        }
        res.status = 0;
        res.resok4 = new CREATE4resok();
        res.resok4.attrset = OperationSETATTR.setAttributes(objAttr, inode, context);
        res.resok4.cinfo = new change_info4();
        res.resok4.cinfo.atomic = true;
        res.resok4.cinfo.before = new changeid4(new uint64_t(stat.getMTime()));
        res.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
        context.currentInode(inode);
    }
}

