/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.chimera.FileExistsChimeraFsException;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFS4State;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.OperationSETATTR;
import org.dcache.nfs.v4.xdr.OPEN4res;
import org.dcache.nfs.v4.xdr.OPEN4resok;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.change_info4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.open_delegation4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.xdr.OncRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOPEN
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationOPEN.class);

    OperationOPEN(nfs_argop4 args) {
        super(args, 18);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException, OncRpcException {
        OPEN4res res = result.opopen;
        try {
            NFS4Client client;
            Long clientid = this._args.opopen.owner.value.clientid.value.value;
            if (context.getMinorversion() > 0) {
                client = context.getSession().getClient();
            } else {
                client = context.getStateHandler().getClientByID(clientid);
                if (client == null || !client.isConfirmed()) {
                    throw new ChimeraNFSException(10022, "bad client id.");
                }
                client.updateLeaseTime();
                _log.debug("open request form clientid: {}, owner: {}", (Object)client, (Object)new String(this._args.opopen.owner.value.owner));
            }
            res.resok4 = new OPEN4resok();
            res.resok4.attrset = new bitmap4();
            res.resok4.attrset.value = new uint32_t[2];
            res.resok4.attrset.value[0] = new uint32_t(0);
            res.resok4.attrset.value[1] = new uint32_t(0);
            res.resok4.delegation = new open_delegation4();
            res.resok4.delegation.delegation_type = 0;
            switch (this._args.opopen.claim.claim) {
                case 0: {
                    Inode inode;
                    Stat stat = context.getFs().getattr(context.currentInode());
                    if (stat.type() != Stat.Type.DIRECTORY) {
                        throw new ChimeraNFSException(20, "not a directory");
                    }
                    String name2 = NameFilter.convert(this._args.opopen.claim.file.value.value.value);
                    _log.debug("regular open for : {}", (Object)name2);
                    if (this._args.opopen.openhow.opentype == 1) {
                        boolean exclusive = this._args.opopen.openhow.how.mode == 2 || this._args.opopen.openhow.how.mode == 3;
                        try {
                            _log.debug("Creating a new file: {}", (Object)name2);
                            inode = context.getFs().create(context.currentInode(), Stat.Type.REGULAR, name2, context.getUser().getUID(), context.getUser().getGID(), 384);
                            switch (this._args.opopen.openhow.how.mode) {
                                case 0: 
                                case 1: {
                                    res.resok4.attrset = OperationSETATTR.setAttributes(this._args.opopen.openhow.how.createattrs, inode, context);
                                    break;
                                }
                            }
                        }
                        catch (FileExistsChimeraFsException e) {
                            if (exclusive) {
                                throw new ChimeraNFSException(17, "file already exist");
                            }
                            inode = context.getFs().lookup(context.currentInode(), name2);
                            if (_log.isDebugEnabled()) {
                                Stat fileStat = context.getFs().getattr(context.currentInode());
                                _log.debug("Opening existing file: {}, uid: {}, gid: {}, mode: 0{}", name2, fileStat.getUid(), fileStat.getGid(), Integer.toOctalString(fileStat.getMode() & 0x1FF));
                            }
                            if (context.getFs().access(inode, 4) == 0) {
                                throw new ChimeraNFSException(13, "Permission denied.");
                            }
                            OperationSETATTR.setAttributes(this._args.opopen.openhow.how.createattrs, inode, context);
                        }
                    } else {
                        inode = context.getFs().lookup(context.currentInode(), name2);
                        stat = context.getFs().getattr(inode);
                        if ((this._args.opopen.share_access.value & 1) != 0 && context.getFs().access(inode, 1) == 0) {
                            throw new ChimeraNFSException(13, "Permission denied.");
                        }
                        if ((this._args.opopen.share_access.value & 2) != 0 && context.getFs().access(inode, 4) == 0) {
                            throw new ChimeraNFSException(13, "Permission denied.");
                        }
                        if (stat.type() == Stat.Type.DIRECTORY) {
                            throw new ChimeraNFSException(21, "path is a directory");
                        }
                        if (stat.type() == Stat.Type.SYMLINK) {
                            throw new ChimeraNFSException(10029, "path is a symlink");
                        }
                    }
                    context.currentInode(inode);
                    break;
                }
                case 4: {
                    _log.debug("open by Inode for : {}", (Object)context.currentInode());
                    Inode inode = context.currentInode();
                    Stat stat = context.getFs().getattr(inode);
                    if (this._args.opopen.share_access.value == 1 && context.getFs().access(inode, 1) == 0) {
                        throw new ChimeraNFSException(13, "Permission denied.");
                    }
                    if ((this._args.opopen.share_access.value == 3 || this._args.opopen.share_access.value == 2) && context.getFs().access(inode, 4) == 0) {
                        throw new ChimeraNFSException(13, "Permission denied.");
                    }
                    if (stat.type() == Stat.Type.DIRECTORY) {
                        throw new ChimeraNFSException(21, "path is a directory");
                    }
                    if (stat.type() != Stat.Type.SYMLINK) break;
                    throw new ChimeraNFSException(10029, "path is a symlink");
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    _log.warn("Unimplemented open claim: {}", (Object)this._args.opopen.claim.claim);
                    throw new ChimeraNFSException(10036, "Unimplemented open claim: {}" + this._args.opopen.claim.claim);
                }
                default: {
                    _log.warn("BAD open claim: {}", (Object)this._args.opopen.claim.claim);
                    throw new ChimeraNFSException(10036, "BAD open claim: {}" + this._args.opopen.claim.claim);
                }
            }
            res.resok4.cinfo = new change_info4();
            res.resok4.cinfo.atomic = true;
            res.resok4.cinfo.before = new changeid4(new uint64_t(context.getFs().getattr(context.currentInode()).getMTime()));
            res.resok4.cinfo.after = new changeid4(new uint64_t(System.currentTimeMillis()));
            res.resok4.rflags = context.getMinorversion() > 0 ? new uint32_t(4) : new uint32_t(6);
            NFS4State nfs4state = client.createState();
            res.resok4.stateid = nfs4state.stateid();
            _log.debug("New stateID: {}", (Object)nfs4state.stateid());
            res.status = 0;
        }
        catch (FileExistsChimeraFsException e) {
            _log.debug("OPEN: {}", (Object)e.getMessage());
            res.status = 17;
        }
        catch (FileNotFoundHimeraFsException fnf) {
            _log.debug("OPEN: {}", (Object)fnf.getMessage());
            res.status = 2;
        }
    }
}

