/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4.xdr;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;

public class bitmap4
implements XdrAble,
Iterable<Integer> {
    public uint32_t[] value;

    public bitmap4() {
    }

    public bitmap4(uint32_t[] value) {
        this.value = value;
    }

    public bitmap4(XdrDecodingStream xdr) throws OncRpcException, IOException {
        this.xdrDecode(xdr);
    }

    @Override
    public void xdrEncode(XdrEncodingStream xdr) throws OncRpcException, IOException {
        int $size = this.value.length;
        xdr.xdrEncodeInt($size);
        for (int $idx = 0; $idx < $size; ++$idx) {
            this.value[$idx].xdrEncode(xdr);
        }
    }

    @Override
    public void xdrDecode(XdrDecodingStream xdr) throws OncRpcException, IOException {
        int $size = xdr.xdrDecodeInt();
        this.value = new uint32_t[$size];
        for (int $idx = 0; $idx < $size; ++$idx) {
            this.value[$idx] = new uint32_t(xdr);
        }
    }

    public static bitmap4 of(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("No values provided");
        }
        int max = values[0];
        for (int v : values) {
            if (v <= max) continue;
            max = v;
        }
        int n = max / 32 + 1;
        bitmap4 bitmap = new bitmap4(new uint32_t[n]);
        for (int i = 0; i < n; ++i) {
            bitmap.value[i] = new uint32_t();
        }
        for (int v : values) {
            int bit = v % 32;
            bitmap.value[v / 32].value |= 1 << bit;
        }
        return bitmap;
    }

    public void set(int bit) {
        this.ensureCapacity(bit);
        this.value[bit / 32].value |= 1 << bit % 32;
    }

    public boolean isSet(int bit) {
        int bitmapIdx = bit / 32;
        if (this.value == null || bitmapIdx + 1 > this.value.length) {
            return false;
        }
        return (this.value[bitmapIdx].value >> bit % 32 & 1) > 0;
    }

    private void ensureCapacity(int bit) {
        int expected = bit / 32 + 1;
        if (this.value == null || this.value.length < expected) {
            int initIndex;
            uint32_t[] newBitmap = new uint32_t[expected];
            int n = initIndex = this.value == null ? 0 : this.value.length;
            if (this.value != null) {
                System.arraycopy(this.value, 0, newBitmap, 0, this.value.length);
            }
            for (int i = initIndex; i < newBitmap.length; ++i) {
                newBitmap[i] = new uint32_t(0);
            }
            this.value = newBitmap;
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int currentIndex = -1;

            @Override
            public boolean hasNext() {
                if (bitmap4.this.value == null || this.currentIndex > bitmap4.this.value.length * 32) {
                    return false;
                }
                ++this.currentIndex;
                while (this.currentIndex < bitmap4.this.value.length * 32) {
                    int bitmapIdx = this.currentIndex / 32;
                    int bit = bitmap4.this.value[bitmapIdx].value >> this.currentIndex % 32 & 1;
                    if (bit != 0) {
                        return true;
                    }
                    ++this.currentIndex;
                }
                return false;
            }

            @Override
            public Integer next() {
                this.checkPosition();
                return this.currentIndex;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void checkPosition() {
                if (bitmap4.this.value == null || this.currentIndex < 0 || this.currentIndex > bitmap4.this.value.length * 32) {
                    throw new NoSuchElementException();
                }
            }
        };
    }
}

