/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.ManagedOperation;
import org.glassfish.gmbal.NameValue;
import org.glassfish.gmbal.ParameterNames;
import org.glassfish.gmbal.impl.AttributeDescriptor;
import org.glassfish.gmbal.impl.DescriptorIntrospector;
import org.glassfish.gmbal.impl.DescriptorUtility;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.ManagedObjectManagerImpl;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.impl.trace.TraceRegistration;
import org.glassfish.gmbal.impl.trace.TraceRegistrationFine;
import org.glassfish.gmbal.impl.trace.TraceRuntime;
import org.glassfish.gmbal.typelib.EvaluatedClassAnalyzer;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;
import org.glassfish.pfl.basic.algorithm.DumpIgnore;
import org.glassfish.pfl.basic.algorithm.DumpToString;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.facet.FacetAccessor;
import org.glassfish.pfl.basic.func.BinaryFunction;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceRegistrationFine
@TraceRegistration
@TraceRuntime
public class MBeanSkeleton {
    private static Descriptor DEFAULT_AMX_DESCRIPTOR = DescriptorIntrospector.descriptorForElement(null, ManagedObjectManagerImpl.DefaultAMXMetadataHolder.class);
    private AMXMetadata mbeanType;
    private final String type;
    private Descriptor descriptor;
    @DumpToString
    private final AtomicLong sequenceNumber;
    @DumpToString
    private final ManagedObjectManagerInternal mom;
    @DumpIgnore
    private final Map<String, AttributeDescriptor> setters;
    private final Map<String, AttributeDescriptor> getters;
    private AttributeDescriptor nameAttributeDescriptor;
    private final Map<String, Map<List<String>, Operation>> operations;
    private final List<ModelMBeanAttributeInfo> mbeanAttributeInfoList;
    private final List<ModelMBeanOperationInfo> mbeanOperationInfoList;
    private final ModelMBeanInfoSupport mbInfo;
    private static final Permission accessControlPermission = new ReflectPermission("suppressAccessChecks");

    private <K, L, V> void addToCompoundMap(Map<K, Map<L, V>> source, Map<K, Map<L, V>> dest) {
        for (Map.Entry<K, Map<L, V>> entry : source.entrySet()) {
            Map<L, V> dmap = dest.get(entry.getKey());
            if (dmap == null) {
                dmap = new HashMap<L, V>();
                dest.put(entry.getKey(), dmap);
            }
            dmap.putAll(entry.getValue());
        }
    }

    public MBeanSkeleton(EvaluatedClassDeclaration annotatedClass, EvaluatedClassAnalyzer ca, ManagedObjectManagerInternal mom) {
        boolean isDefaultAMXMetadata = false;
        this.mbeanType = mom.getFirstAnnotationOnClass(annotatedClass, AMXMetadata.class);
        if (this.mbeanType == null) {
            isDefaultAMXMetadata = true;
            this.mbeanType = mom.getDefaultAMXMetadata();
        }
        this.type = mom.getTypeName(annotatedClass.cls(), "AMX_TYPE", this.mbeanType.type());
        Descriptor ldesc = DescriptorIntrospector.descriptorForElement(mom, annotatedClass.cls());
        if (isDefaultAMXMetadata) {
            ldesc = DescriptorUtility.union(DEFAULT_AMX_DESCRIPTOR, ldesc);
        }
        this.descriptor = this.makeValidDescriptor(ldesc, DescriptorType.mbean, this.type);
        this.sequenceNumber = new AtomicLong();
        this.mom = mom;
        this.setters = new HashMap<String, AttributeDescriptor>();
        this.getters = new HashMap<String, AttributeDescriptor>();
        this.operations = new HashMap<String, Map<List<String>, Operation>>();
        this.mbeanAttributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this.mbeanOperationInfoList = new ArrayList<ModelMBeanOperationInfo>();
        this.analyzeAttributes(ca);
        this.analyzeOperations(ca);
        this.analyzeObjectNameKeys(ca);
        this.mbInfo = this.makeMbInfo(mom.getDescription(annotatedClass));
    }

    private MBeanSkeleton(MBeanSkeleton first, MBeanSkeleton second) {
        this.mbeanType = second.mbeanType;
        this.type = second.type;
        this.descriptor = DescriptorUtility.union(first.descriptor, second.descriptor);
        this.sequenceNumber = new AtomicLong();
        this.mom = second.mom;
        this.setters = new HashMap<String, AttributeDescriptor>();
        this.setters.putAll(first.setters);
        this.setters.putAll(second.setters);
        this.getters = new HashMap<String, AttributeDescriptor>();
        this.getters.putAll(first.getters);
        this.getters.putAll(second.getters);
        this.nameAttributeDescriptor = second.nameAttributeDescriptor;
        this.operations = new HashMap<String, Map<List<String>, Operation>>();
        this.addToCompoundMap(first.operations, this.operations);
        this.addToCompoundMap(second.operations, this.operations);
        this.mbeanAttributeInfoList = new ArrayList<ModelMBeanAttributeInfo>();
        this.mbeanAttributeInfoList.addAll(first.mbeanAttributeInfoList);
        this.mbeanAttributeInfoList.addAll(second.mbeanAttributeInfoList);
        this.mbeanOperationInfoList = new ArrayList<ModelMBeanOperationInfo>();
        this.mbeanOperationInfoList.addAll(first.mbeanOperationInfoList);
        this.mbeanOperationInfoList.addAll(second.mbeanOperationInfoList);
        this.mbInfo = this.makeMbInfo(second.mbInfo.getDescription());
    }

    private ModelMBeanInfoSupport makeMbInfo(String description) {
        ModelMBeanAttributeInfo[] attrInfos = this.mbeanAttributeInfoList.toArray(new ModelMBeanAttributeInfo[this.mbeanAttributeInfoList.size()]);
        ModelMBeanOperationInfo[] operInfos = this.mbeanOperationInfoList.toArray(new ModelMBeanOperationInfo[this.mbeanOperationInfoList.size()]);
        return new ModelMBeanInfoSupport(this.type, description, attrInfos, null, operInfos, null, this.descriptor);
    }

    public MBeanSkeleton compose(MBeanSkeleton skel) {
        return new MBeanSkeleton(this, skel);
    }

    Descriptor makeValidDescriptor(Descriptor desc, DescriptorType dtype, String dname) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] names = desc.getFieldNames();
        Object[] values = desc.getFieldValues(null);
        for (int ctr = 0; ctr < names.length; ++ctr) {
            map.put(names[ctr], values[ctr]);
        }
        map.put("descriptorType", dtype.toString());
        if (dtype == DescriptorType.operation) {
            map.put("role", "operation");
            map.put("targetType", "ObjectReference");
        } else if (dtype == DescriptorType.mbean) {
            map.put("persistPolicy", "never");
            map.put("log", "F");
            map.put("visibility", "1");
        }
        map.put("name", dname);
        map.put("displayName", dname);
        return DescriptorUtility.makeDescriptor(map);
    }

    public String toString() {
        return "DynamicMBeanSkeleton[type" + this.type + "]";
    }

    @InfoMethod
    private void descriptorContents(String name2, String description, Descriptor desc) {
    }

    @InfoMethod
    private void attributeInfoContents(ModelMBeanAttributeInfo info) {
    }

    @TraceRegistrationFine
    private void processAttribute(AttributeDescriptor getter, AttributeDescriptor setter) {
        if (setter == null && getter == null) {
            throw Exceptions.self.notBothNull();
        }
        if (setter != null && getter != null && !setter.type().equals(getter.type())) {
            throw Exceptions.self.typesMustMatch();
        }
        AttributeDescriptor nonNullDescriptor = getter != null ? getter : setter;
        String name2 = nonNullDescriptor.id();
        String description = nonNullDescriptor.description();
        Descriptor desc = DescriptorUtility.EMPTY_DESCRIPTOR;
        if (getter != null) {
            desc = DescriptorUtility.union(desc, DescriptorIntrospector.descriptorForElement(this.mom, getter.accessible()));
        }
        if (setter != null) {
            desc = DescriptorUtility.union(desc, DescriptorIntrospector.descriptorForElement(this.mom, setter.accessible()));
        }
        desc = this.makeValidDescriptor(desc, DescriptorType.attribute, name2);
        this.descriptorContents(name2, description, desc);
        TypeConverter tc = this.mom.getTypeConverter(nonNullDescriptor.type());
        ModelMBeanAttributeInfo ainfo = new ModelMBeanAttributeInfo(name2, tc.getManagedType().getClassName(), description, getter != null, setter != null, false, desc);
        this.attributeInfoContents(ainfo);
        this.mbeanAttributeInfoList.add(ainfo);
    }

    @InfoMethod
    private void attributes(Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> amap) {
    }

    @InfoMethod
    private void setterNames(String msg, Set<String> names) {
    }

    @TraceRegistrationFine
    private void analyzeAttributes(EvaluatedClassAnalyzer ca) {
        Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> amap = this.mom.getAttributes(ca, ManagedObjectManagerInternal.AttributeDescriptorType.MBEAN_ATTR);
        this.getters.putAll(amap.first());
        this.setters.putAll(amap.second());
        this.attributes(amap);
        HashSet<String> setterNames = new HashSet<String>(this.setters.keySet());
        this.setterNames("before removing getters", setterNames);
        for (String str : this.getters.keySet()) {
            this.processAttribute(this.getters.get(str), this.setters.get(str));
            setterNames.remove(str);
        }
        this.setterNames("after removing getters", setterNames);
        for (String str : setterNames) {
            this.processAttribute(null, this.setters.get(str));
        }
    }

    @InfoMethod
    private void annotatedMethod(EvaluatedMethodDeclaration annotatedMethod) {
    }

    @TraceRegistrationFine
    private void analyzeObjectNameKeys(EvaluatedClassAnalyzer ca) {
        List<EvaluatedFieldDeclaration> annotatedFields = ca.findFields(this.mom.forAnnotation(NameValue.class, EvaluatedFieldDeclaration.class));
        List<EvaluatedMethodDeclaration> annotatedMethods = ca.findMethods(this.mom.forAnnotation(NameValue.class, EvaluatedMethodDeclaration.class));
        if (annotatedMethods.size() == 0 && annotatedFields.size() == 0) {
            return;
        }
        EvaluatedMethodDeclaration annotatedMethod = annotatedMethods.get(0);
        if (annotatedMethods.size() > 1) {
            EvaluatedMethodDeclaration second = annotatedMethods.get(1);
            if (annotatedMethod.containingClass().equals(second.containingClass())) {
                throw Exceptions.self.duplicateObjectNameKeyAttributes(annotatedMethod, second, annotatedMethod.containingClass().name());
            }
        }
        this.annotatedMethod(annotatedMethod);
        this.nameAttributeDescriptor = AttributeDescriptor.makeFromAnnotated(this.mom, annotatedMethod, "NameValue", Exceptions.self.nameOfManagedObject(), ManagedObjectManagerInternal.AttributeDescriptorType.MBEAN_ATTR);
    }

    @InfoMethod
    private void describe(String msg, Object data) {
    }

    @TraceRegistrationFine
    private Pair<Operation, ModelMBeanOperationInfo> makeOperation(final EvaluatedMethodDeclaration m) {
        AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                m.method().setAccessible(true);
                return m.method();
            }
        });
        String desc = this.mom.getDescription(m);
        EvaluatedType rtype = m.returnType();
        final TypeConverter rtc = rtype == null ? null : this.mom.getTypeConverter(rtype);
        List<EvaluatedType> atypes = m.parameterTypes();
        final ArrayList<TypeConverter> atcs = new ArrayList<TypeConverter>();
        ManagedOperation mo = this.mom.getAnnotation(m.element(), ManagedOperation.class);
        Descriptor modelDescriptor = this.makeValidDescriptor(DescriptorIntrospector.descriptorForElement(this.mom, m.element()), DescriptorType.operation, m.name());
        for (EvaluatedType ltype : atypes) {
            atcs.add(this.mom.getTypeConverter(ltype));
        }
        this.describe("desc", desc);
        this.describe("rtype", rtype);
        this.describe("rtc", rtc);
        this.describe("atcs", atcs);
        this.describe("atypes", atypes);
        this.describe("descriptor", this.descriptor);
        Operation oper = new Operation(){

            @Override
            @TraceRuntime
            public Object evaluate(FacetAccessor target, List<Object> args) {
                Object[] margs = new Object[args.size()];
                Iterator<Object> argsIterator = args.iterator();
                Iterator tcIterator = atcs.iterator();
                int ctr = 0;
                while (argsIterator.hasNext() && tcIterator.hasNext()) {
                    Object arg = argsIterator.next();
                    TypeConverter tc = (TypeConverter)tcIterator.next();
                    margs[ctr++] = tc.fromManagedEntity(arg);
                }
                MBeanSkeleton.this.describe("margs before invoke", margs);
                Object result = target.invoke(m.method(), margs);
                MBeanSkeleton.this.describe("result after invoke", result);
                if (rtc == null) {
                    return null;
                }
                return rtc.toManagedEntity(result);
            }
        };
        ParameterNames pna = this.mom.getAnnotation(m.element(), ParameterNames.class);
        this.describe("pna", pna);
        if (pna != null && pna.value().length != atcs.size()) {
            throw Exceptions.self.parameterNamesLengthBad();
        }
        MBeanParameterInfo[] paramInfo = new OpenMBeanParameterInfoSupport[atcs.size()];
        int ctr = 0;
        for (TypeConverter tc : atcs) {
            String name2 = "";
            try {
                name2 = pna == null ? "arg" + ctr : pna.value()[ctr];
                paramInfo[ctr] = new OpenMBeanParameterInfoSupport(name2, Exceptions.self.noDescriptionAvailable(), tc.getManagedType());
                ++ctr;
            }
            catch (IllegalArgumentException ex) {
                Exceptions.self.excInOpenParameterInfo(ex, name2, m);
            }
        }
        ModelMBeanOperationInfo operInfo = new ModelMBeanOperationInfo(m.name(), desc, paramInfo, rtc.getManagedType().getClassName(), mo.impact().ordinal(), modelDescriptor);
        this.describe("operInfo", operInfo);
        return new Pair<Operation, ModelMBeanOperationInfo>(oper, operInfo);
    }

    @TraceRegistrationFine
    private void analyzeOperations(EvaluatedClassAnalyzer ca) {
        List<EvaluatedMethodDeclaration> ops = ca.findMethods(this.mom.forAnnotation(ManagedOperation.class, EvaluatedMethodDeclaration.class));
        for (EvaluatedMethodDeclaration m : ops) {
            Pair<Operation, ModelMBeanOperationInfo> data = this.makeOperation(m);
            ModelMBeanOperationInfo info = data.second();
            ArrayList<String> dataTypes = new ArrayList<String>();
            for (MBeanParameterInfo pi : info.getSignature()) {
                dataTypes.add(pi.getType());
            }
            Map<List<String>, Operation> map = this.operations.get(m.name());
            if (map == null) {
                map = new HashMap<List<String>, Operation>();
                this.operations.put(m.name(), map);
            }
            this.mom.putIfNotPresent(map, dataTypes, data.first());
            this.mbeanOperationInfoList.add(info);
        }
    }

    public String getType() {
        return this.type;
    }

    public AMXMetadata getMBeanType() {
        return this.mbeanType;
    }

    @TraceRuntime
    public Object getAttribute(FacetAccessor fa, String name2) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeDescriptor getter = this.getters.get(name2);
        if (getter == null) {
            throw Exceptions.self.couldNotFindAttribute(name2);
        }
        Object result = getter.get(fa);
        return result;
    }

    @TraceRuntime
    public void setAttribute(NotificationBroadcasterSupport emitter, FacetAccessor fa, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String name2 = attribute.getName();
        Object value = attribute.getValue();
        AttributeDescriptor getter = this.getters.get(name2);
        Object oldValue = getter == null ? null : getter.get(fa);
        this.describe("oldValue", oldValue);
        AttributeDescriptor setter = this.setters.get(name2);
        if (setter == null) {
            throw Exceptions.self.couldNotFindWritableAttribute(name2);
        }
        setter.set(fa, value);
        AttributeChangeNotification notification = new AttributeChangeNotification(emitter, this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), "Changed attribute " + name2, name2, setter.tc().getManagedType().getClassName(), oldValue, value);
        this.describe("sending notification", notification);
        emitter.sendNotification(notification);
    }

    @TraceRuntime
    public AttributeList getAttributes(FacetAccessor fa, String[] attributes) {
        AttributeList result = new AttributeList();
        for (String str : attributes) {
            Object value = null;
            try {
                value = this.getAttribute(fa, str);
            }
            catch (JMException ex) {
                Exceptions.self.attributeGettingError(ex, str);
            }
            if (value == null) continue;
            Attribute attr = new Attribute(str, value);
            result.add(attr);
        }
        return result;
    }

    @TraceRuntime
    public AttributeList setAttributes(NotificationBroadcasterSupport emitter, FacetAccessor fa, AttributeList attributes) {
        AttributeList result = new AttributeList();
        for (Object elem : attributes) {
            Attribute attr = (Attribute)elem;
            try {
                this.setAttribute(emitter, fa, attr);
                result.add(attr);
            }
            catch (JMException ex) {
                Exceptions.self.attributeSettingError(ex, attr.getName());
            }
        }
        return result;
    }

    @TraceRuntime
    public Object invoke(FacetAccessor fa, String actionName, Object[] params, String[] sig) throws MBeanException, ReflectionException {
        List<String> signature = Arrays.asList(sig);
        List<Object> parameters = Arrays.asList(params);
        Map<List<String>, Operation> opMap = this.operations.get(actionName);
        if (opMap == null) {
            throw Exceptions.self.couldNotFindOperation(actionName);
        }
        Operation op = opMap.get(signature);
        if (op == null) {
            throw Exceptions.self.couldNotFindOperationAndSignature(actionName, signature);
        }
        Object result = op.evaluate(fa, parameters);
        return result;
    }

    @InfoMethod
    private void nameAttributeDescriptorIsNull() {
    }

    @TraceRuntime
    public String getNameValue(FacetAccessor fa) throws MBeanException, ReflectionException {
        String value = null;
        if (this.nameAttributeDescriptor == null) {
            this.nameAttributeDescriptorIsNull();
        } else {
            value = this.nameAttributeDescriptor.get(fa).toString();
        }
        return value;
    }

    public ModelMBeanInfoSupport getMBeanInfo() {
        return this.mbInfo;
    }

    public ManagedObjectManagerInternal mom() {
        return this.mom;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DescriptorType {
        mbean,
        attribute,
        operation;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @TraceRuntime
    public static interface Operation
    extends BinaryFunction<FacetAccessor, List<Object>, Object> {
    }
}

