/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.NamedThreadLocal;

public class SimpleThreadScope
implements Scope {
    private static final Log logger = LogFactory.getLog(SimpleThreadScope.class);
    private final ThreadLocal<Map<String, Object>> threadScope = new NamedThreadLocal<Map<String, Object>>("SimpleThreadScope"){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public Object get(String name2, ObjectFactory objectFactory) {
        Map<String, Object> scope = this.threadScope.get();
        Object object = scope.get(name2);
        if (object == null) {
            object = objectFactory.getObject();
            scope.put(name2, object);
        }
        return object;
    }

    public Object remove(String name2) {
        Map<String, Object> scope = this.threadScope.get();
        return scope.remove(name2);
    }

    public void registerDestructionCallback(String name2, Runnable callback) {
        logger.warn("SimpleThreadScope does not support descruction callbacks. Consider using a RequestScope in a Web environment.");
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return Thread.currentThread().getName();
    }
}

