/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="date", aliases={"java.sql.Types.DATE", "java.sql.Date"}, minParameters=0, maxParameters=0, priority=1)
public class DateType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof MSSQLDatabase) {
            try {
                if (database.getDatabaseMajorVersion() <= 9) {
                    return new DatabaseDataType("SMALLDATETIME");
                }
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return new DatabaseDataType(this.getName());
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return ((DatabaseFunction)value).getValue();
        }
        if (value.toString().equals("CURRENT_TIMESTAMP()")) {
            return database.getCurrentDateTimeFunction();
        }
        if (value instanceof Timestamp) {
            return database.getDateLiteral((Timestamp)value);
        }
        if (value instanceof java.sql.Date) {
            return database.getDateLiteral((java.sql.Date)value);
        }
        if (value instanceof Time) {
            return database.getDateLiteral((Time)value);
        }
        if (value instanceof Date) {
            return database.getDateLiteral((Date)value);
        }
        return "'" + ((String)value).replaceAll("'", "''") + "'";
    }

    @Override
    public Object sqlToObject(String value, Database database) {
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"DATE\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^DATE\\('", "").replaceFirst("'\\)", "");
        }
        return super.sqlToObject(value, database);
    }
}

