/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import com.google.common.base.Charsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_PGET
extends FsInode {
    private static final String NEWLINE = "\n\r";
    private final Map<String, String> _metadata = new HashMap<String, String>();
    private String _name;

    public FsInode_PGET(FileSystemProvider fs, String id, String[] args) {
        super(fs, id, FsInodeType.PGET);
        if (args.length > 0) {
            this._name = args[0];
            for (int i = 1; i < args.length; ++i) {
                this._metadata.put(args[i], null);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FsInode_PGET)) {
            return false;
        }
        FsInode_PGET other = (FsInode_PGET)o;
        if (this._name != null && !this._name.equals(other._name)) {
            return false;
        }
        return super.equals(o) && Arrays.equals(this._metadata.keySet().toArray(), other._metadata.keySet().toArray());
    }

    public synchronized String getMetadataFor(String name2) {
        return this._metadata.get(name2);
    }

    public String getName() {
        return this._name;
    }

    public synchronized boolean hasMetadataFor(String name2) {
        return this._metadata.containsKey(name2);
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        byte[] b = this.metadata().getBytes();
        if (pos > (long)b.length) {
            return 0;
        }
        int copyLen = Math.min(len, b.length - (int)pos);
        System.arraycopy(b, (int)pos, data, 0, copyLen);
        return copyLen;
    }

    public synchronized void setMetadata(String name2, String value) {
        this._metadata.put(name2, value);
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = super.stat();
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        ret.setSize(this.metadata().length());
        ret.setMTime(System.currentTimeMillis());
        return ret;
    }

    @Override
    public byte[] getIdentifier() {
        StringBuilder sb = new StringBuilder();
        if (this._name != null) {
            sb.append(this._name).append(':');
        }
        for (String arg : this._metadata.keySet()) {
            sb.append(arg).append(':');
        }
        return this.byteBase(sb.toString().getBytes(Charsets.UTF_8));
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    private synchronized String metadata() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this._metadata.entrySet()) {
            builder.append(entry.getKey()).append("=").append(entry.getValue()).append(NEWLINE);
        }
        return builder.toString();
    }
}

