/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.store;

public final class AccessLatency {
    private final String _name;
    private final int _id;
    public static final AccessLatency ONLINE = new AccessLatency("ONLINE", 1);
    public static final AccessLatency NEARLINE = new AccessLatency("NEARLINE", 0);

    private AccessLatency(String name2, int id) {
        this._name = name2;
        this._id = id;
    }

    public static AccessLatency[] getAllLatencies() {
        return new AccessLatency[]{ONLINE, NEARLINE};
    }

    public String toString() {
        return this._name;
    }

    public int getId() {
        return this._id;
    }

    public static AccessLatency valueOf(String state) throws IllegalArgumentException {
        if (state == null || state.equalsIgnoreCase("null")) {
            throw new NullPointerException(" null state ");
        }
        if (AccessLatency.ONLINE._name.equalsIgnoreCase(state)) {
            return ONLINE;
        }
        if (AccessLatency.NEARLINE._name.equalsIgnoreCase(state)) {
            return NEARLINE;
        }
        try {
            int id = Integer.parseInt(state);
            return AccessLatency.valueOf(id);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown AccessLatency");
        }
    }

    public static AccessLatency valueOf(int id) throws IllegalArgumentException {
        if (AccessLatency.ONLINE._id == id) {
            return ONLINE;
        }
        if (AccessLatency.NEARLINE._id == id) {
            return NEARLINE;
        }
        throw new IllegalArgumentException("Unknown State Id");
    }

    public boolean equals(Object obj) {
        return obj instanceof AccessLatency && ((AccessLatency)obj).getId() == this.getId();
    }

    public int hashCode() {
        return this._id;
    }
}

