/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.util;

import org.dcache.chimera.util.CacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryListCache<K, E> {
    private final CacheMap<K, E> _cache = new CacheMap();
    private static final Logger _log = LoggerFactory.getLogger(DirectoryListCache.class);

    public void add(K key, E list) {
        this.add(key, list, 0L);
    }

    public void add(K key, E list, long timeout) {
        try {
            this._cache.put(key, list, timeout == 0L ? 10L : timeout);
        }
        catch (OutOfMemoryError oops) {
            this._cache.clear();
            _log.error("DirectoryCacheList: Out of memory !");
        }
    }

    public E get(K key) {
        return this._cache.get(key);
    }

    public void remove(K key) {
        this._cache.remove(key);
    }
}

