/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs;

import com.google.common.base.Splitter;
import java.net.InetAddress;
import org.dcache.nfs.IPMatcher;

public class FsExport {
    public static final int DEFAULT_ANON_UID = 65534;
    public static final int DEFAULT_ANON_GID = 65534;
    private final String _path;
    private final String _client;
    private final Root _isTrusted;
    private final IO _rw;
    private final boolean _withAcl;
    private final Sec _sec;
    private final boolean _allSquash;
    private final int _anonUid;
    private final int _anonGid;

    private FsExport(String path, FsExportBuilder builder) {
        this._path = path;
        this._client = builder.getClient();
        this._isTrusted = builder.getIsTrusted();
        this._rw = builder.getIo();
        this._withAcl = builder.isWithAcl();
        this._sec = builder.getSec();
        this._allSquash = builder.hasAllSquash();
        this._anonUid = builder.getAnonUid();
        this._anonGid = builder.getAnonGid();
    }

    public String getPath() {
        return this._path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._path).append(':').append(' ').append(this._client).append('(').append((Object)this._rw).append(',').append(this._isTrusted == Root.TRUSTED ? "no_root_squash" : "root_squash").append(',').append(this._withAcl ? "acl" : "noacl").append(',').append("sec=").append((Object)this._sec);
        if (this._allSquash) {
            sb.append(",all_squash");
        }
        sb.append(',').append("anonuid=").append(this._anonUid);
        sb.append(',').append("anongid=").append(this._anonGid);
        sb.append(')').append(':').append("idx=").append(Integer.toHexString(this.getIndex()));
        return sb.toString();
    }

    public boolean isAllowed(InetAddress client) {
        return client.isLoopbackAddress() || IPMatcher.match(this._client, client);
    }

    public boolean isTrusted(InetAddress client) {
        return this.isAllowed(client) && this._isTrusted == Root.TRUSTED;
    }

    public boolean isTrusted() {
        return this._isTrusted == Root.TRUSTED;
    }

    public String client() {
        return this._client;
    }

    public IO ioMode() {
        return this._rw;
    }

    public int getIndex() {
        int index = 1;
        for (String s : Splitter.on('/').omitEmptyStrings().split(this._path)) {
            index = 31 * index + s.hashCode();
        }
        return index;
    }

    public boolean checkAcls() {
        return this._withAcl;
    }

    public Sec getSec() {
        return this._sec;
    }

    public boolean hasAllSquash() {
        return this._allSquash;
    }

    public int getAnonUid() {
        return this._anonUid;
    }

    public int getAnonGid() {
        return this._anonGid;
    }

    public static class FsExportBuilder {
        private String _client = "*";
        private IO _io = IO.RO;
        private Root _isTrusted = Root.NOTTRUSTED;
        private boolean _withAcl = false;
        private Sec _sec = Sec.SYS;
        private boolean allSquash = false;
        private int _anonUid = 65534;
        private int _anonGid = 65534;

        public FsExportBuilder forClient(String client) {
            this._client = client;
            return this;
        }

        public FsExportBuilder trusted() {
            this._isTrusted = Root.TRUSTED;
            return this;
        }

        public FsExportBuilder notTrusted() {
            this._isTrusted = Root.NOTTRUSTED;
            return this;
        }

        public FsExportBuilder ro() {
            this._io = IO.RO;
            return this;
        }

        public FsExportBuilder rw() {
            this._io = IO.RW;
            return this;
        }

        public FsExportBuilder withAcl() {
            this._withAcl = true;
            return this;
        }

        public FsExportBuilder withoutAcl() {
            this._withAcl = false;
            return this;
        }

        public FsExportBuilder withSec(Sec sec) {
            this._sec = sec;
            return this;
        }

        public FsExportBuilder withAnonUid(int id) {
            this._anonUid = id;
            return this;
        }

        public FsExportBuilder withAnonGid(int id) {
            this._anonGid = id;
            return this;
        }

        public FsExportBuilder allSquash() {
            this.allSquash = true;
            return this;
        }

        public String getClient() {
            return this._client;
        }

        public IO getIo() {
            return this._io;
        }

        public Root getIsTrusted() {
            return this._isTrusted;
        }

        public boolean isWithAcl() {
            return this._withAcl;
        }

        public Sec getSec() {
            return this._sec;
        }

        public boolean hasAllSquash() {
            return this.allSquash;
        }

        public int getAnonUid() {
            return this._anonUid;
        }

        public int getAnonGid() {
            return this._anonGid;
        }

        public FsExport build(String path) {
            return new FsExport(path, this);
        }
    }

    public static enum Sec {
        NONE,
        SYS,
        KRB5,
        KRB5I,
        KRB5P;

    }

    public static enum IO {
        RW,
        RO;

    }

    public static enum Root {
        TRUSTED,
        NOTTRUSTED;

    }
}

