/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcache.commons.stats.RequestExecutionTimeGauges;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NFS4Client;
import org.dcache.nfs.v4.NFSv41DeviceManager;
import org.dcache.nfs.v4.NFSv4OperationFactory;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.xdr.COMPOUND4args;
import org.dcache.nfs.v4.xdr.COMPOUND4res;
import org.dcache.nfs.v4.xdr.nfs4_prot_NFS4_PROGRAM_ServerStub;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_opnum4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.PseudoFs;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NFSServerV41
extends nfs4_prot_NFS4_PROGRAM_ServerStub {
    private final VirtualFileSystem _fs;
    private final ExportFile _exportFile;
    private static final Logger _log = LoggerFactory.getLogger(NFSServerV41.class);
    private final NFSv4OperationFactory _operationFactory;
    private final NFSv41DeviceManager _deviceManager;
    private final NFSv4StateHandler _statHandler = new NFSv4StateHandler();
    private final NfsIdMapping _idMapping;
    private static final RequestExecutionTimeGauges<String> GAUGES = new RequestExecutionTimeGauges(NFSServerV41.class.getName());

    public NFSServerV41(NFSv4OperationFactory operationFactory, NFSv41DeviceManager deviceManager, VirtualFileSystem fs, NfsIdMapping idMapping, ExportFile exportFile) throws OncRpcException, IOException {
        this._deviceManager = deviceManager;
        this._fs = fs;
        this._exportFile = exportFile;
        this._operationFactory = operationFactory;
        this._idMapping = idMapping;
    }

    @Override
    public void NFSPROC4_NULL_4(RpcCall call$) {
        _log.debug("NFS PING client: {}", (Object)call$.getTransport().getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public COMPOUND4res NFSPROC4_COMPOUND_4(RpcCall call$, COMPOUND4args arg1) {
        COMPOUND4res res = new COMPOUND4res();
        try {
            String tag = arg1.tag.toString();
            MDC.put("mdc.tag", tag);
            MDC.put("mdc.client", call$.getTransport().getRemoteSocketAddress().toString());
            _log.debug("NFS COMPOUND client: {}, tag: [{}]", (Object)call$.getTransport().getRemoteSocketAddress(), (Object)tag);
            int minorversion = arg1.minorversion.value;
            if (minorversion > 1) {
                throw new ChimeraNFSException(10021, String.format("Unsupported minor version [%d]", arg1.minorversion.value));
            }
            PseudoFs fs = new PseudoFs(this._fs, call$, this._exportFile);
            CompoundContext context = new CompoundContext(arg1.minorversion.value, fs, this._statHandler, this._deviceManager, call$, this._idMapping, this._exportFile, arg1.argarray.length);
            res.status = 0;
            res.resarray = new ArrayList<nfs_resop4>(arg1.argarray.length);
            res.tag = arg1.tag;
            boolean retransmit = false;
            for (nfs_argop4 op : arg1.argarray) {
                context.nextOperation();
                int position = context.getOperationPosition();
                nfs_resop4 opResult = nfs_resop4.resopFor(op.argop);
                try {
                    if (minorversion != 0) {
                        List<nfs_resop4> cache;
                        NFSServerV41.checkOpPosition(op.argop, position);
                        if (position == 1 && (cache = context.getCache()) != null) {
                            res.resarray.addAll(cache.subList(position, cache.size()));
                            res.status = NFSServerV41.statusOfLastOperation(cache);
                            retransmit = true;
                            break;
                        }
                    }
                    long t0 = System.nanoTime();
                    this._operationFactory.getOperation(op).process(context, opResult);
                    GAUGES.update(nfs_opnum4.toString(op.argop), System.nanoTime() - t0);
                }
                catch (ChimeraNFSException e) {
                    opResult.setStatus(e.getStatus());
                }
                catch (OncRpcException e) {
                    opResult.setStatus(10036);
                    _log.warn("Bad xdr: {}: ", (Object)e.getMessage());
                }
                catch (IOException e) {
                    opResult.setStatus(5);
                    _log.warn("IO error: {}", (Object)e.getMessage());
                }
                catch (Throwable e) {
                    opResult.setStatus(10006);
                    _log.error("General error: ", e);
                }
                res.resarray.add(opResult);
                res.status = opResult.getStatus();
                if (res.status != 0) break;
            }
            if (!retransmit && context.cacheThis()) {
                context.getSession().updateSlotCache(context.getSlotId(), res.resarray);
            }
            _log.debug("OP: [{}] status: {}", (Object)res.tag, (Object)res.status);
        }
        catch (ChimeraNFSException e) {
            _log.info("NFS operation failed: {}", (Object)e.getMessage());
            res.resarray = Collections.EMPTY_LIST;
            res.status = e.getStatus();
            res.tag = arg1.tag;
        }
        catch (Exception e) {
            _log.error("Unhandled exception:", e);
            res.resarray = Collections.EMPTY_LIST;
            res.status = 10006;
            res.tag = arg1.tag;
        }
        finally {
            MDC.remove("mdc.tag");
            MDC.remove("mdc.client");
            MDC.remove("mdc.session");
        }
        return res;
    }

    public List<NFS4Client> getClients() {
        return this._statHandler.getClients();
    }

    private static void checkOpPosition(int opCode, int position) throws ChimeraNFSException {
        block8: {
            block7: {
                if (opCode > 58 || opCode < 3) {
                    return;
                }
                if (position != 0) break block7;
                switch (opCode) {
                    case 42: 
                    case 43: 
                    case 44: 
                    case 53: 
                    case 57: {
                        break block8;
                    }
                    default: {
                        throw new ChimeraNFSException(10071, "not in session");
                    }
                }
            }
            switch (opCode) {
                case 53: {
                    throw new ChimeraNFSException(10064, "not a first operation");
                }
            }
        }
    }

    private static int statusOfLastOperation(List<nfs_resop4> ops) {
        return ops.get(ops.size() - 1).getStatus();
    }

    public RequestExecutionTimeGauges<String> getStatistics() {
        return GAUGES;
    }
}

