/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.xdr.GETATTR4res;
import org.dcache.nfs.v4.xdr.GETATTR4resok;
import org.dcache.nfs.v4.xdr.attrlist4;
import org.dcache.nfs.v4.xdr.bitmap4;
import org.dcache.nfs.v4.xdr.changeid4;
import org.dcache.nfs.v4.xdr.fattr4;
import org.dcache.nfs.v4.xdr.fattr4_acl;
import org.dcache.nfs.v4.xdr.fattr4_aclsupport;
import org.dcache.nfs.v4.xdr.fattr4_cansettime;
import org.dcache.nfs.v4.xdr.fattr4_case_insensitive;
import org.dcache.nfs.v4.xdr.fattr4_case_preserving;
import org.dcache.nfs.v4.xdr.fattr4_change;
import org.dcache.nfs.v4.xdr.fattr4_fh_expire_type;
import org.dcache.nfs.v4.xdr.fattr4_filehandle;
import org.dcache.nfs.v4.xdr.fattr4_fileid;
import org.dcache.nfs.v4.xdr.fattr4_files_avail;
import org.dcache.nfs.v4.xdr.fattr4_files_free;
import org.dcache.nfs.v4.xdr.fattr4_files_total;
import org.dcache.nfs.v4.xdr.fattr4_fs_layout_types;
import org.dcache.nfs.v4.xdr.fattr4_fsid;
import org.dcache.nfs.v4.xdr.fattr4_hidden;
import org.dcache.nfs.v4.xdr.fattr4_homogeneous;
import org.dcache.nfs.v4.xdr.fattr4_lease_time;
import org.dcache.nfs.v4.xdr.fattr4_link_support;
import org.dcache.nfs.v4.xdr.fattr4_maxfilesize;
import org.dcache.nfs.v4.xdr.fattr4_maxlink;
import org.dcache.nfs.v4.xdr.fattr4_maxname;
import org.dcache.nfs.v4.xdr.fattr4_maxread;
import org.dcache.nfs.v4.xdr.fattr4_maxwrite;
import org.dcache.nfs.v4.xdr.fattr4_mode;
import org.dcache.nfs.v4.xdr.fattr4_mounted_on_fileid;
import org.dcache.nfs.v4.xdr.fattr4_named_attr;
import org.dcache.nfs.v4.xdr.fattr4_no_trunc;
import org.dcache.nfs.v4.xdr.fattr4_numlinks;
import org.dcache.nfs.v4.xdr.fattr4_owner;
import org.dcache.nfs.v4.xdr.fattr4_rawdev;
import org.dcache.nfs.v4.xdr.fattr4_rdattr_error;
import org.dcache.nfs.v4.xdr.fattr4_size;
import org.dcache.nfs.v4.xdr.fattr4_space_free;
import org.dcache.nfs.v4.xdr.fattr4_space_total;
import org.dcache.nfs.v4.xdr.fattr4_space_used;
import org.dcache.nfs.v4.xdr.fattr4_supported_attrs;
import org.dcache.nfs.v4.xdr.fattr4_symlink_support;
import org.dcache.nfs.v4.xdr.fattr4_system;
import org.dcache.nfs.v4.xdr.fattr4_time_access;
import org.dcache.nfs.v4.xdr.fattr4_time_create;
import org.dcache.nfs.v4.xdr.fattr4_time_metadata;
import org.dcache.nfs.v4.xdr.fattr4_time_modify;
import org.dcache.nfs.v4.xdr.fattr4_type;
import org.dcache.nfs.v4.xdr.fattr4_unique_handles;
import org.dcache.nfs.v4.xdr.fsid4;
import org.dcache.nfs.v4.xdr.int64_t;
import org.dcache.nfs.v4.xdr.mode4;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_fh4;
import org.dcache.nfs.v4.xdr.nfs_lease4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.nfstime4;
import org.dcache.nfs.v4.xdr.specdata4;
import org.dcache.nfs.v4.xdr.uint32_t;
import org.dcache.nfs.v4.xdr.uint64_t;
import org.dcache.nfs.v4.xdr.utf8str_mixed;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.XdrAble;
import org.dcache.xdr.XdrBuffer;
import org.glassfish.grizzly.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationGETATTR
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationGETATTR.class);

    public OperationGETATTR(nfs_argop4 args) {
        super(args, 9);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws IOException, OncRpcException {
        GETATTR4res res = result.opgetattr;
        res.resok4 = new GETATTR4resok();
        res.resok4.obj_attributes = OperationGETATTR.getAttributes(this._args.opgetattr.attr_request, context.getFs(), context.currentInode(), context);
        res.status = 0;
    }

    static fattr4 getAttributes(bitmap4 bitmap, VirtualFileSystem fs, Inode inode, Stat stat, CompoundContext context) throws IOException, OncRpcException {
        bitmap4 processedAttributes = new bitmap4(new uint32_t[0]);
        XdrBuffer xdr = new XdrBuffer(1024);
        xdr.beginEncoding();
        for (int i : bitmap) {
            Optional<? extends XdrAble> optionalAttr = OperationGETATTR.fattr2xdr(i, fs, inode, stat, context);
            if (optionalAttr.isPresent()) {
                XdrAble attr = optionalAttr.get();
                _log.debug("   getAttributes : {} ({}) OK.", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
                attr.xdrEncode(xdr);
                processedAttributes.set(i);
                continue;
            }
            _log.debug("   getAttributes : {} ({}) NOT SUPPORTED.", (Object)i, (Object)OperationGETATTR.attrMask2String(i));
        }
        xdr.endEncoding();
        Buffer body = xdr.asBuffer();
        byte[] retBytes = new byte[body.remaining()];
        body.get(retBytes);
        fattr4 attributes = new fattr4();
        attributes.attrmask = processedAttributes;
        attributes.attr_vals = new attrlist4(retBytes);
        return attributes;
    }

    static fattr4 getAttributes(bitmap4 bitmap, VirtualFileSystem fs, Inode inode, CompoundContext context) throws IOException, OncRpcException {
        return OperationGETATTR.getAttributes(bitmap, fs, inode, context.getFs().getattr(inode), context);
    }

    private static FsStat getFsStat(FsStat fsStat, VirtualFileSystem fs) throws IOException {
        if (fsStat != null) {
            return fsStat;
        }
        return fs.getFsStat();
    }

    private static Optional<? extends XdrAble> fattr2xdr(int fattr, VirtualFileSystem fs, Inode inode, Stat stat, CompoundContext context) throws IOException {
        FsStat fsStat = null;
        switch (fattr) {
            case 0: {
                bitmap4 bitmap = new bitmap4();
                bitmap.value = new uint32_t[2];
                bitmap.value[0] = new uint32_t(-50348033);
                bitmap.value[1] = new uint32_t(1090371134);
                return Optional.of(new fattr4_supported_attrs(bitmap));
            }
            case 1: {
                fattr4_type type = new fattr4_type(OperationGETATTR.unixType2NFS(stat.getMode()));
                return Optional.of(type);
            }
            case 2: {
                uint32_t fh_type = new uint32_t(0);
                fattr4_fh_expire_type fh_expire_type = new fattr4_fh_expire_type(fh_type);
                return Optional.of(fh_expire_type);
            }
            case 3: {
                changeid4 cid = new changeid4(new uint64_t(stat.getCTime()));
                fattr4_change change = new fattr4_change(cid);
                return Optional.of(change);
            }
            case 4: {
                fattr4_size size = new fattr4_size(new uint64_t(stat.getSize()));
                return Optional.of(size);
            }
            case 5: {
                fattr4_link_support link_support = new fattr4_link_support(true);
                return Optional.of(link_support);
            }
            case 6: {
                fattr4_symlink_support symlink_support = new fattr4_symlink_support(true);
                return Optional.of(symlink_support);
            }
            case 7: {
                fattr4_named_attr named_attr = new fattr4_named_attr(false);
                return Optional.of(named_attr);
            }
            case 8: {
                fsid4 fsid = new fsid4();
                fsid.major = new uint64_t(17L);
                fsid.minor = new uint64_t(17L);
                return Optional.of(new fattr4_fsid(fsid));
            }
            case 9: {
                return Optional.of(new fattr4_unique_handles(true));
            }
            case 10: {
                return Optional.of(new fattr4_lease_time(new nfs_lease4(new uint32_t(90))));
            }
            case 11: {
                return Optional.of(new fattr4_rdattr_error(0));
            }
            case 19: {
                nfs_fh4 fh = new nfs_fh4();
                fh.value = inode.toNfsHandle();
                return Optional.of(new fattr4_filehandle(fh));
            }
            case 12: {
                nfsace4[] aces = context.getFs().getAcl(inode);
                return Optional.of(new fattr4_acl(aces));
            }
            case 13: {
                fattr4_aclsupport aclSupport = new fattr4_aclsupport();
                aclSupport.value = new uint32_t();
                aclSupport.value.value = 3;
                return Optional.of(aclSupport);
            }
            case 14: {
                return Optional.absent();
            }
            case 15: {
                return Optional.of(new fattr4_cansettime(true));
            }
            case 16: {
                return Optional.of(new fattr4_case_insensitive(true));
            }
            case 17: {
                return Optional.of(new fattr4_case_preserving(true));
            }
            case 18: {
                return Optional.absent();
            }
            case 20: {
                return Optional.of(new fattr4_fileid(new uint64_t(stat.getFileId())));
            }
            case 21: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_files_avail files_avail = new fattr4_files_avail(new uint64_t(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
                return Optional.of(files_avail);
            }
            case 22: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_files_free files_free = new fattr4_files_free(new uint64_t(fsStat.getTotalFiles() - fsStat.getUsedFiles()));
                return Optional.of(files_free);
            }
            case 23: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                return Optional.of(new fattr4_files_total(new uint64_t(fsStat.getTotalFiles())));
            }
            case 24: {
                return Optional.absent();
            }
            case 25: {
                return Optional.of(new fattr4_hidden(false));
            }
            case 26: {
                return Optional.of(new fattr4_homogeneous(true));
            }
            case 27: {
                return Optional.of(new fattr4_maxfilesize(new uint64_t(Long.MAX_VALUE)));
            }
            case 28: {
                return Optional.of(new fattr4_maxlink(new uint32_t(255)));
            }
            case 29: {
                return Optional.of(new fattr4_maxname(new uint32_t(255)));
            }
            case 30: {
                return Optional.of(new fattr4_maxread(new uint64_t(0x400000L)));
            }
            case 31: {
                fattr4_maxwrite maxwrite = new fattr4_maxwrite(new uint64_t(0x400000L));
                return Optional.of(maxwrite);
            }
            case 32: {
                return Optional.absent();
            }
            case 33: {
                mode4 fmode = new mode4();
                fmode.value = new uint32_t(stat.getMode() & 0xFFF);
                return Optional.of(new fattr4_mode(fmode));
            }
            case 34: {
                return Optional.of(new fattr4_no_trunc(true));
            }
            case 35: {
                uint32_t nlinks = new uint32_t(stat.getNlink());
                return Optional.of(new fattr4_numlinks(nlinks));
            }
            case 36: {
                String owner_s = context.getIdMapping().uidToPrincipal(stat.getUid());
                utf8str_mixed user = new utf8str_mixed(owner_s);
                return Optional.of(new fattr4_owner(user));
            }
            case 37: {
                String group_s = context.getIdMapping().gidToPrincipal(stat.getGid());
                utf8str_mixed group = new utf8str_mixed(group_s);
                return Optional.of(new fattr4_owner(group));
            }
            case 38: {
                return Optional.absent();
            }
            case 39: {
                return Optional.absent();
            }
            case 40: {
                return Optional.absent();
            }
            case 41: {
                specdata4 dev = new specdata4();
                dev.specdata1 = new uint32_t(0);
                dev.specdata2 = new uint32_t(0);
                return Optional.of(new fattr4_rawdev(dev));
            }
            case 42: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                uint64_t spaceAvail = new uint64_t(fsStat.getTotalSpace() - fsStat.getUsedSpace());
                return Optional.of(spaceAvail);
            }
            case 43: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                fattr4_space_free space_free = new fattr4_space_free(new uint64_t(fsStat.getTotalSpace() - fsStat.getUsedSpace()));
                return Optional.of(space_free);
            }
            case 44: {
                fsStat = OperationGETATTR.getFsStat(fsStat, fs);
                return Optional.of(new fattr4_space_total(new uint64_t(fsStat.getTotalSpace())));
            }
            case 45: {
                return Optional.of(new fattr4_space_used(new uint64_t(stat.getSize())));
            }
            case 46: {
                return Optional.of(new fattr4_system(false));
            }
            case 47: {
                nfstime4 atime = new nfstime4();
                atime.seconds = new int64_t(TimeUnit.SECONDS.convert(stat.getATime(), TimeUnit.MILLISECONDS));
                atime.nseconds = new uint32_t(0);
                return Optional.of(new fattr4_time_access(atime));
            }
            case 49: {
                return Optional.absent();
            }
            case 50: {
                nfstime4 ctime = new nfstime4();
                ctime.seconds = new int64_t(TimeUnit.SECONDS.convert(stat.getCTime(), TimeUnit.MILLISECONDS));
                ctime.nseconds = new uint32_t(0);
                return Optional.of(new fattr4_time_create(ctime));
            }
            case 51: {
                return Optional.absent();
            }
            case 52: {
                nfstime4 mdtime = new nfstime4();
                mdtime.seconds = new int64_t(TimeUnit.SECONDS.convert(stat.getCTime(), TimeUnit.MILLISECONDS));
                mdtime.nseconds = new uint32_t(0);
                return Optional.of(new fattr4_time_metadata(mdtime));
            }
            case 53: {
                nfstime4 mtime = new nfstime4();
                mtime.seconds = new int64_t(TimeUnit.SECONDS.convert(stat.getMTime(), TimeUnit.MILLISECONDS));
                mtime.nseconds = new uint32_t(0);
                return Optional.of(new fattr4_time_modify(mtime));
            }
            case 55: {
                long mofi = stat.getFileId();
                if (mofi == 11575866L) {
                    mofi = 305419896L;
                }
                uint64_t rootid = new uint64_t(mofi);
                fattr4_mounted_on_fileid mounted_on_fileid = new fattr4_mounted_on_fileid(rootid);
                return Optional.of(mounted_on_fileid);
            }
            case 62: {
                fattr4_fs_layout_types fs_layout_type = new fattr4_fs_layout_types();
                fs_layout_type.value = new int[1];
                fs_layout_type.value[0] = 1;
                return Optional.of(fs_layout_type);
            }
            case 48: 
            case 54: {
                throw new ChimeraNFSException(22, "getattr of write-only attributes");
            }
        }
        _log.debug("GETATTR for #{}", (Object)fattr);
        return Optional.absent();
    }

    public static String attrMask2String(int offset) {
        String maskName = "Unknown";
        switch (offset) {
            case 0: {
                maskName = " FATTR4_SUPPORTED_ATTRS ";
                break;
            }
            case 1: {
                maskName = " FATTR4_TYPE ";
                break;
            }
            case 2: {
                maskName = " FATTR4_FH_EXPIRE_TYPE ";
                break;
            }
            case 3: {
                maskName = " FATTR4_CHANGE ";
                break;
            }
            case 4: {
                maskName = " FATTR4_SIZE ";
                break;
            }
            case 5: {
                maskName = " FATTR4_LINK_SUPPORT ";
                break;
            }
            case 6: {
                maskName = " FATTR4_SYMLINK_SUPPORT ";
                break;
            }
            case 7: {
                maskName = " FATTR4_NAMED_ATTR ";
                break;
            }
            case 8: {
                maskName = " FATTR4_FSID ";
                break;
            }
            case 9: {
                maskName = " FATTR4_UNIQUE_HANDLES ";
                break;
            }
            case 10: {
                maskName = " FATTR4_LEASE_TIME ";
                break;
            }
            case 11: {
                maskName = " FATTR4_RDATTR_ERROR ";
                break;
            }
            case 19: {
                maskName = " FATTR4_FILEHANDLE ";
                break;
            }
            case 12: {
                maskName = " FATTR4_ACL ";
                break;
            }
            case 13: {
                maskName = " FATTR4_ACLSUPPORT ";
                break;
            }
            case 14: {
                maskName = " FATTR4_ARCHIVE ";
                break;
            }
            case 15: {
                maskName = " FATTR4_CANSETTIME ";
                break;
            }
            case 16: {
                maskName = " FATTR4_CASE_INSENSITIVE ";
                break;
            }
            case 17: {
                maskName = " FATTR4_CASE_PRESERVING ";
                break;
            }
            case 18: {
                maskName = " FATTR4_CHOWN_RESTRICTED ";
                break;
            }
            case 20: {
                maskName = " FATTR4_FILEID ";
                break;
            }
            case 21: {
                maskName = " FATTR4_FILES_AVAIL ";
                break;
            }
            case 22: {
                maskName = " FATTR4_FILES_FREE ";
                break;
            }
            case 23: {
                maskName = " FATTR4_FILES_TOTAL ";
                break;
            }
            case 24: {
                maskName = " FATTR4_FS_LOCATIONS ";
                break;
            }
            case 25: {
                maskName = " FATTR4_HIDDEN ";
                break;
            }
            case 26: {
                maskName = " FATTR4_HOMOGENEOUS ";
                break;
            }
            case 27: {
                maskName = " FATTR4_MAXFILESIZE ";
                break;
            }
            case 28: {
                maskName = " FATTR4_MAXLINK ";
                break;
            }
            case 29: {
                maskName = " FATTR4_MAXNAME ";
                break;
            }
            case 30: {
                maskName = " FATTR4_MAXREAD ";
                break;
            }
            case 31: {
                maskName = " FATTR4_MAXWRITE ";
                break;
            }
            case 32: {
                maskName = " FATTR4_MIMETYPE ";
                break;
            }
            case 33: {
                maskName = " FATTR4_MODE ";
                break;
            }
            case 34: {
                maskName = " FATTR4_NO_TRUNC ";
                break;
            }
            case 35: {
                maskName = " FATTR4_NUMLINKS ";
                break;
            }
            case 36: {
                maskName = " FATTR4_OWNER ";
                break;
            }
            case 37: {
                maskName = " FATTR4_OWNER_GROUP ";
                break;
            }
            case 38: {
                maskName = " FATTR4_QUOTA_AVAIL_HARD ";
                break;
            }
            case 39: {
                maskName = " FATTR4_QUOTA_AVAIL_SOFT ";
                break;
            }
            case 40: {
                maskName = " FATTR4_QUOTA_USED ";
                break;
            }
            case 41: {
                maskName = " FATTR4_RAWDEV ";
                break;
            }
            case 42: {
                maskName = " FATTR4_SPACE_AVAIL ";
                break;
            }
            case 43: {
                maskName = " FATTR4_SPACE_FREE ";
                break;
            }
            case 44: {
                maskName = " FATTR4_SPACE_TOTAL ";
                break;
            }
            case 45: {
                maskName = " FATTR4_SPACE_USED ";
                break;
            }
            case 46: {
                maskName = " FATTR4_SYSTEM ";
                break;
            }
            case 47: {
                maskName = " FATTR4_TIME_ACCESS ";
                break;
            }
            case 48: {
                maskName = " FATTR4_TIME_ACCESS_SET ";
                break;
            }
            case 49: {
                maskName = " FATTR4_TIME_BACKUP ";
                break;
            }
            case 50: {
                maskName = " FATTR4_TIME_CREATE ";
                break;
            }
            case 51: {
                maskName = " FATTR4_TIME_DELTA ";
                break;
            }
            case 52: {
                maskName = " FATTR4_TIME_METADATA ";
                break;
            }
            case 53: {
                maskName = " FATTR4_TIME_MODIFY ";
                break;
            }
            case 54: {
                maskName = " FATTR4_TIME_MODIFY_SET ";
                break;
            }
            case 55: {
                maskName = " FATTR4_MOUNTED_ON_FILEID ";
                break;
            }
            case 62: {
                maskName = " FATTR4_FS_LAYOUT_TYPE ";
                break;
            }
            case 63: {
                maskName = " FATTR4_LAYOUT_HINT ";
                break;
            }
            case 64: {
                maskName = " FATTR4_LAYOUT_TYPE ";
                break;
            }
            case 65: {
                maskName = " FATTR4_LAYOUT_BLKSIZE ";
                break;
            }
            case 66: {
                maskName = " FATTR4_LAYOUT_ALIGNMENT ";
                break;
            }
            case 67: {
                maskName = " FATTR4_FS_LOCATIONS_INFO ";
                break;
            }
            case 68: {
                maskName = " FATTR4_MDSTHRESHOLD ";
                break;
            }
            case 69: {
                maskName = " FATTR4_RETENTION_GET ";
                break;
            }
            case 70: {
                maskName = " FATTR4_RETENTION_SET ";
                break;
            }
            case 71: {
                maskName = " FATTR4_RETENTEVT_GET ";
                break;
            }
            case 72: {
                maskName = " FATTR4_RETENTEVT_SET ";
                break;
            }
            case 73: {
                maskName = " FATTR4_RETENTION_HOLD ";
                break;
            }
            case 74: {
                maskName = " FATTR4_MODE_SET_MASKED ";
                break;
            }
            case 76: {
                maskName = " FATTR4_FS_CHARSET_CAP ";
                break;
            }
            default: {
                maskName = maskName + "(" + offset + ")";
            }
        }
        return maskName;
    }

    static int unixType2NFS(int type) {
        int ret = 0;
        int mask = 258048;
        switch (type & mask) {
            case 32768: {
                ret = 1;
                break;
            }
            case 16384: {
                ret = 2;
                break;
            }
            case 40960: {
                ret = 5;
                break;
            }
            case 49152: {
                ret = 6;
                break;
            }
            case 24576: {
                ret = 3;
                break;
            }
            case 8192: {
                ret = 4;
                break;
            }
            case 4096: {
                ret = 7;
                break;
            }
            default: {
                _log.info("Unknown mode [{}]", (Object)Integer.toOctalString(type));
                ret = 0;
            }
        }
        return ret;
    }
}

