/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.nfs.v4;

import java.io.IOException;
import org.dcache.nfs.ChimeraNFSException;
import org.dcache.nfs.v4.AbstractNFSv4Operation;
import org.dcache.nfs.v4.CompoundContext;
import org.dcache.nfs.v4.NameFilter;
import org.dcache.nfs.v4.xdr.LOOKUP4res;
import org.dcache.nfs.v4.xdr.nfs_argop4;
import org.dcache.nfs.v4.xdr.nfs_resop4;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLOOKUP
extends AbstractNFSv4Operation {
    private static final Logger _log = LoggerFactory.getLogger(OperationLOOKUP.class);

    OperationLOOKUP(nfs_argop4 args) {
        super(args, 15);
    }

    @Override
    public void process(CompoundContext context, nfs_resop4 result) throws ChimeraNFSException, IOException {
        LOOKUP4res res = result.oplookup;
        String name2 = NameFilter.convert(this._args.oplookup.objname.value.value.value);
        Stat stat = context.getFs().getattr(context.currentInode());
        if (stat.type() == Stat.Type.SYMLINK) {
            throw new ChimeraNFSException(10029, "parent not a symbolic link");
        }
        if (stat.type() != Stat.Type.DIRECTORY) {
            throw new ChimeraNFSException(20, "parent not a directory");
        }
        if (name2.length() < 1) {
            throw new ChimeraNFSException(22, "invalid path");
        }
        if (name2.length() > 255) {
            throw new ChimeraNFSException(63, "path too long");
        }
        if (name2.equals(".") || name2.equals("..")) {
            throw new ChimeraNFSException(10041, "bad name '.' or '..'");
        }
        Inode newInode = context.getFs().lookup(context.currentInode(), name2);
        context.currentInode(newInode);
        res.status = 0;
    }
}

