/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyQueue<K, V> {
    private static final Logger _log = LoggerFactory.getLogger(ReplyQueue.class);
    private final Map<K, V> _queue = new HashMap();

    public synchronized void registerKey(K key) {
        _log.debug("Registering key {}", (Object)key);
        this._queue.put(key, null);
    }

    public synchronized void put(K key, V value) {
        _log.debug("updating key {}", (Object)key);
        if (this._queue.containsKey(key)) {
            this._queue.put(key, value);
            this.notifyAll();
        }
    }

    public synchronized V get(K key) throws InterruptedException {
        _log.debug("query key {}", (Object)key);
        if (!this._queue.containsKey(key)) {
            throw new IllegalArgumentException("defined key does not exist: " + key);
        }
        while (this._queue.get(key) == null) {
            this.wait();
        }
        return this._queue.remove(key);
    }

    public synchronized V get(K key, int timeout) throws InterruptedException {
        _log.debug("query key {} with timeout", (Object)key);
        if (!this._queue.containsKey(key)) {
            throw new IllegalArgumentException("defined key does not exist: " + key);
        }
        long timeToWait = timeout;
        long deadline = System.currentTimeMillis() + (long)timeout;
        while (timeToWait > 0L && this._queue.get(key) == null) {
            this.wait(timeToWait);
            timeToWait = deadline - System.currentTimeMillis();
        }
        return this._queue.remove(key);
    }
}

