/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.nio.ByteOrder;
import org.dcache.xdr.GrizzlyMemoryManager;
import org.dcache.xdr.Xdr;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.BuffersBuffer;

public class RpcMessageParserTCP
extends BaseFilter {
    private static final int RPC_LAST_FRAG = Integer.MIN_VALUE;
    private static final int RPC_SIZE_MASK = Integer.MAX_VALUE;

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer messageBuffer = (Buffer)ctx.getMessage();
        if (messageBuffer == null) {
            return ctx.getStopAction();
        }
        if (!this.isAllFragmentsArrived(messageBuffer)) {
            return ctx.getStopAction(messageBuffer);
        }
        ctx.setMessage(this.assembleXdr(messageBuffer));
        Buffer reminder = messageBuffer.hasRemaining() ? messageBuffer.split(messageBuffer.position()) : null;
        return ctx.getInvokeAction(reminder);
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        Buffer b = (Buffer)ctx.getMessage();
        int len = b.remaining() | Integer.MIN_VALUE;
        Buffer marker = GrizzlyMemoryManager.allocate(4);
        marker.order(ByteOrder.BIG_ENDIAN);
        marker.putInt(len);
        marker.flip();
        marker.allowBufferDispose(true);
        b.allowBufferDispose(true);
        Buffer composite = GrizzlyMemoryManager.createComposite(marker, b);
        composite.allowBufferDispose(true);
        ctx.setMessage(composite);
        return ctx.getInvokeAction();
    }

    private boolean isAllFragmentsArrived(Buffer messageBuffer) throws IOException {
        Buffer buffer = messageBuffer.duplicate();
        buffer.order(ByteOrder.BIG_ENDIAN);
        while (buffer.remaining() >= 4) {
            int messageMarker = buffer.getInt();
            int size = RpcMessageParserTCP.getMessageSize(messageMarker);
            if (size > buffer.remaining()) {
                return false;
            }
            if (RpcMessageParserTCP.isLastFragment(messageMarker)) {
                return true;
            }
            buffer.position(buffer.position() + size);
        }
        return false;
    }

    private static int getMessageSize(int marker) {
        return marker & Integer.MAX_VALUE;
    }

    private static boolean isLastFragment(int marker) {
        return (marker & Integer.MIN_VALUE) != 0;
    }

    private Xdr assembleXdr(Buffer messageBuffer) {
        Buffer currentFragment;
        boolean messageComplete;
        BuffersBuffer multipleFragments = null;
        do {
            int messageMarker = messageBuffer.getInt();
            int size = RpcMessageParserTCP.getMessageSize(messageMarker);
            messageComplete = RpcMessageParserTCP.isLastFragment(messageMarker);
            int pos = messageBuffer.position();
            currentFragment = messageBuffer.slice(pos, pos + size);
            currentFragment.limit(size);
            messageBuffer.position(pos + size);
            if (!messageComplete & multipleFragments == null) {
                multipleFragments = GrizzlyMemoryManager.create();
            }
            if (multipleFragments == null) continue;
            multipleFragments.append(currentFragment);
        } while (!messageComplete);
        return new Xdr(multipleFragments == null ? currentFragment : multipleFragments);
    }
}

