/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr.portmap;

import java.io.IOException;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.RpcAuth;
import org.dcache.xdr.RpcAuthTypeNone;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.XdrBoolean;
import org.dcache.xdr.XdrString;
import org.dcache.xdr.XdrVoid;
import org.dcache.xdr.portmap.OncPortmapClient;
import org.dcache.xdr.portmap.rpcb;
import org.dcache.xdr.portmap.rpcb_list;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcbindV4Client
implements OncPortmapClient {
    private static final Logger _log = LoggerFactory.getLogger(RpcbindV4Client.class);
    private final RpcAuth _auth = new RpcAuthTypeNone();
    private final RpcCall _call;

    public RpcbindV4Client(RpcCall call) {
        this._call = call;
    }

    @Override
    public boolean ping() {
        _log.debug("portmap ping");
        boolean pong = false;
        try {
            this._call.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID, 2000);
            pong = true;
        }
        catch (OncRpcException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pong;
    }

    @Override
    public boolean setPort(int program, int version, String netid2, String addr, String owner) throws OncRpcException, IOException {
        _log.debug("portmap set port: prog: {} vers: {}, netid: {} addr: {}, owner: {}", program, version, netid2, addr, owner);
        rpcb m1 = new rpcb(program, version, netid2, addr, owner);
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(1, m1, isSet);
        return isSet.booleanValue();
    }

    @Override
    public boolean unsetPort(int program, int version, String owner) throws OncRpcException, IOException {
        _log.debug("portmap unset port: prog: {} vers: {}, owner: {}", program, version, owner);
        rpcb m = new rpcb(program, version, "", "", owner);
        XdrBoolean isSet = new XdrBoolean();
        this._call.call(2, m, isSet);
        return isSet.booleanValue();
    }

    @Override
    public String getPort(int program, int version, String netid2) throws OncRpcException, IOException {
        rpcb arg = new rpcb(program, version, netid2, "", "");
        XdrString xdrString = new XdrString();
        this._call.call(3, arg, xdrString);
        return xdrString.stringValue();
    }

    @Override
    public void dump() throws OncRpcException, IOException {
        _log.debug("portmap dump");
        rpcb_list rpcb_list_reply = new rpcb_list();
        this._call.call(4, XdrVoid.XDR_VOID, rpcb_list_reply);
        System.out.println(rpcb_list_reply);
    }
}

