/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.AbstractWriter;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;

public abstract class AbstractNIOAsyncQueueWriter
extends AbstractWriter<SocketAddress>
implements AsyncQueueWriter<SocketAddress> {
    private static final Logger LOGGER = Grizzly.logger(AbstractNIOAsyncQueueWriter.class);
    protected static final int EMPTY_RECORD_SPACE_VALUE = 1;
    protected final NIOTransport transport;
    protected volatile int maxPendingBytes = -2;
    protected volatile int maxWriteReentrants = 10;
    private volatile boolean isAllowDirectWrite = true;

    public AbstractNIOAsyncQueueWriter(NIOTransport transport) {
        this.transport = transport;
    }

    @Override
    @Deprecated
    public boolean canWrite(Connection connection, int size) {
        return this.canWrite(connection);
    }

    @Override
    public boolean canWrite(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        int connectionMaxPendingBytes = nioConnection.getMaxAsyncWriteQueueSize();
        if (connectionMaxPendingBytes < 0) {
            return true;
        }
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = nioConnection.getAsyncWriteQueue();
        int size = connectionQueue.spaceInBytes();
        return size == 0 || size < connectionMaxPendingBytes;
    }

    @Override
    @Deprecated
    public void notifyWritePossible(Connection connection, WriteHandler writeHandler, int size) {
        this.notifyWritePossible(connection, writeHandler);
    }

    @Override
    public void notifyWritePossible(Connection connection, WriteHandler writeHandler) {
        ((NIOConnection)connection).getAsyncWriteQueue().notifyWritePossible(writeHandler);
    }

    @Override
    public void setMaxPendingBytesPerConnection(int maxPendingBytes) {
        this.maxPendingBytes = maxPendingBytes < -2 ? -2 : maxPendingBytes;
    }

    @Override
    public int getMaxPendingBytesPerConnection() {
        return this.maxPendingBytes;
    }

    public boolean isAllowDirectWrite() {
        return this.isAllowDirectWrite;
    }

    public void setAllowDirectWrite(boolean isAllowDirectWrite) {
        this.isAllowDirectWrite = isAllowDirectWrite;
    }

    @Override
    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, MessageCloner<WritableMessage> cloner) {
        this.write(connection, dstAddress, message, completionHandler, null, cloner);
    }

    @Override
    @Deprecated
    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, PushBackHandler pushBackHandler) {
        this.write(connection, dstAddress, message, completionHandler, pushBackHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void write(Connection connection, SocketAddress dstAddress, WritableMessage message, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, PushBackHandler pushBackHandler, MessageCloner<WritableMessage> cloner) {
        NIOConnection nioConnection = (NIOConnection)connection;
        WriteResult<WritableMessage, SocketAddress> currentResult = WriteResult.create(nioConnection, message, dstAddress, 0);
        AsyncWriteQueueRecord queueRecord = this.createRecord(nioConnection, message, currentResult, completionHandler, dstAddress, pushBackHandler, !message.hasRemaining() || message.isExternal());
        if (nioConnection == null) {
            queueRecord.notifyFailure(new IOException("Connection is null"));
            return;
        }
        if (!nioConnection.isOpen()) {
            AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, new IOException("Connection is closed", nioConnection.closeStackTrace));
            return;
        }
        TaskQueue<AsyncWriteQueueRecord> writeTaskQueue = nioConnection.getAsyncWriteQueue();
        boolean isEmptyRecord = queueRecord.isEmptyRecord();
        int messageSize = message.remaining();
        int bytesToReserve = isEmptyRecord ? 1 : messageSize;
        int pendingBytes = writeTaskQueue.reserveSpace(bytesToReserve);
        boolean isCurrent = pendingBytes == bytesToReserve;
        boolean isLogFine = LOGGER.isLoggable(Level.FINEST);
        if (isLogFine) {
            AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.write connection={0} record={1} directWrite={2}", nioConnection, queueRecord, isCurrent);
        }
        Writer.Reentrant reentrants = Writer.Reentrant.getWriteReentrant();
        try {
            if (!reentrants.inc()) {
                queueRecord.setMessage(AbstractNIOAsyncQueueWriter.cloneRecordIfNeeded(nioConnection, cloner, message));
                if (isCurrent) {
                    writeTaskQueue.setCurrentElement(queueRecord);
                    nioConnection.simulateIOEvent(IOEvent.WRITE);
                } else {
                    AbstractNIOAsyncQueueWriter.offerToTaskQueue(nioConnection, queueRecord, writeTaskQueue);
                }
                return;
            }
            if (isCurrent && this.isAllowDirectWrite) {
                boolean isQueueEmpty;
                int written = messageSize > 0 ? (int)this.write0(nioConnection, queueRecord) : 0;
                boolean isFinished = queueRecord.isFinished();
                int bytesToRelease = !isEmptyRecord ? written : (isFinished ? 1 : 0);
                boolean bl = isQueueEmpty = writeTaskQueue.releaseSpaceAndNotify(bytesToRelease) == 0;
                if (isFinished) {
                    queueRecord.notifyCompleteAndRecycle();
                    if (!isQueueEmpty) {
                        nioConnection.simulateIOEvent(IOEvent.WRITE);
                    }
                    return;
                }
            }
            queueRecord.setMessage(AbstractNIOAsyncQueueWriter.cloneRecordIfNeeded(nioConnection, cloner, message));
            if (isCurrent) {
                writeTaskQueue.setCurrentElement(queueRecord);
                this.onReadyToWrite(nioConnection);
            } else {
                AbstractNIOAsyncQueueWriter.offerToTaskQueue(nioConnection, queueRecord, writeTaskQueue);
            }
        }
        catch (IOException e) {
            if (isLogFine) {
                LOGGER.log(Level.FINEST, "AsyncQueueWriter.write exception. connection=" + nioConnection + " record=" + queueRecord, e);
            }
            AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, e);
        }
        finally {
            reentrants.dec();
        }
    }

    @Override
    public AsyncQueue.AsyncResult processAsync(Context context) {
        boolean isLogFine = LOGGER.isLoggable(Level.FINEST);
        NIOConnection nioConnection = (NIOConnection)context.getConnection();
        if (!nioConnection.isOpen()) {
            return AsyncQueue.AsyncResult.COMPLETE;
        }
        TaskQueue<AsyncWriteQueueRecord> writeTaskQueue = nioConnection.getAsyncWriteQueue();
        int bytesReleased = 0;
        boolean done = true;
        AsyncWriteQueueRecord queueRecord = null;
        try {
            AsyncQueue.AsyncResult result;
            while ((queueRecord = this.aggregate(writeTaskQueue)) != null) {
                if (isLogFine) {
                    AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync doWriteconnection={0} record={1}", nioConnection, queueRecord);
                }
                int written = queueRecord.remaining() > 0L ? (int)this.write0(nioConnection, queueRecord) : 0;
                done = queueRecord.isFinished();
                int bytesToRelease = !queueRecord.isEmptyRecord() ? written : (done ? 1 : 0);
                bytesReleased += bytesToRelease;
                if (done) {
                    AbstractNIOAsyncQueueWriter.finishQueueRecord(nioConnection, queueRecord);
                    continue;
                }
                queueRecord.notifyIncomplete();
                writeTaskQueue.setCurrentElement(queueRecord);
                if (!isLogFine) break;
                AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync onReadyToWrite connection={0} peekRecord={1}", nioConnection, queueRecord);
                break;
            }
            boolean isComplete = false;
            if (bytesReleased > 0) {
                if (done && !context.isManualIOEventControl() && writeTaskQueue.spaceInBytes() - bytesReleased <= 0) {
                    context.setManualIOEventControl();
                }
                boolean bl = isComplete = writeTaskQueue.releaseSpace(bytesReleased) == 0;
            }
            AsyncQueue.AsyncResult asyncResult = !done ? AsyncQueue.AsyncResult.INCOMPLETE : (result = !isComplete ? AsyncQueue.AsyncResult.EXPECTING_MORE : AsyncQueue.AsyncResult.COMPLETE);
            if (bytesReleased > 0) {
                context.complete(result.toProcessorResult());
                writeTaskQueue.doNotify();
                return AsyncQueue.AsyncResult.TERMINATE;
            }
            return result;
        }
        catch (IOException e) {
            if (isLogFine) {
                LOGGER.log(Level.FINEST, "AsyncQueueWriter.processAsync exception connection=" + nioConnection + " peekRecord=" + queueRecord, e);
            }
            AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, e);
            return AsyncQueue.AsyncResult.COMPLETE;
        }
    }

    private static void finishQueueRecord(NIOConnection nioConnection, AsyncWriteQueueRecord queueRecord) {
        boolean isLogFine = LOGGER.isLoggable(Level.FINEST);
        if (isLogFine) {
            AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync finished connection={0} record={1}", nioConnection, queueRecord);
        }
        if (queueRecord != null) {
            queueRecord.notifyCompleteAndRecycle();
        }
        if (isLogFine) {
            AbstractNIOAsyncQueueWriter.doFineLog("AsyncQueueWriter.processAsync nextRecord connection={0} nextRecord={1}", nioConnection, queueRecord);
        }
    }

    protected static void offerToTaskQueue(NIOConnection nioConnection, AsyncWriteQueueRecord queueRecord, TaskQueue<AsyncWriteQueueRecord> taskQueue) {
        taskQueue.offer(queueRecord);
        if (!nioConnection.isOpen() && taskQueue.remove(queueRecord)) {
            AbstractNIOAsyncQueueWriter.onWriteFailure(nioConnection, queueRecord, new IOException("Connection is closed"));
        }
    }

    private static WritableMessage cloneRecordIfNeeded(Connection connection, MessageCloner<WritableMessage> cloner, WritableMessage message) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "AsyncQueueWriter.write clone. connection={0} cloner={1}", new Object[]{connection, cloner});
        }
        return cloner == null ? message : cloner.clone(connection, message);
    }

    protected AsyncWriteQueueRecord createRecord(Connection connection, WritableMessage message, WriteResult<WritableMessage, SocketAddress> currentResult, CompletionHandler<WriteResult<WritableMessage, SocketAddress>> completionHandler, SocketAddress dstAddress, PushBackHandler pushBackHandler, boolean isEmptyRecord) {
        return AsyncWriteQueueRecord.create(connection, message, currentResult, completionHandler, dstAddress, pushBackHandler, isEmptyRecord);
    }

    @Override
    public final boolean isReady(Connection connection) {
        TaskQueue<AsyncWriteQueueRecord> connectionQueue = ((NIOConnection)connection).getAsyncWriteQueue();
        return connectionQueue != null && !connectionQueue.isEmpty();
    }

    private static void doFineLog(String msg, Object ... params) {
        LOGGER.log(Level.FINEST, msg, params);
    }

    @Override
    public void onClose(Connection connection) {
        NIOConnection nioConnection = (NIOConnection)connection;
        TaskQueue<AsyncWriteQueueRecord> writeQueue = nioConnection.getAsyncWriteQueue();
        writeQueue.onClose(nioConnection.closeStackTrace);
    }

    @Override
    public final void close() {
    }

    protected static void onWriteFailure(Connection connection, AsyncWriteQueueRecord failedRecord, Throwable e) {
        failedRecord.notifyFailure(e);
        connection.closeSilently();
    }

    protected abstract long write0(NIOConnection var1, AsyncWriteQueueRecord var2) throws IOException;

    protected abstract void onReadyToWrite(NIOConnection var1) throws IOException;

    protected AsyncWriteQueueRecord aggregate(TaskQueue<AsyncWriteQueueRecord> connectionQueue) {
        return connectionQueue.obtainCurrentElementAndReserve();
    }
}

