/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.tools.argparser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.tools.argparser.DefaultValue;
import org.glassfish.pfl.basic.tools.argparser.ElementParser;
import org.glassfish.pfl.basic.tools.argparser.Help;
import org.glassfish.pfl.basic.tools.argparser.Separator;

public class ArgParser {
    private final List<Class<?>> interfaceClasses = new ArrayList();
    private final Map<String, String> helpText = new HashMap<String, String>();
    private final Map<String, Object> defaultValues = new HashMap<String, Object>();
    private final Map<String, ElementParser> parserData = new HashMap<String, ElementParser>();

    public ArgParser(Class<?> cls) {
        this.init(cls);
    }

    public ArgParser(List<Class<?>> classes) {
        this.init(classes);
    }

    private void init(Class<?> cls) {
        ArrayList classes = new ArrayList();
        classes.add(cls);
        this.init(classes);
    }

    private void init(List<Class<?>> classes) {
        HashMap<String, String> defaultValueData = new HashMap<String, String>();
        for (Class<?> cls : classes) {
            if (!cls.isInterface()) {
                this.error(cls.getName() + " is not an interface");
            }
            this.interfaceClasses.add(cls);
            for (Method m : cls.getMethods()) {
                String keyword = this.checkMethod(m);
                ElementParser ep = ElementParser.factory.evaluate(m);
                this.parserData.put(keyword, ep);
                DefaultValue dv = m.getAnnotation(DefaultValue.class);
                if (dv == null) {
                    this.error("Method " + m.getName() + " does not have a DefaultValue annotation");
                } else {
                    defaultValueData.put(keyword, dv.value());
                }
                Help help = m.getAnnotation(Help.class);
                if (help == null) continue;
                this.helpText.put(keyword, help.value());
            }
            this.internalParse(defaultValueData, this.defaultValues);
        }
    }

    private String display(Object obj) {
        if (obj.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int ctr = 0; ctr < Array.getLength(obj); ++ctr) {
                Object element = Array.get(obj, ctr);
                if (ctr > 0) {
                    sb.append(",");
                }
                sb.append(element.toString());
            }
            sb.append("]");
            return sb.toString();
        }
        if (obj instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Object element : (Collection)obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(element.toString());
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public String getHelpText() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Legal arguments are:\n");
        Set<String> keys = this.parserData.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keys);
        Collections.sort(keyList);
        for (String keyword : keyList) {
            ElementParser ep = this.parserData.get(keyword);
            sb.append("\t-").append(keyword).append(" <");
            boolean first = true;
            for (String str : ep.describe()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n\t    ");
                }
                sb.append(str);
            }
            sb.append(">\n");
            String defaultValue = this.display(this.defaultValues.get(keyword));
            sb.append("\t    (default ").append(defaultValue).append(")\n");
            String help = this.helpText.get(keyword);
            if (help != null) {
                sb.append("\t    ").append(help).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Object parse(String[] args) {
        Map<String, String> data = this.makeMap(args);
        HashMap<String, Object> pdata = new HashMap<String, Object>();
        this.internalParse(data, pdata);
        Object result = this.makeProxy(pdata);
        return result;
    }

    public <T> T parse(String[] args, Class<T> cls) {
        return cls.cast(this.parse(args));
    }

    private void error(String msg) {
        System.out.println("Error in argument parser: " + msg);
        System.out.println(this.getHelpText());
        throw new RuntimeException(msg);
    }

    private String checkMethod(Method m) {
        if (m.getParameterTypes().length == 0) {
            return m.getName();
        }
        this.error("Method " + m.getName() + " must not have any parameters");
        return null;
    }

    private void internalParse(Map<String, String> data, Map<String, Object> result) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String keyword = entry.getKey();
            ElementParser ep = this.parserData.get(keyword);
            if (ep == null) {
                this.error(keyword + " is not a valid keyword");
            }
            Object val = ep.evaluate(entry.getValue());
            result.put(keyword, val);
        }
    }

    private String getKeyword(String arg) {
        if (arg.charAt(0) == '-') {
            return arg.substring(1);
        }
        this.error(arg + " is not a valid keyword");
        return null;
    }

    private Map<String, String> makeMap(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        String keyword = null;
        for (String arg : args) {
            if (keyword == null) {
                keyword = this.getKeyword(arg);
                continue;
            }
            result.put(keyword, arg);
            keyword = null;
        }
        if (keyword != null) {
            this.error("No argument supplied for keyword " + keyword);
        }
        return result;
    }

    private Object makeProxy(final Map<String, Object> data) {
        InvocationHandler ih = new InvocationHandler(){

            private Object getValue(String keyword) {
                Object result = data.get(keyword);
                if (result == null) {
                    result = ArgParser.this.defaultValues.get(keyword);
                }
                return result;
            }

            private String getString(Object obj) {
                Class<?> cls = obj.getClass();
                if (cls.isArray()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    for (int ctr = 0; ctr < Array.getLength(obj); ++ctr) {
                        if (ctr > 0) {
                            sb.append(",");
                        }
                        Object element = Array.get(obj, ctr);
                        sb.append(element.toString());
                    }
                    sb.append("]");
                    return sb.toString();
                }
                return obj.toString();
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                String name2 = method.getName();
                if (name2.equals("toString")) {
                    StringBuilder sb = new StringBuilder();
                    for (String keyword : ArgParser.this.parserData.keySet()) {
                        sb.append(keyword);
                        sb.append("=");
                        sb.append(this.getString(this.getValue(keyword)));
                        sb.append("\n");
                    }
                    return sb.toString();
                }
                return this.getValue(name2);
            }
        };
        Class[] interfaces = this.interfaceClasses.toArray(new Class[this.interfaceClasses.size()]);
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = interfaces[0].getClass().getClassLoader();
        }
        if (cl == null) {
            ClassLoader.getSystemClassLoader();
        }
        return Proxy.newProxyInstance(cl, interfaces, ih);
    }

    public static void main(String[] args) {
        Class[] interfaces = new Class[]{TestInterface1.class, TestInterface2.class};
        ArgParser ap = new ArgParser(Arrays.asList(interfaces));
        System.out.println("Help text for this parser:\n" + ap.getHelpText());
        Object result = ap.parse(args);
        if (!(result instanceof TestInterface1) || !(result instanceof TestInterface2)) {
            System.out.println("Error: result not an instance of both test interfaces");
        }
        System.out.println("Result is:\n" + result);
    }

    private static interface TestInterface2 {
        @DefaultValue(value="http://www.sun.com")
        @Help(value="your favorite URL")
        public URL url();

        @DefaultValue(value="funny:thing,another:thing,something:else")
        @Help(value="A list of pairs of the form xxx:yyy")
        @Separator(value=",")
        public StringPair[] arrayData();

        @DefaultValue(value="funny:thing,another:thing,something:else")
        @Help(value="A list of pairs of the form xxx:yyy")
        @Separator(value=",")
        public List<StringPair> listData();
    }

    private static interface TestInterface1 {
        @DefaultValue(value="27")
        @Help(value="An integer value")
        public int value();

        @DefaultValue(value="Michigan")
        @Help(value="The name of a lake")
        public String lake();

        @DefaultValue(value="RED")
        @Help(value="Pick a color")
        public PrimaryColor color();
    }

    private static enum PrimaryColor {
        RED,
        GREEN,
        BLUE;

    }

    public static class StringPair
    extends Pair<String, String> {
        public StringPair(String first, String second) {
            super(first, second);
        }

        public StringPair(String data) {
            super(null, null);
            int index = data.indexOf(58);
            if (index < 0) {
                throw new IllegalArgumentException(data + " does not contain a :");
            }
            this._first = data.substring(0, index);
            this._second = data.substring(index + 1);
        }
    }
}

