/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.AliasRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAliasRegistry
implements AliasRegistry {
    private final Map<String, String> aliasMap = new ConcurrentHashMap<String, String>();

    @Override
    public void registerAlias(String name2, String alias) {
        Assert.hasText(name2, "'name' must not be empty");
        Assert.hasText(alias, "'alias' must not be empty");
        if (alias.equals(name2)) {
            this.aliasMap.remove(alias);
        } else {
            String registeredName;
            if (!this.allowAliasOverriding() && (registeredName = this.aliasMap.get(alias)) != null && !registeredName.equals(name2)) {
                throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name2 + "': It is already registered for name '" + registeredName + "'.");
            }
            this.checkForAliasCircle(name2, alias);
            this.aliasMap.put(alias, name2);
        }
    }

    protected boolean allowAliasOverriding() {
        return true;
    }

    @Override
    public void removeAlias(String alias) {
        String name2 = this.aliasMap.remove(alias);
        if (name2 == null) {
            throw new IllegalStateException("No alias '" + alias + "' registered");
        }
    }

    @Override
    public boolean isAlias(String name2) {
        return this.aliasMap.containsKey(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAliases(String name2) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            this.retrieveAliases(name2, result);
        }
        return StringUtils.toStringArray(result);
    }

    private void retrieveAliases(String name2, List<String> result) {
        for (Map.Entry<String, String> entry : this.aliasMap.entrySet()) {
            String registeredName = entry.getValue();
            if (!registeredName.equals(name2)) continue;
            String alias = entry.getKey();
            result.add(alias);
            this.retrieveAliases(alias, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAliases(StringValueResolver valueResolver) {
        Assert.notNull(valueResolver, "StringValueResolver must not be null");
        Map<String, String> map = this.aliasMap;
        synchronized (map) {
            HashMap<String, String> aliasCopy = new HashMap<String, String>(this.aliasMap);
            for (String alias : aliasCopy.keySet()) {
                String resolvedName;
                String registeredName = (String)aliasCopy.get(alias);
                String resolvedAlias = valueResolver.resolveStringValue(alias);
                if (resolvedAlias.equals(resolvedName = valueResolver.resolveStringValue(registeredName))) {
                    this.aliasMap.remove(alias);
                    continue;
                }
                if (!resolvedAlias.equals(alias)) {
                    String existingName = this.aliasMap.get(resolvedAlias);
                    if (existingName != null && !existingName.equals(resolvedName)) {
                        throw new IllegalStateException("Cannot register resolved alias '" + resolvedAlias + "' (original: '" + alias + "') for name '" + resolvedName + "': It is already registered for name '" + registeredName + "'.");
                    }
                    this.checkForAliasCircle(resolvedName, resolvedAlias);
                    this.aliasMap.remove(alias);
                    this.aliasMap.put(resolvedAlias, resolvedName);
                    continue;
                }
                if (registeredName.equals(resolvedName)) continue;
                this.aliasMap.put(alias, resolvedName);
            }
        }
    }

    public String canonicalName(String name2) {
        String resolvedName;
        String canonicalName = name2;
        do {
            if ((resolvedName = this.aliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }

    protected void checkForAliasCircle(String name2, String alias) {
        if (alias.equals(this.canonicalName(name2))) {
            throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name2 + "': Circular reference - '" + name2 + "' is a direct or indirect alias for '" + alias + "' already");
        }
    }
}

