/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.tf.spi.EnhancedClassData;
import org.glassfish.pfl.tf.spi.TimingPointType;
import org.glassfish.pfl.tf.spi.Util;

public abstract class EnhancedClassDataBase
implements EnhancedClassData {
    protected Util util;
    protected final Set<String> annotationNames;
    protected String className;
    protected final Set<String> annoNamesForClass = new HashSet<String>();
    protected final Map<String, String> annoToHolderName = new HashMap<String, String>();
    protected final List<String> methodNames = new ArrayList<String>();
    protected final List<String> methodDescriptions = new ArrayList<String>();
    protected final List<TimingPointType> methodTPTs = new ArrayList<TimingPointType>();
    protected final List<String> methodTPNames = new ArrayList<String>();
    protected final List<String> methodAnnoList = new ArrayList<String>();
    protected final Set<String> infoMethodDescs = new HashSet<String>();
    protected final Set<String> mmMethodDescs = new HashSet<String>();
    protected final Map<String, String> methodToAnno = new HashMap<String, String>();

    protected EnhancedClassDataBase(Util util, Set<String> annotationNames) {
        this.util = util;
        this.annotationNames = annotationNames;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Map<String, String> getAnnotationToHolderName() {
        return this.annoToHolderName;
    }

    @Override
    public List<String> getMethodNames() {
        return this.methodNames;
    }

    @Override
    public int getMethodIndex(String methodName) {
        if (methodName != null) {
            for (int ctr = 0; ctr < this.methodNames.size(); ++ctr) {
                if (!methodName.equals(this.methodNames.get(ctr))) continue;
                return ctr;
            }
        }
        return -1;
    }

    @Override
    public String getHolderName(String fullMethodDescriptor) {
        String aname = this.methodToAnno.get(fullMethodDescriptor);
        String result = this.annoToHolderName.get(aname);
        return result;
    }

    @Override
    public EnhancedClassData.MethodType classifyMethod(String fullMethodDescriptor) {
        if (fullMethodDescriptor.equals("<clinit>()V")) {
            return EnhancedClassData.MethodType.STATIC_INITIALIZER;
        }
        if (this.infoMethodDescs.contains(fullMethodDescriptor)) {
            return EnhancedClassData.MethodType.INFO_METHOD;
        }
        if (this.mmMethodDescs.contains(fullMethodDescriptor)) {
            return EnhancedClassData.MethodType.MONITORED_METHOD;
        }
        return EnhancedClassData.MethodType.NORMAL_METHOD;
    }

    @Override
    public boolean isTracedClass() {
        return !this.annoNamesForClass.isEmpty();
    }

    @Override
    public void updateInfoDesc() {
        String[] descs = this.infoMethodDescs.toArray(new String[this.infoMethodDescs.size()]);
        this.infoMethodDescs.clear();
        for (String desc : descs) {
            int index = desc.indexOf(40);
            String name2 = desc.substring(0, index);
            String d = desc.substring(index);
            String fd = this.util.augmentInfoMethodDescriptor(d);
            this.infoMethodDescs.add(name2 + fd);
        }
    }

    @Override
    public List<String> getDescriptions() {
        return this.methodDescriptions;
    }

    @Override
    public List<TimingPointType> getTimingPointTypes() {
        return this.methodTPTs;
    }

    @Override
    public List<String> getTimingPointNames() {
        return this.methodTPNames;
    }

    @Override
    public List<String> getMethodMMAnnotationName() {
        return this.methodAnnoList;
    }
}

