/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.LifecycleProcessor;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.ContextTypeMatchClassLoader;
import org.springframework.context.support.DefaultLifecycleProcessor;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.context.support.ReadOnlySystemAttributesMap;
import org.springframework.context.weaving.LoadTimeWeaverAwareProcessor;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext,
DisposableBean {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String LIFECYCLE_PROCESSOR_BEAN_NAME = "lifecycleProcessor";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String id = ObjectUtils.identityToString(this);
    private String displayName = ObjectUtils.identityToString(this);
    private ApplicationContext parent;
    private final List<BeanFactoryPostProcessor> beanFactoryPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
    private long startupDate;
    private boolean active = false;
    private boolean closed = false;
    private final Object activeMonitor = new Object();
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private ResourcePatternResolver resourcePatternResolver;
    private LifecycleProcessor lifecycleProcessor;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private Set<ApplicationListener> applicationListeners = new LinkedHashSet<ApplicationListener>();

    static {
        ContextClosedEvent.class.getName();
    }

    public AbstractApplicationContext() {
        this((ApplicationContext)null);
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
        this.resourcePatternResolver = this.getResourcePatternResolver();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setDisplayName(String displayName) {
        Assert.hasLength(displayName, "Display name must not be empty");
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ApplicationContext getParent() {
        return this.parent;
    }

    @Override
    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.getBeanFactory();
    }

    @Override
    public long getStartupDate() {
        return this.startupDate;
    }

    @Override
    public void publishEvent(ApplicationEvent event) {
        Assert.notNull(event, "Event must not be null");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Publishing event in " + this.getDisplayName() + ": " + event);
        }
        this.getApplicationEventMulticaster().multicastEvent(event);
        if (this.parent != null) {
            this.parent.publishEvent(event);
        }
    }

    private ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    private LifecycleProcessor getLifecycleProcessor() {
        if (this.lifecycleProcessor == null) {
            throw new IllegalStateException("LifecycleProcessor not initialized - call 'refresh' before invoking lifecycle methods via the context: " + this);
        }
        return this.lifecycleProcessor;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver(this);
    }

    @Override
    public void setParent(ApplicationContext parent) {
        this.parent = parent;
    }

    @Override
    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List<BeanFactoryPostProcessor> getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    @Override
    public void addApplicationListener(ApplicationListener listener) {
        if (this.applicationEventMulticaster != null) {
            this.applicationEventMulticaster.addApplicationListener(listener);
        } else {
            this.applicationListeners.add(listener);
        }
    }

    public Collection<ApplicationListener> getApplicationListeners() {
        return this.applicationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws BeansException, IllegalStateException {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.prepareRefresh();
            ConfigurableListableBeanFactory beanFactory = this.obtainFreshBeanFactory();
            this.prepareBeanFactory(beanFactory);
            try {
                this.postProcessBeanFactory(beanFactory);
                this.invokeBeanFactoryPostProcessors(beanFactory);
                this.registerBeanPostProcessors(beanFactory);
                this.initMessageSource();
                this.initApplicationEventMulticaster();
                this.onRefresh();
                this.registerListeners();
                this.finishBeanFactoryInitialization(beanFactory);
                this.finishRefresh();
            }
            catch (BeansException ex) {
                this.destroyBeans();
                this.cancelRefresh(ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareRefresh() {
        this.startupDate = System.currentTimeMillis();
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = true;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Refreshing " + this);
        }
    }

    protected ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Bean factory for " + this.getDisplayName() + ": " + beanFactory);
        }
        return beanFactory;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.setBeanClassLoader(this.getClassLoader());
        beanFactory.setBeanExpressionResolver(new StandardBeanExpressionResolver());
        beanFactory.addPropertyEditorRegistrar(new ResourceEditorRegistrar(this));
        beanFactory.addBeanPostProcessor(new ApplicationContextAwareProcessor(this));
        beanFactory.ignoreDependencyInterface(ResourceLoaderAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationEventPublisherAware.class);
        beanFactory.ignoreDependencyInterface(MessageSourceAware.class);
        beanFactory.ignoreDependencyInterface(ApplicationContextAware.class);
        beanFactory.registerResolvableDependency(BeanFactory.class, beanFactory);
        beanFactory.registerResolvableDependency(ResourceLoader.class, this);
        beanFactory.registerResolvableDependency(ApplicationEventPublisher.class, this);
        beanFactory.registerResolvableDependency(ApplicationContext.class, this);
        if (beanFactory.containsBean("loadTimeWeaver")) {
            beanFactory.addBeanPostProcessor(new LoadTimeWeaverAwareProcessor(beanFactory));
            beanFactory.setTempClassLoader(new ContextTypeMatchClassLoader(beanFactory.getBeanClassLoader()));
        }
        if (!beanFactory.containsBean("systemProperties")) {
            Map<Object, Object> systemProperties;
            try {
                systemProperties = System.getProperties();
            }
            catch (AccessControlException accessControlException) {
                systemProperties = new ReadOnlySystemAttributesMap(){

                    protected String getSystemAttribute(String propertyName) {
                        try {
                            return System.getProperty(propertyName);
                        }
                        catch (AccessControlException ex) {
                            if (AbstractApplicationContext.this.logger.isInfoEnabled()) {
                                AbstractApplicationContext.this.logger.info("Not allowed to obtain system property [" + propertyName + "]: " + ex.getMessage());
                            }
                            return null;
                        }
                    }
                };
            }
            beanFactory.registerSingleton("systemProperties", systemProperties);
        }
        if (!beanFactory.containsBean("systemEnvironment")) {
            ReadOnlySystemAttributesMap systemEnvironment;
            try {
                systemEnvironment = System.getenv();
            }
            catch (AccessControlException accessControlException) {
                systemEnvironment = new ReadOnlySystemAttributesMap(){

                    protected String getSystemAttribute(String variableName) {
                        try {
                            return System.getenv(variableName);
                        }
                        catch (AccessControlException ex) {
                            if (AbstractApplicationContext.this.logger.isInfoEnabled()) {
                                AbstractApplicationContext.this.logger.info("Not allowed to obtain system environment variable [" + variableName + "]: " + ex.getMessage());
                            }
                            return null;
                        }
                    }
                };
            }
            beanFactory.registerSingleton("systemEnvironment", systemEnvironment);
        }
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        HashSet processedBeans = new HashSet();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)((Object)beanFactory);
            LinkedList<BeanFactoryPostProcessor> regularPostProcessors = new LinkedList<BeanFactoryPostProcessor>();
            LinkedList<BeanDefinitionRegistryPostProcessor> registryPostProcessors = new LinkedList<BeanDefinitionRegistryPostProcessor>();
            for (BeanFactoryPostProcessor postProcessor : this.getBeanFactoryPostProcessors()) {
                if (postProcessor instanceof BeanDefinitionRegistryPostProcessor) {
                    BeanDefinitionRegistryPostProcessor registryPostProcessor = (BeanDefinitionRegistryPostProcessor)postProcessor;
                    registryPostProcessor.postProcessBeanDefinitionRegistry(registry);
                    registryPostProcessors.add(registryPostProcessor);
                    continue;
                }
                regularPostProcessors.add(postProcessor);
            }
            Map<String, BeanDefinitionRegistryPostProcessor> beanMap = beanFactory.getBeansOfType(BeanDefinitionRegistryPostProcessor.class, true, false);
            ArrayList<BeanDefinitionRegistryPostProcessor> registryPostProcessorBeans = new ArrayList<BeanDefinitionRegistryPostProcessor>(beanMap.values());
            OrderComparator.sort(registryPostProcessorBeans);
            for (BeanDefinitionRegistryPostProcessor postProcessor : registryPostProcessorBeans) {
                postProcessor.postProcessBeanDefinitionRegistry(registry);
            }
            this.invokeBeanFactoryPostProcessors(registryPostProcessors, beanFactory);
            this.invokeBeanFactoryPostProcessors(registryPostProcessorBeans, beanFactory);
            this.invokeBeanFactoryPostProcessors(regularPostProcessors, beanFactory);
            processedBeans.addAll(beanMap.keySet());
        } else {
            this.invokeBeanFactoryPostProcessors(this.getBeanFactoryPostProcessors(), beanFactory);
        }
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false);
        ArrayList<BeanFactoryPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        String[] stringArray = postProcessorNames;
        int n = postProcessorNames.length;
        int postProcessor = 0;
        while (postProcessor < n) {
            String ppName = stringArray[postProcessor];
            if (!processedBeans.contains(ppName)) {
                if (this.isTypeMatch(ppName, PriorityOrdered.class)) {
                    priorityOrderedPostProcessors.add(beanFactory.getBean(ppName, BeanFactoryPostProcessor.class));
                } else if (this.isTypeMatch(ppName, Ordered.class)) {
                    orderedPostProcessorNames.add(ppName);
                } else {
                    nonOrderedPostProcessorNames.add(ppName);
                }
            }
            ++postProcessor;
        }
        OrderComparator.sort(priorityOrderedPostProcessors);
        this.invokeBeanFactoryPostProcessors(priorityOrderedPostProcessors, beanFactory);
        ArrayList<BeanFactoryPostProcessor> orderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        for (String postProcessorName : orderedPostProcessorNames) {
            orderedPostProcessors.add(this.getBean(postProcessorName, BeanFactoryPostProcessor.class));
        }
        OrderComparator.sort(orderedPostProcessors);
        this.invokeBeanFactoryPostProcessors(orderedPostProcessors, beanFactory);
        ArrayList<BeanFactoryPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        for (String postProcessorName : nonOrderedPostProcessorNames) {
            nonOrderedPostProcessors.add(this.getBean(postProcessorName, BeanFactoryPostProcessor.class));
        }
        this.invokeBeanFactoryPostProcessors(nonOrderedPostProcessors, beanFactory);
    }

    private void invokeBeanFactoryPostProcessors(Collection<? extends BeanFactoryPostProcessor> postProcessors, ConfigurableListableBeanFactory beanFactory) {
        for (BeanFactoryPostProcessor beanFactoryPostProcessor : postProcessors) {
            beanFactoryPostProcessor.postProcessBeanFactory(beanFactory);
        }
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        BeanPostProcessor pp;
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.length;
        beanFactory.addBeanPostProcessor(new BeanPostProcessorChecker(beanFactory, beanProcessorTargetCount));
        ArrayList<BeanPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanPostProcessor>();
        ArrayList<BeanPostProcessor> internalPostProcessors = new ArrayList<BeanPostProcessor>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        String[] stringArray = postProcessorNames;
        int n = postProcessorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String ppName = stringArray[n2];
            if (this.isTypeMatch(ppName, PriorityOrdered.class)) {
                pp = beanFactory.getBean(ppName, BeanPostProcessor.class);
                priorityOrderedPostProcessors.add(pp);
                if (pp instanceof MergedBeanDefinitionPostProcessor) {
                    internalPostProcessors.add(pp);
                }
            } else if (this.isTypeMatch(ppName, Ordered.class)) {
                orderedPostProcessorNames.add(ppName);
            } else {
                nonOrderedPostProcessorNames.add(ppName);
            }
            ++n2;
        }
        OrderComparator.sort(priorityOrderedPostProcessors);
        this.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<BeanPostProcessor> orderedPostProcessors = new ArrayList<BeanPostProcessor>();
        for (String ppName : orderedPostProcessorNames) {
            BeanPostProcessor pp2 = beanFactory.getBean(ppName, BeanPostProcessor.class);
            orderedPostProcessors.add(pp2);
            if (!(pp2 instanceof MergedBeanDefinitionPostProcessor)) continue;
            internalPostProcessors.add(pp2);
        }
        OrderComparator.sort(orderedPostProcessors);
        this.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<BeanPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanPostProcessor>();
        for (String ppName : nonOrderedPostProcessorNames) {
            pp = beanFactory.getBean(ppName, BeanPostProcessor.class);
            nonOrderedPostProcessors.add(pp);
            if (!(pp instanceof MergedBeanDefinitionPostProcessor)) continue;
            internalPostProcessors.add(pp);
        }
        this.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
        OrderComparator.sort(internalPostProcessors);
        this.registerBeanPostProcessors(beanFactory, internalPostProcessors);
        beanFactory.addBeanPostProcessor(new ApplicationListenerDetector());
    }

    private void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, List<BeanPostProcessor> postProcessors) {
        for (BeanPostProcessor postProcessor : postProcessors) {
            beanFactory.addBeanPostProcessor(postProcessor);
        }
    }

    protected void initMessageSource() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(MESSAGE_SOURCE_BEAN_NAME)) {
            HierarchicalMessageSource hms;
            this.messageSource = beanFactory.getBean(MESSAGE_SOURCE_BEAN_NAME, MessageSource.class);
            if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && (hms = (HierarchicalMessageSource)this.messageSource).getParentMessageSource() == null) {
                hms.setParentMessageSource(this.getInternalParentMessageSource());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using MessageSource [" + this.messageSource + "]");
            }
        } else {
            DelegatingMessageSource dms = new DelegatingMessageSource();
            dms.setParentMessageSource(this.getInternalParentMessageSource());
            this.messageSource = dms;
            beanFactory.registerSingleton(MESSAGE_SOURCE_BEAN_NAME, this.messageSource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]");
            }
        }
    }

    protected void initApplicationEventMulticaster() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME)) {
            this.applicationEventMulticaster = beanFactory.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, ApplicationEventMulticaster.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using ApplicationEventMulticaster [" + this.applicationEventMulticaster + "]");
            }
        } else {
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster(beanFactory);
            beanFactory.registerSingleton(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, this.applicationEventMulticaster);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to locate ApplicationEventMulticaster with name 'applicationEventMulticaster': using default [" + this.applicationEventMulticaster + "]");
            }
        }
    }

    protected void initLifecycleProcessor() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory.containsLocalBean(LIFECYCLE_PROCESSOR_BEAN_NAME)) {
            this.lifecycleProcessor = beanFactory.getBean(LIFECYCLE_PROCESSOR_BEAN_NAME, LifecycleProcessor.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using LifecycleProcessor [" + this.lifecycleProcessor + "]");
            }
        } else {
            DefaultLifecycleProcessor defaultProcessor = new DefaultLifecycleProcessor();
            defaultProcessor.setBeanFactory(beanFactory);
            this.lifecycleProcessor = defaultProcessor;
            beanFactory.registerSingleton(LIFECYCLE_PROCESSOR_BEAN_NAME, this.lifecycleProcessor);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to locate LifecycleProcessor with name 'lifecycleProcessor': using default [" + this.lifecycleProcessor + "]");
            }
        }
    }

    protected void onRefresh() throws BeansException {
    }

    protected void registerListeners() {
        String[] listenerBeanNames;
        for (ApplicationListener listener : this.getApplicationListeners()) {
            this.getApplicationEventMulticaster().addApplicationListener(listener);
        }
        String[] stringArray = listenerBeanNames = this.getBeanNamesForType(ApplicationListener.class, true, false);
        int n = listenerBeanNames.length;
        int n2 = 0;
        while (n2 < n) {
            String lisName = stringArray[n2];
            this.getApplicationEventMulticaster().addApplicationListenerBean(lisName);
            ++n2;
        }
    }

    @Deprecated
    protected void addListener(ApplicationListener listener) {
        this.getApplicationEventMulticaster().addApplicationListener(listener);
    }

    protected void finishBeanFactoryInitialization(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory.containsBean("conversionService") && beanFactory.isTypeMatch("conversionService", ConversionService.class)) {
            beanFactory.setConversionService(beanFactory.getBean("conversionService", ConversionService.class));
        }
        beanFactory.setTempClassLoader(null);
        beanFactory.freezeConfiguration();
        beanFactory.preInstantiateSingletons();
    }

    protected void finishRefresh() {
        this.initLifecycleProcessor();
        this.getLifecycleProcessor().onRefresh();
        this.publishEvent(new ContextRefreshedEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelRefresh(BeansException ex) {
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = false;
        }
    }

    @Override
    public void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                public void run() {
                    AbstractApplicationContext.this.doClose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            if (this.shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        boolean actuallyClose;
        Object object = this.activeMonitor;
        synchronized (object) {
            actuallyClose = this.active && !this.closed;
            this.closed = true;
        }
        if (actuallyClose) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Closing " + this);
            }
            try {
                this.publishEvent(new ContextClosedEvent(this));
            }
            catch (Throwable ex) {
                this.logger.warn("Exception thrown from ApplicationListener handling ContextClosedEvent", ex);
            }
            try {
                this.getLifecycleProcessor().onClose();
            }
            catch (Throwable ex) {
                this.logger.warn("Exception thrown from LifecycleProcessor on context close", ex);
            }
            this.destroyBeans();
            this.closeBeanFactory();
            this.onClose();
            object = this.activeMonitor;
            synchronized (object) {
                this.active = false;
            }
        }
    }

    protected void destroyBeans() {
        this.getBeanFactory().destroySingletons();
    }

    protected void onClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.activeMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    @Override
    public Object getBean(String name2) throws BeansException {
        return this.getBeanFactory().getBean(name2);
    }

    @Override
    public <T> T getBean(String name2, Class<T> requiredType) throws BeansException {
        return this.getBeanFactory().getBean(name2, requiredType);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBeanFactory().getBean(requiredType);
    }

    @Override
    public Object getBean(String name2, Object ... args) throws BeansException {
        return this.getBeanFactory().getBean(name2, args);
    }

    @Override
    public boolean containsBean(String name2) {
        return this.getBeanFactory().containsBean(name2);
    }

    @Override
    public boolean isSingleton(String name2) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(name2);
    }

    @Override
    public boolean isPrototype(String name2) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isPrototype(name2);
    }

    @Override
    public boolean isTypeMatch(String name2, Class targetType) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isTypeMatch(name2, targetType);
    }

    @Override
    public Class<?> getType(String name2) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getType(name2);
    }

    @Override
    public String[] getAliases(String name2) {
        return this.getBeanFactory().getAliases(name2);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanFactory().containsBeanDefinition(beanName);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    @Override
    public String[] getBeanNamesForType(Class type) {
        return this.getBeanFactory().getBeanNamesForType(type);
    }

    @Override
    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.getBeanFactory().getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includeNonSingletons, allowEagerInit);
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return this.getBeanFactory().getBeansWithAnnotation(annotationType);
    }

    @Override
    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        return this.getBeanFactory().findAnnotationOnBean(beanName, annotationType);
    }

    @Override
    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    @Override
    public boolean containsLocalBean(String name2) {
        return this.getBeanFactory().containsLocalBean(name2);
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    @Override
    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return this.getMessageSource().getMessage(code, args, defaultMessage, locale);
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(code, args, locale);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(resolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    protected MessageSource getInternalParentMessageSource() {
        return this.getParent() instanceof AbstractApplicationContext ? ((AbstractApplicationContext)this.getParent()).messageSource : this.getParent();
    }

    @Override
    public Resource[] getResources(String locationPattern) throws IOException {
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    @Override
    public void start() {
        this.getLifecycleProcessor().start();
        this.publishEvent(new ContextStartedEvent(this));
    }

    @Override
    public void stop() {
        this.getLifecycleProcessor().stop();
        this.publishEvent(new ContextStoppedEvent(this));
    }

    @Override
    public boolean isRunning() {
        return this.getLifecycleProcessor().isRunning();
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    protected abstract void closeBeanFactory();

    @Override
    public abstract ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getDisplayName());
        sb.append(": startup date [").append(new Date(this.getStartupDate()));
        sb.append("]; ");
        ApplicationContext parent = this.getParent();
        if (parent == null) {
            sb.append("root of context hierarchy");
        } else {
            sb.append("parent: ").append(parent.getDisplayName());
        }
        return sb.toString();
    }

    private class ApplicationListenerDetector
    implements MergedBeanDefinitionPostProcessor {
        private final Map<String, Boolean> singletonNames = new ConcurrentHashMap<String, Boolean>();

        private ApplicationListenerDetector() {
        }

        public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
            if (beanDefinition.isSingleton()) {
                this.singletonNames.put(beanName, Boolean.TRUE);
            }
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof ApplicationListener) {
                Boolean flag = this.singletonNames.get(beanName);
                if (Boolean.TRUE.equals(flag)) {
                    AbstractApplicationContext.this.addApplicationListener((ApplicationListener)bean);
                } else if (flag == null) {
                    if (AbstractApplicationContext.this.logger.isWarnEnabled() && !AbstractApplicationContext.this.containsBean(beanName)) {
                        AbstractApplicationContext.this.logger.warn("Inner bean '" + beanName + "' implements ApplicationListener interface " + "but is not reachable for event multicasting by its containing ApplicationContext " + "because it does not have singleton scope. Only top-level listener beans are allowed " + "to be of non-singleton scope.");
                    }
                    this.singletonNames.put(beanName, Boolean.FALSE);
                }
            }
            return bean;
        }
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final ConfigurableListableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory beanFactory, int beanPostProcessorTargetCount) {
            this.beanFactory = beanFactory;
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean != null && !(bean instanceof BeanPostProcessor) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && AbstractApplicationContext.this.logger.isInfoEnabled()) {
                AbstractApplicationContext.this.logger.info("Bean '" + beanName + "' of type [" + bean.getClass() + "] is not eligible for getting processed by all BeanPostProcessors " + "(for example: not eligible for auto-proxying)");
            }
            return bean;
        }
    }
}

