/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Constants;

public class MBeanRegistrationSupport {
    public static final int REGISTRATION_FAIL_ON_EXISTING = 0;
    public static final int REGISTRATION_IGNORE_EXISTING = 1;
    public static final int REGISTRATION_REPLACE_EXISTING = 2;
    private static final Constants constants = new Constants(MBeanRegistrationSupport.class);
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MBeanServer server;
    protected final Set<ObjectName> registeredBeans = new LinkedHashSet<ObjectName>();
    private int registrationBehavior = 0;

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    public final MBeanServer getServer() {
        return this.server;
    }

    public void setRegistrationBehaviorName(String registrationBehavior) {
        this.setRegistrationBehavior(constants.asNumber(registrationBehavior).intValue());
    }

    public void setRegistrationBehavior(int registrationBehavior) {
        this.registrationBehavior = registrationBehavior;
    }

    protected void doRegister(Object mbean, ObjectName objectName) throws JMException {
        ObjectName actualObjectName;
        ObjectInstance registeredBean = null;
        try {
            registeredBean = this.server.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException ex) {
            if (this.registrationBehavior == 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Ignoring existing MBean at [" + objectName + "]");
                }
            }
            if (this.registrationBehavior == 2) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Replacing existing MBean at [" + objectName + "]");
                    }
                    this.server.unregisterMBean(objectName);
                    registeredBean = this.server.registerMBean(mbean, objectName);
                }
                catch (InstanceNotFoundException ex2) {
                    this.logger.error("Unable to replace existing MBean at [" + objectName + "]", ex2);
                    throw ex;
                }
            }
            throw ex;
        }
        ObjectName objectName2 = actualObjectName = registeredBean != null ? registeredBean.getObjectName() : null;
        if (actualObjectName == null) {
            actualObjectName = objectName;
        }
        this.registeredBeans.add(actualObjectName);
        this.onRegister(actualObjectName, mbean);
    }

    protected void unregisterBeans() {
        for (ObjectName objectName : this.registeredBeans) {
            this.doUnregister(objectName);
        }
        this.registeredBeans.clear();
    }

    protected void doUnregister(ObjectName objectName) {
        block5: {
            try {
                if (this.server.isRegistered(objectName)) {
                    this.server.unregisterMBean(objectName);
                    this.onUnregister(objectName);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Could not unregister MBean [" + objectName + "] as said MBean " + "is not registered (perhaps already unregistered by an external process)");
                }
            }
            catch (JMException ex) {
                if (!this.logger.isErrorEnabled()) break block5;
                this.logger.error("Could not unregister MBean [" + objectName + "]", ex);
            }
        }
    }

    protected final ObjectName[] getRegisteredObjectNames() {
        return this.registeredBeans.toArray(new ObjectName[this.registeredBeans.size()]);
    }

    protected void onRegister(ObjectName objectName, Object mbean) {
        this.onRegister(objectName);
    }

    protected void onRegister(ObjectName objectName) {
    }

    protected void onUnregister(ObjectName objectName) {
    }
}

