/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibase
implements InitializingBean,
BeanNameAware,
ResourceLoaderAware {
    private String beanName;
    private ResourceLoader resourceLoader;
    private DataSource dataSource;
    private Logger log = LogFactory.getLogger(SpringLiquibase.class.getName());
    private String changeLog;
    private String contexts;
    private Map<String, String> parameters;
    private String defaultSchema;
    private boolean dropFirst = false;
    private boolean shouldRun = true;
    private File rollbackFile;
    private boolean ignoreClasspathPrefix = true;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public String getDatabaseProductName() throws DatabaseException {
        Connection connection = null;
        String name2 = "unknown";
        try {
            connection = this.getDataSource().getConnection();
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(this.dataSource.getConnection()));
            name2 = database.getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.rollback();
                    }
                    connection.close();
                }
                catch (Exception e) {
                    this.log.warning("problem closing connection", e);
                }
            }
        }
        return name2;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String dataModel) {
        this.changeLog = dataModel;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    @Override
    public void afterPropertiesSet() throws LiquibaseException {
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            LogFactory.getLogger().info("Liquibase did not run because 'liquibase.should.run' system property was set to false");
            return;
        }
        if (!this.shouldRun) {
            LogFactory.getLogger().info("Liquibase did not run because 'shouldRun' property was set to false on " + this.getBeanName() + " Liquibase Spring bean.");
            return;
        }
        Connection c = null;
        Liquibase liquibase = null;
        try {
            c = this.getDataSource().getConnection();
            liquibase = this.createLiquibase(c);
            this.generateRollbackFile(liquibase);
            this.performUpdate(liquibase);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            if (c != null) {
                try {
                    if (!c.getAutoCommit()) {
                        c.rollback();
                    }
                }
                catch (SQLException e) {}
                try {
                    c.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private void generateRollbackFile(Liquibase liquibase) throws LiquibaseException {
        if (this.rollbackFile != null) {
            FileWriter output = null;
            try {
                output = new FileWriter(this.rollbackFile);
                liquibase.futureRollbackSQL(this.getContexts(), output);
            }
            catch (IOException e) {
                throw new LiquibaseException("Unable to generate rollback file.", e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    this.log.severe("Error closing output", e);
                }
            }
        }
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        liquibase.update(this.getContexts());
    }

    protected Liquibase createLiquibase(Connection c) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.getChangeLog(), (ResourceAccessor)this.createResourceOpener(), this.createDatabase(c));
        liquibase.setIgnoreClasspathPrefix(this.isIgnoreClasspathPrefix());
        if (this.parameters != null) {
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(c));
        if (StringUtils.trimToNull(this.defaultSchema) != null) {
            database.setDefaultSchemaName(this.defaultSchema);
        }
        return database;
    }

    public void setChangeLogParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    protected SpringResourceOpener createResourceOpener() {
        return new SpringResourceOpener(this.getChangeLog());
    }

    @Override
    public void setBeanName(String name2) {
        this.beanName = name2;
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    public boolean isIgnoreClasspathPrefix() {
        return this.ignoreClasspathPrefix;
    }

    public void setIgnoreClasspathPrefix(boolean ignoreClasspathPrefix) {
        this.ignoreClasspathPrefix = ignoreClasspathPrefix;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceLoader().toString() + ")";
    }

    public class SpringResourceOpener
    implements ResourceAccessor {
        private String parentFile;

        public SpringResourceOpener(String parentFile) {
            this.parentFile = parentFile;
        }

        @Override
        public InputStream getResourceAsStream(String file) throws IOException {
            try {
                Resource resource = this.getResource(file);
                return resource.getInputStream();
            }
            catch (FileNotFoundException ex) {
                return null;
            }
        }

        @Override
        public Enumeration<URL> getResources(String packageName) throws IOException {
            ArrayList<URL> tmp = new ArrayList<URL>();
            tmp.add(this.getResource(packageName).getURL());
            return Collections.enumeration(tmp);
        }

        public Resource getResource(String file) {
            return SpringLiquibase.this.getResourceLoader().getResource(this.adjustClasspath(file));
        }

        private String adjustClasspath(String file) {
            return this.isPrefixPresent(this.parentFile) && !this.isPrefixPresent(file) ? "classpath:" + file : file;
        }

        public boolean isPrefixPresent(String file) {
            return file.startsWith("classpath") || file.startsWith("file:") || file.startsWith("url:");
        }

        @Override
        public ClassLoader toClassLoader() {
            return SpringLiquibase.this.getResourceLoader().getClassLoader();
        }
    }
}

