/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;

public class Origin
implements Principal,
Serializable {
    static final long serialVersionUID = -6791417439972410727L;
    private static final char SEPARATOR = ':';
    private AuthType _authType;
    private InetAddress _address;

    public Origin(AuthType authType, InetAddress address) {
        this._authType = authType;
        this._address = address;
    }

    public Origin(AuthType authType, String host) throws UnknownHostException {
        this._authType = authType;
        this._address = InetAddress.getByName(host);
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }

    public AuthType getAuthType() {
        return this._authType;
    }

    public void setAuthType(AuthType authType) {
        this._authType = authType;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._authType != null) {
            sb.append(this._authType.getAbbreviation());
        }
        sb.append(':').append(this._address);
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)o;
        return other._authType == this._authType && other._address.equals(this._address);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int hashCode() {
        return this._address.hashCode();
    }

    public static enum AuthType {
        ORIGIN_AUTHTYPE_WEAK(0, 'W'),
        ORIGIN_AUTHTYPE_STRONG(1, 'S');

        private final int _value;
        private final char _abbreviation;

        private AuthType(int value, char abbreviation) {
            this._value = value;
            this._abbreviation = abbreviation;
        }

        public int getValue() {
            return this._value;
        }

        public char getAbbreviation() {
            return this._abbreviation;
        }

        public boolean equals(int value) {
            return this._value == value;
        }
    }
}

