/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfs.v4.client.cmd;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.dcache.chimera.nfs.v4.client.cmd.Args;
import org.dcache.chimera.nfs.v4.client.cmd.Command;

public class Processor {
    public static void main(String[] args) throws Exception {
        Method[] methods;
        ArrayListMultimap<String, Method> commands = ArrayListMultimap.create();
        Processor processor = new Processor();
        for (Method method : methods = processor.getClass().getMethods()) {
            Command command = method.getAnnotation(Command.class);
            if (command == null) continue;
            commands.put(command.name(), method);
            Processor.processMethod(method);
        }
        System.out.println(commands);
        Processor.scanCommand(processor, commands, new Args("help abcd me"));
        Processor.scanCommand(processor, commands, new Args("help abcd me 5"));
        Processor.scanCommand(processor, commands, new Args("help abcd me 5.2"));
    }

    @Command(name="help", description="A command help")
    public String help(String hello, String s, int n) {
        return hello + " " + s + " " + n;
    }

    @Command(name="help", description="A command help")
    public String help(String hello, String s, float n) {
        return hello + " " + s + " " + n;
    }

    @Command(name="help", description="A command help")
    public String help(String hello, String s) {
        return hello + " " + s;
    }

    private static void processMethod(Method method) {
        System.out.println(Arrays.toString(method.getGenericParameterTypes()));
    }

    public static void scanCommand(Object target, Multimap<String, Method> commands, Args args) throws Exception {
        String cmd = args.argv(0);
        int argc = args.argc() - 1;
        Collection<Method> candidates = commands.get(cmd);
        if (candidates != null) {
            for (Method m : candidates) {
                Type[] paramTypes = m.getGenericParameterTypes();
                if (paramTypes.length != argc) continue;
                Object[] params = new Object[argc];
                for (int i = 0; i < argc; ++i) {
                    params[i] = Processor.toType(paramTypes[i], args.argv(i + 1));
                }
                System.out.println(m.invoke(target, params));
                return;
            }
        }
        throw new IllegalArgumentException("no such command");
    }

    private static Object toType(Type type, String arg) {
        if (type == String.class) {
            return arg;
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(arg);
        }
        if (type == Long.TYPE) {
            return Long.parseLong(arg);
        }
        if (type == Short.TYPE) {
            return Short.parseShort(arg);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(arg);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(arg));
        }
        throw new IllegalArgumentException("can't detect type for: " + type);
    }
}

