/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMap<K, V> {
    private static final long serialVersionUID = -446090383728952825L;
    private static final Logger _log = LoggerFactory.getLogger(CacheMap.class);
    private final Map<K, V> _elements = new ConcurrentHashMap();
    private final ScheduledExecutorService _cleaner = new ScheduledThreadPoolExecutor(2);

    public V put(final K key, V value, long timeout) {
        V ce = this._elements.put(key, value);
        this._cleaner.schedule(new Runnable(){

            @Override
            public void run() {
                if (CacheMap.this._elements.remove(key) != null) {
                    _log.debug("removing cache value for key" + key);
                }
            }
        }, timeout, TimeUnit.SECONDS);
        return ce;
    }

    public V remove(K key) {
        return this._elements.remove(key);
    }

    public V get(K key) {
        return this._elements.get(key);
    }

    public boolean isEmpty() {
        return this._elements.isEmpty();
    }

    public void clear() {
        this._elements.clear();
    }

    public static void main(String[] args) {
        try {
            CacheMap<String, String> map = new CacheMap<String, String>();
            map.put("o1", "o1", 10L);
            boolean b1 = map.isEmpty();
            Thread.sleep(11000L);
            boolean b2 = map.isEmpty();
            System.out.println("b1 = " + b1);
            System.out.println("b2 = " + b2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

