/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class PrimaryKey
extends AbstractDatabaseObject {
    public PrimaryKey() {
        this.setAttribute("columnNames", new ArrayList());
    }

    @Override
    public DatabaseObject[] getContainingObjects() {
        return new DatabaseObject[]{this.getTable()};
    }

    @Override
    public String getName() {
        return this.getAttribute("name", String.class);
    }

    public PrimaryKey setName(String name2) {
        this.setAttribute("name", name2);
        return this;
    }

    @Override
    public Schema getSchema() {
        if (this.getTable() == null) {
            return null;
        }
        return this.getTable().getSchema();
    }

    public String getColumnNames() {
        return StringUtils.join(this.getColumnNamesAsList(), ", ");
    }

    public PrimaryKey addColumnName(int position, String columnName) {
        if (position >= this.getColumnNamesAsList().size()) {
            for (int i = this.getColumnNamesAsList().size() - 1; i < position; ++i) {
                this.getColumnNamesAsList().add(null);
            }
        }
        this.getColumnNamesAsList().set(position, columnName);
        return this;
    }

    public Table getTable() {
        return this.getAttribute("table", Table.class);
    }

    public PrimaryKey setTable(Table table) {
        this.setAttribute("table", table);
        return this;
    }

    @Override
    public int compareTo(Object other) {
        PrimaryKey o = (PrimaryKey)other;
        int returnValue = this.getTable().getName().compareTo(o.getTable().getName());
        if (returnValue == 0) {
            returnValue = this.getColumnNames().compareTo(o.getColumnNames());
        }
        return returnValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaryKey that = (PrimaryKey)o;
        return !(this.getColumnNames() == null ? that.getColumnNames() != null : !this.getColumnNames().equals(that.getColumnNames())) && !(this.getTable().getName() == null ? that.getTable().getName() != null : !this.getTable().getName().equals(that.getTable().getName()));
    }

    public int hashCode() {
        int result = this.getColumnNames() != null ? this.getColumnNames().hashCode() : 0;
        result = 31 * result + (this.getTable().getName() != null ? this.getTable().getName().hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getName() + " on " + this.getTable().getName() + "(" + this.getColumnNames() + ")";
    }

    public List<String> getColumnNamesAsList() {
        return this.getAttribute("columnNames", List.class);
    }

    public boolean isCertainName() {
        return this.getAttribute("certainName", Boolean.class);
    }

    public PrimaryKey setCertainName(boolean certainName) {
        this.setAttribute("certainName", certainName);
        return this;
    }

    public String getTablespace() {
        return this.getAttribute("tablespace", String.class);
    }

    public PrimaryKey setTablespace(String tablespace) {
        this.setAttribute("tablespace", tablespace);
        return this;
    }

    public Index getBackingIndex() {
        return this.getAttribute("backingIndex", Index.class);
    }

    public PrimaryKey setBackingIndex(Index backingIndex) {
        this.setAttribute("backingIndex", backingIndex);
        return this;
    }
}

